/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SocketSet.c>	2005-03-13,14:56

*/

#include "SipSocketSet.h"





/* SipSocketSet members
*/
HS_RESULT new_SipSocketSet(void *pObject, HS_TR_HANDLE pHandle)
{
	SipSocketSet *pObj = (SipSocketSet*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mSocket = INVALID_SOCKET;
	pObj->mHandle = pHandle;
	pObj->mReady = NULL;

	return HS_OK;
}


HS_RESULT delete_SipSocketSet(void *pObject)
{
	SipSocketSet *pObj = (SipSocketSet*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mSocket != INVALID_SOCKET )
	{
		closesocket(pObj->mSocket);
		pObj->mSocket= INVALID_SOCKET;
	}
	pObj->mHandle = HS_INVALID_HANDLE;
	if( pObj->mReady != NULL )
	{
		deletem_QmEnetMessage(pObj->mReady);
		pObj->mReady = NULL;
	}
	return HS_OK;
}


HS_RESULT SipSocketSet_FdSet(void *pObject, fd_set *pSet, unsigned int *pMax)
{
	SipSocketSet *pObj = (SipSocketSet*)pObject;
	unsigned int tMax;

	if( pObj==NULL || pSet==NULL || pMax==NULL ) return HS_ERR_NULL_PARAM;

	tMax = *pMax;

	if( pObj->mSocket != INVALID_SOCKET )
	{
		FD_SET(pObj->mSocket,pSet);
		if( pObj->mSocket > tMax ) tMax = pObj->mSocket;
	}
	
	*pMax = tMax;
	return HS_OK;
}


HS_RESULT SipSocketSet_FdIsSet(void *pObject, fd_set *pSet, HS_QID pDestQ, HS_UCHAR *pBuffer, int pLen)
{
	int tLen;
	struct sockaddr_in tAddrIn;
	QmEnetMessage *tEnetMessage = NULL;
	SipSocketSet *pObj = (SipSocketSet*)pObject;

	if( pObj==NULL || pSet==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSocket==INVALID_SOCKET ) return HS_OK;
	if( FD_ISSET(pObj->mSocket,pSet)==FALSE ) return HS_OK;

	/* valid data
	*/
	if( (tLen = recv(pObj->mSocket, pBuffer, pLen, 0)) > 0 )
	{
#ifdef HS_SOCKET_DEBUG
		HSPrint( "\n packet received (%d)", tLen );
#endif
		tAddrIn.sin_family = AF_MAX;
		if( (tEnetMessage=newm_QmEnetMessage(pBuffer,tLen,pObj->mHandle,tAddrIn))!=NULL )
			_HSThreadSendMessage(pDestQ,HS_QM_ENET_MESSAGE,0,(LPARAM)tEnetMessage);
		return HS_OK;
	}

	/* invalid data - socket closed
	*/
#ifdef HS_SOCKET_DEBUG
	HSPrint( "\n socket closed" );
#endif
	closesocket(pObj->mSocket);
	pObj->mSocket = INVALID_SOCKET;
	_HSThreadSendMessage(pDestQ,HS_QM_REMOVE_SOCKET_SET,0,pObj->mHandle);
	return HS_OK_SIP;
}





/* NoLockList member
*/
ChainUnit *NoLockList_FindSipSocketSetByHandle(NoLockList *pObj, HS_TR_HANDLE pHandle)
{
	HS_UINT i;
	ChainUnit *tChain = NULL;
	SipSocketSet *tSocketSet = NULL;

	if( pObj==NULL ) return NULL;
	if( pObj->size==0 ) return NULL;

	tChain = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( tChain==NULL ) return NULL;
		if( (tSocketSet=(SipSocketSet*)(tChain->data))==NULL ) return NULL;

		if( tSocketSet->mHandle == pHandle )
			return tChain;
		tChain = (ChainUnit*)(tChain->next);
	}

	return NULL;
}


HS_RESULT NoLockList_SipFdSet(NoLockList *pObj, fd_set *pSet, HS_UINT *pMax)
{
	HS_UINT i;
	ChainUnit *tChain = NULL;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->size==0 ) return HS_OK;

	tChain = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( tChain == NULL ) return HS_ERR_CONFLICT;
		if( tChain->data == NULL ) return HS_ERR_CONFLICT;

		SipSocketSet_FdSet(tChain->data, pSet, pMax);
		tChain = tChain->next;
	}

	return HS_OK;
}


HS_RESULT NoLockList_SipFdIsSet(NoLockList *pObj, fd_set *pSet, HS_QID pSipDemonQ, HS_UCHAR *pBuffer, int pLen)
{
	ChainUnit *tChain = NULL;
	ChainUnit *tDeleter = NULL;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->size==0 ) return HS_OK;

	tChain = pObj->units;
	while(tChain!=NULL)
	{
		if( tChain==NULL ) return HS_ERR_CONFLICT;
		if( tChain->data==NULL ) return HS_ERR_CONFLICT;

		tDeleter = NULL;
		if( SipSocketSet_FdIsSet(tChain->data,pSet,pSipDemonQ,pBuffer,pLen) == HS_OK_SIP )
			tDeleter = tChain;

		tChain = (ChainUnit*)(tChain->next);
		if( tDeleter != NULL )
			NoLockList_DeleteChain(pObj,tChain);
	}

	return HS_OK;
}





