/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipUtility.c>		2005-10-18,22:09

*/

#include "SipUtility.h"





HS_RESULT SipRecordRoutes2SipRoutes(NoLockList *pTo, NoLockList *pFrom)
{
	HS_UINT i;
	char tString[512];
	ChainUnit *tChain = NULL;
	SipRoute *tRoute = NULL;
	SipRecordRoute *tRecordRoute = NULL;

	if( pTo==NULL || pFrom==NULL ) return HS_ERR_NULL_PARAM;

	NoLockList_Clear(pTo);
	tChain = pFrom->units;
	for( i=0; i<pFrom->size; i++ )
	{
		if( tChain==NULL )
			return HS_ERR_CONFLICT;
		if( (tRecordRoute=(SipRecordRoute*)(tChain->data))==NULL )
			return HS_ERR_CONFLICT;

		if( (tRoute=(SipRoute*)HSMalloc(sizeof(SipRoute)))==NULL )
			return HS_ERR_MALLOC;
		new_SipRoute(tRoute);

		memset(tString,0,512);
		if( SipRecordRoute_Encode(tRecordRoute,tString,500) != HS_OK )
		{
			delete_SipRoute(tRoute);
			HSFree(tRoute);
			return HS_ERR;
		}

		/* converting
		*/
		strcpy(tRoute->mHeaderName,HS_RECORD_ROUTE_HEADER);
		if( SipRoute_Decode(tRoute,tString,strlen(tString)) != HS_OK )
		{
			delete_SipRoute(tRoute);
			HSFree(tRoute);
			return HS_ERR;
		}
		strcpy(tRoute->mHeaderName,HS_ROUTE_HEADER);
		NoLockList_AttachData(pTo,tRoute);

		tChain = (ChainUnit*)(tChain->next);
	}

	return HS_OK;
}





/* copy functions
*/
HS_RESULT SipUri_Copy(SipUri *pTo, SipUri *pFrom)
{
	if( pTo==NULL || pFrom==NULL ) return HS_ERR_NULL_PARAM;

	if( pTo->mAddress != NULL )		{	HSFree(pTo->mAddress);	pTo->mAddress=NULL;	}
	if( pTo->mBranch != NULL )		{	HSFree(pTo->mBranch);		pTo->mBranch=NULL;	}
	if( pTo->mMaddr != NULL )		{	HSFree(pTo->mMaddr);		pTo->mMaddr=NULL;	}
	if( pTo->mProtocol != NULL )	{	HSFree(pTo->mProtocol);	pTo->mProtocol=NULL;}
	if( pTo->mReceived != NULL )	{	HSFree(pTo->mReceived);	pTo->mReceived=NULL;}
	if( pTo->mSubject != NULL )		{	HSFree(pTo->mSubject);	pTo->mSubject=NULL;	}
	if( pTo->mTransactionType != NULL )
	{
		HSFree(pTo->mTransactionType);
		pTo->mTransactionType=NULL;
	}
	if( pTo->mTtl != NULL )			{	HSFree(pTo->mTtl);		pTo->mTtl=NULL;		}
	if( pTo->mUserName != NULL )	{	HSFree(pTo->mUserName);	pTo->mUserName=NULL;}
	if( pTo->mVersion != NULL )		{	HSFree(pTo->mVersion);	pTo->mVersion=NULL;	}

	if( pFrom->mAddress != NULL )
		pTo->mAddress = SipStringAlloc(pFrom->mAddress);
	if( pFrom->mBranch != NULL )
		pTo->mBranch = SipStringAlloc(pFrom->mBranch);
	if( pFrom->mMaddr != NULL )
		pTo->mMaddr = SipStringAlloc(pFrom->mMaddr);
	if( pFrom->mProtocol != NULL )
		pTo->mProtocol = SipStringAlloc(pFrom->mProtocol);
	if( pFrom->mReceived != NULL )
		pTo->mReceived = SipStringAlloc(pFrom->mReceived);
	if( pFrom->mSubject != NULL )
		pTo->mSubject = SipStringAlloc(pFrom->mSubject);
	if( pFrom->mTransactionType != NULL )
		pTo->mTransactionType = SipStringAlloc(pFrom->mTransactionType);
	if( pFrom->mTtl != NULL )
		pTo->mTtl = SipStringAlloc(pFrom->mTtl);
	if( pFrom->mUserName != NULL )
		pTo->mUserName = SipStringAlloc(pFrom->mUserName);
	if( pFrom->mVersion != NULL )
		pTo->mVersion = SipStringAlloc(pFrom->mVersion);
	if( pFrom->mPort != NULL )
		pTo->mPort = SipStringAlloc(pFrom->mPort);

	pTo->mIsVia = pFrom->mIsVia;
	pTo->mLooseRoute = pFrom->mLooseRoute;
	return HS_OK;
}


HS_RESULT SipContacts_Copy(NoLockList *pTo, NoLockList *pFrom)
{
	HS_UINT i;
	char tString[512];
	ChainUnit *tChain = NULL;
	SipContact *tContactTo = NULL;
	SipContact *tContactFrom = NULL;

	if( pTo==NULL || pFrom==NULL ) return HS_ERR_NULL_PARAM;

	NoLockList_Clear(pTo);
	tChain = pFrom->units;
	for( i=0; i<pFrom->size; i++ )
	{
		if( tChain==NULL )
			return HS_ERR_CONFLICT;
		if( (tContactFrom=(SipContact*)(tChain->data))==NULL )
			return HS_ERR_CONFLICT;

		if( (tContactTo=(SipContact*)HSMalloc(sizeof(SipContact)))==NULL )
			return HS_ERR_MALLOC;
		new_SipContact(tContactTo);

		memset(tString,0,512);
		if( SipContact_Encode(tContactFrom,tString,500) != HS_OK )
		{
			delete_SipContact(tContactTo);
			HSFree(tContactTo);
			return HS_ERR;
		}
		if( SipContact_Decode(tContactTo,tString,strlen(tString)) != HS_OK )
		{
			delete_SipContact(tContactTo);
			HSFree(tContactTo);
			return HS_ERR;
		}
		NoLockList_AttachData(pTo,tContactTo);

		tChain = (ChainUnit*)(tChain->next);
	}

	return HS_OK;
}
HS_RESULT SipVias_Copy(NoLockList *pTo, NoLockList *pFrom)
{
	HS_UINT i;
	char tString[512];
	ChainUnit *tChain = NULL;
	SipVia *tViaTo = NULL;
	SipVia *tViaFrom= NULL;

	if( pTo==NULL || pFrom==NULL ) return HS_ERR_NULL_PARAM;

	NoLockList_Clear(pTo);
	tChain = pFrom->units;
	for( i=0; i<pFrom->size; i++ )
	{
		if( tChain==NULL )
			return HS_ERR_CONFLICT;
		if( (tViaFrom=(SipVia*)(tChain->data))==NULL )
			return HS_ERR_CONFLICT;

		if( (tViaTo=(SipVia*)HSMalloc(sizeof(SipVia)))==NULL )
			return HS_ERR_MALLOC;
		new_SipVia(tViaTo);

		memset(tString,0,512);
		if( SipContact_Encode(tViaFrom,tString,500) != HS_OK )
			return HS_ERR;
		if( SipContact_Decode(tViaTo,tString,strlen(tString)) != HS_OK )
			return HS_ERR;
		NoLockList_AttachData(pTo,tViaTo);

		tChain = (ChainUnit*)(tChain->next);
	}

	return HS_OK;
}
HS_RESULT SipRoutes_Copy(NoLockList *pTo, NoLockList *pFrom)
{
	HS_UINT i;
	char tString[512];
	ChainUnit *tChain = NULL;
	SipRoute *tRouteTo = NULL;
	SipRoute *tRouteFrom = NULL;

	if( pTo==NULL || pFrom==NULL ) return HS_ERR_NULL_PARAM;

	NoLockList_Clear(pTo);
	tChain = pFrom->units;
	for( i=0; i<pFrom->size; i++ )
	{
		if( tChain==NULL )
			return HS_ERR_CONFLICT;
		if( (tRouteFrom=(SipRoute*)(tChain->data))==NULL )
			return HS_ERR_CONFLICT;

		if( (tRouteTo=(SipRoute*)HSMalloc(sizeof(SipRoute)))==NULL )
			return HS_ERR_MALLOC;
		new_SipRoute(tRouteTo);

		memset(tString,0,512);
		if( SipRoute_Encode(tRouteFrom,tString,500) != HS_OK )
		{
			delete_SipRoute(tRouteTo);
			HSFree(tRouteTo);
			return HS_ERR;
		}
		if( SipRoute_Decode(tRouteTo,tString,strlen(tString)) != HS_OK )
		{
			delete_SipRoute(tRouteTo);
			HSFree(tRouteTo);
			return HS_ERR;
		}
		NoLockList_AttachData(pTo,tRouteTo);

		tChain = (ChainUnit*)(tChain->next);
	}

	return HS_OK;
}


HS_RESULT SipAuthorization_Copy(SipAuthorization *pTo, SipAuthorization *pFrom)
{
	if( pTo==NULL || pFrom==NULL ) return HS_ERR_NULL_PARAM;

	pTo->mAlgorithm = SipStringAlloc(pFrom->mAlgorithm);
	pTo->mCnonce = SipStringAlloc(pFrom->mCnonce);
	pTo->mNc = SipStringAlloc(pFrom->mNc);
	pTo->mNonce = SipStringAlloc(pFrom->mNonce);
	pTo->mOpaque = SipStringAlloc(pFrom->mOpaque);
	pTo->mQop = SipStringAlloc(pFrom->mQop);
	pTo->mRealm = SipStringAlloc(pFrom->mRealm);
	pTo->mResponse = SipStringAlloc(pFrom->mResponse);
	pTo->mStale = SipStringAlloc(pFrom->mStale);
	pTo->mType = SipStringAlloc(pFrom->mType);
	pTo->mUri = SipStringAlloc(pFrom->mUri);
	pTo->mUserName = SipStringAlloc(pFrom->mUserName);
	return HS_OK;
}





/* clone functions
*/
SipAuthorization *SipAuthorization_Clone(SipAuthorization *pObj, AuthType pType)
{
	SipAuthorization *tResult = NULL;

	switch(pType)
	{
		case e_AuthType_Request:		tResult=newm_SipWWWAuthenticate();		break;
		case e_AuthType_Response:		tResult=newm_SipAuthorization();		break;
		case e_AuthType_ProxyRequest:	tResult=newm_SipProxyAuthenticate();	break;
		case e_AuthType_ProxyResponse:	tResult=newm_SipProxyAuthorization();	break;
		default:	return NULL;
	}

	if( tResult==NULL ) return NULL;

	if( SipAuthorization_Copy(tResult,pObj)!=HS_OK )
	{
		deletem_SipAuthorization(tResult);
		return NULL;
	}

	return tResult;
}





/* etc
*/
HS_RESULT RegulatingCopiedVia(NoLockList *pVias)
{
	HS_UINT i, j;
	ChainUnit *tChain_i = NULL;
	ChainUnit *tChain_j = NULL;
	SipVia *tVia = NULL;
	SipContactUnit *tUnit = NULL;

	if( pVias==NULL ) return HS_ERR_NULL_PARAM;

	tChain_i = pVias->units;
	for( i=0; i<pVias->size; i++ )
	{
		if( tChain_i==NULL ) return HS_ERR_CONFLICT;
		if( (tVia=(SipVia*)(tChain_i->data))==NULL ) return HS_ERR_CONFLICT;

		tChain_j = tVia->mContactUnits.units;
		for( j=0; j<tVia->mContactUnits.size; j++ )
		{
			if( tChain_j==NULL ) return HS_ERR_CONFLICT;
			if( (tUnit=(SipContactUnit*)(tChain_j->data))==NULL ) return HS_ERR_CONFLICT;

			if( tUnit->mUri.mReceived != NULL )
			{
				HSFree(tUnit->mUri.mReceived);
				tUnit->mUri.mReceived = NULL;
			}

			tChain_j = (ChainUnit*)(tChain_j->next);
		}

		tChain_i = (ChainUnit*)(tChain_i->next);
	}

	return HS_OK;
}



