/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<MediaNego.c>		2005-04-24,16:53

*/

#include "MediaNego.h"



/******************************************************************************/
/* Capability Compare Functions
*/
BOOL AppCompareAudioCapability( ASNH245AudioCapability *pAudio1, ASNH245AudioCapability *pAudio2 )
{
	if( pAudio1==HS_NULL || pAudio2==HS_NULL ) return HS_NO;
	if( pAudio1->choice != pAudio2->choice ) return HS_NO;

	switch( pAudio1->choice )
	{
		case e_ASNH245AudioCapabilityChoice_g711Alaw64k:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g711Ulaw64k:	return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g7231:			return HS_YES;
		case e_ASNH245AudioCapabilityChoice_g729:			return HS_YES;
	}
	return HS_NO;
}


static BOOL AppCompareVideoCapability( ASNH245VideoCapability *pVideo1, ASNH245VideoCapability *pVideo2 )
{
	return HS_NO;
}


static BOOL AppCompareDataApplicationCapability(
	ASNH245DataApplicationCapability *pData1,
	ASNH245DataApplicationCapability *pData2
)
{
	return HS_NO;
}


static BOOL AppCompareCapability( ASNH245Capability *pCapa1, ASNH245Capability *pCapa2 )
{
	if( pCapa1 == HS_NULL || pCapa2 == HS_NULL ) return HS_NO;

	switch( pCapa1->choice )
	{
		case e_ASNH245CapabilityChoice_receiveVideoCapability:
		case e_ASNH245CapabilityChoice_transmitVideoCapability:
		case e_ASNH245CapabilityChoice_receiveAndTransmitVideoCapability:
			if( pCapa2->choice == e_ASNH245CapabilityChoice_receiveVideoCapability ||
				pCapa2->choice == e_ASNH245CapabilityChoice_transmitVideoCapability ||
				pCapa2->choice == e_ASNH245CapabilityChoice_receiveAndTransmitVideoCapability
			) return AppCompareVideoCapability( pCapa1->alter, pCapa2->alter );
			break;
		case e_ASNH245CapabilityChoice_receiveAudioCapability:
		case e_ASNH245CapabilityChoice_transmitAudioCapability:
		case e_ASNH245CapabilityChoice_receiveAndTransmitAudioCapability:
			if( pCapa2->choice == e_ASNH245CapabilityChoice_receiveAudioCapability ||
				pCapa2->choice == e_ASNH245CapabilityChoice_transmitAudioCapability ||
				pCapa2->choice == e_ASNH245CapabilityChoice_receiveAndTransmitAudioCapability
			) return AppCompareAudioCapability( pCapa1->alter, pCapa2->alter );
			break;
		case e_ASNH245CapabilityChoice_receiveDataApplicationCapability:
		case e_ASNH245CapabilityChoice_transmitDataApplicationCapability:
		case e_ASNH245CapabilityChoice_receiveAndTransmitDataApplicationCapability:
			if( pCapa2->choice == e_ASNH245CapabilityChoice_receiveDataApplicationCapability ||
				pCapa2->choice == e_ASNH245CapabilityChoice_transmitDataApplicationCapability ||
				pCapa2->choice == e_ASNH245CapabilityChoice_receiveAndTransmitDataApplicationCapability
			) return AppCompareDataApplicationCapability( pCapa1->alter, pCapa2->alter );
			break;
	}
	return HS_NO;
}


static BOOL AppCompareCapabilityWithDataType( ASNH245Capability *pCapa, ASNH245DataType *pType )
{
	if( pCapa == HS_NULL || pType == HS_NULL ) return HS_NO;

	switch( pCapa->choice )
	{
		case e_ASNH245CapabilityChoice_receiveVideoCapability:
		case e_ASNH245CapabilityChoice_transmitVideoCapability:
		case e_ASNH245CapabilityChoice_receiveAndTransmitVideoCapability:
			if( pType->choice == e_ASNH245DataTypeChoice_videoData )
				return AppCompareVideoCapability( pCapa->alter, pType->alter );
			break;
		case e_ASNH245CapabilityChoice_receiveAudioCapability:
		case e_ASNH245CapabilityChoice_transmitAudioCapability:
		case e_ASNH245CapabilityChoice_receiveAndTransmitAudioCapability:
			if( pType->choice == e_ASNH245DataTypeChoice_audioData )
				return AppCompareAudioCapability( pCapa->alter, pType->alter );
			break;
		case e_ASNH245CapabilityChoice_receiveDataApplicationCapability:
		case e_ASNH245CapabilityChoice_transmitDataApplicationCapability:
		case e_ASNH245CapabilityChoice_receiveAndTransmitDataApplicationCapability:
			if( pType->choice == e_ASNH245DataTypeChoice_data )
				return AppCompareDataApplicationCapability( pCapa->alter, pType->alter );
			break;
	}
	return HS_NO;
}



/***********************************************************************/
/* FastStart Check Functions
*/
static HS_RESULT AppCheckFastStartUnit(AsnOctetString *pOctetString, ICall *pCall, MediaChannelState *pState )
{
	HS_UINT i;
	ChainUnit *tChain = HS_NULL;
	ICapability *tCapa = HS_NULL;
	NoLockList *tCapas = HS_NULL;

	AsnStream tStrm;
	ASNH245OpenLogicalChannel *olc = HS_NULL;

	/*validation check*/
	if( pOctetString==HS_NULL || pCall==HS_NULL || pState==HS_NULL) return HS_ERR_NULL_PARAM;
	if( pOctetString->length==0 || pOctetString->value==HS_NULL )
	{
#ifdef HS_DEBUG_H323
		HSPrint( "\n [APP] Error: Null FastStart Unit." );
#endif
		return HS_ERR_NULL_PARAM;
	}
	tCapas = &(pCall->capabilities);

	/*decode faststart unit*/
	olc = (ASNH245OpenLogicalChannel*)HSMalloc( sizeof(ASNH245OpenLogicalChannel) );
	if( olc == HS_NULL ) return HS_ERR_H323_MALLOC;

	new_ASNH245OpenLogicalChannel(olc);
	ASNH245OpenLogicalChannel_MakeMold(olc);
	new_AsnStream(&tStrm, pOctetString->length, TRUE);
	memcpy(tStrm.datas, pOctetString->value, pOctetString->length);

	if( ASNH245OpenLogicalChannel_Decode(olc,&tStrm) != HS_OK )
	{
		delete_ASNH245OpenLogicalChannel(olc);
		HSFree(olc);
		delete_AsnStream(&tStrm);

		/*
			if it is a calling endpoint, faststart unit is a response value.
			so, call must stopped.
			otherwise it is a called endpoint, faststart unit is a request value.
			and be able to skip one or more..
		*/
		if( pCall->isAnswerCall ) return HS_OK;
		else					  return HS_ERR_H323_MAKE_MESSAGE;
	}

	/*check reverse logical channel*/
	if( ASNH245OpenLogicalChannel_IsIncludeOptionField(olc, e_ASNH245OpenLogicalChannelOptionMap_reverseLogicalChannelParameters ) &&
		olc->m_reverseLogicalChannelParameters.m_dataType.choice != e_ASNH245DataTypeChoice_nullData
	)
	{
		/*channel selected already*/
		if( (olc->m_reverseLogicalChannelParameters.m_dataType.choice == e_ASNH245DataTypeChoice_audioData &&
			 pState->rAudio == HS_YES ) ||
			(olc->m_reverseLogicalChannelParameters.m_dataType.choice == e_ASNH245DataTypeChoice_videoData &&
			 pState->rVideo == HS_YES ) ||
			(olc->m_reverseLogicalChannelParameters.m_dataType.choice == e_ASNH245DataTypeChoice_data &&
			 pState->rData == HS_YES )
		)
		{
			delete_ASNH245OpenLogicalChannel(olc);
			HSFree(olc);
			delete_AsnStream(&tStrm);
			return HS_OK;
		}

		/*select channel*/
		for( i=0; i<tCapas->size; i++ )
		{
			tChain = NoLockList_GetChain(tCapas, i);
			if( tChain == HS_NULL ) continue;

			tCapa = (ICapability*)(tChain->data);
			if( tCapa == HS_NULL ) continue;

			if( AppCompareCapabilityWithDataType( &(tCapa->capability), &(olc->m_reverseLogicalChannelParameters.m_dataType) ) == HS_YES )
			{
				switch( olc->m_reverseLogicalChannelParameters.m_dataType.choice )
				{
					case e_ASNH245DataTypeChoice_videoData:	pState->rVideo = HS_YES;	break;
					case e_ASNH245DataTypeChoice_audioData:	pState->rAudio = HS_YES;	break;
					case e_ASNH245DataTypeChoice_data:		pState->rData = HS_YES;		break;
					default:
						/*abnormal case*/
						delete_ASNH245OpenLogicalChannel(olc);
						HSFree(olc);
						delete_AsnStream(&tStrm);
						return HS_ERR_H323;
				}

				delete_AsnStream(&tStrm);
				return HapiAddReverseFastStart(pCall, olc);
			}
		}
	}

	/*check forward logical channel*/
	if( olc->m_forwardLogicalChannelParameters.m_dataType.choice != e_ASNH245DataTypeChoice_nullData )
	{
		/*channel selected already*/
		if( (olc->m_forwardLogicalChannelParameters.m_dataType.choice == e_ASNH245DataTypeChoice_audioData &&
			 pState->sAudio == HS_YES ) ||
			(olc->m_forwardLogicalChannelParameters.m_dataType.choice == e_ASNH245DataTypeChoice_videoData &&
			 pState->sVideo == HS_YES ) ||
			(olc->m_forwardLogicalChannelParameters.m_dataType.choice == e_ASNH245DataTypeChoice_data &&
			 pState->sData == HS_YES )
		)
		{
			delete_ASNH245OpenLogicalChannel(olc);
			HSFree(olc);
			delete_AsnStream(&tStrm);
			return HS_OK;
		}

		/*select channel*/
		for( i=0; i<tCapas->size; i++ )
		{
			tChain = NoLockList_GetChain(tCapas, i);
			if( tChain == HS_NULL ) continue;

			tCapa = (ICapability*)(tChain->data);
			if( tCapa == HS_NULL ) continue;

			if( AppCompareCapabilityWithDataType( &(tCapa->capability), &(olc->m_forwardLogicalChannelParameters.m_dataType) ) == HS_YES )
			{
				switch( olc->m_forwardLogicalChannelParameters.m_dataType.choice )
				{
					case e_ASNH245DataTypeChoice_videoData:	pState->sVideo = HS_YES;	break;
					case e_ASNH245DataTypeChoice_audioData:	pState->sAudio = HS_YES;	break;
					case e_ASNH245DataTypeChoice_data:		pState->sData = HS_YES;		break;
					default:
						/*abnormal case*/
						delete_ASNH245OpenLogicalChannel(olc);
						HSFree(olc);
						delete_AsnStream(&tStrm);
						return HS_ERR_H323;
				}

				delete_AsnStream(&tStrm);
				return HapiAddForwardFastStart(pCall, olc);
			}
		}
	}

	/*
		if it is a calling endpoint, faststart unit is a response value.
		so, call must stopped.
		otherwise it is a called endpoint, faststart unit is a request value.
		and be able to skip one or more..
	*/
	delete_AsnStream(&tStrm);
	if( pCall->isAnswerCall ) return HS_OK;
	else					  return HS_ERR_H323_NOTFOUND;
}


HS_RESULT AppCheckFastStart(AsnSequenceOf *pSequenceOf, NoLockList *pCapas, ICall *pCall)
{
	HS_UINT i;
	HS_RESULT tRet = HS_OK;
	MediaChannelState mState;

	if( pSequenceOf==HS_NULL || pCapas==HS_NULL || pCall==HS_NULL ) return HS_ERR_NULL_PARAM;
	if( pSequenceOf->size==0 || pCapas->size==0 ) return HS_ERR_H323_NOUNIT;

	new_MediaChannelState(&mState);
	for( i=0; i<pSequenceOf->size; i++ )
	{
		tRet = AppCheckFastStartUnit(AsnSequenceOf_GetUnit(pSequenceOf,i), pCall, &mState);
		if( tRet != HS_OK )
		{
			new_MediaChannelState(&mState);
			return tRet;
		}
	}	

	new_MediaChannelState(&mState);
	if( pCall->fsList.size == 0 ) return HS_ERR_H323_NOTFOUND;
	return HS_OK;
}



/*********************************************************************************/
/* TerminalCapabilitySet Check Functions
*/
static HS_RESULT AppCheckTerminalCapabilitySetUnit(
	HS_STACK_HANDLE hStack, IEndpoint *pEndpoint, ICall *pCall,
	ASNH245CapabilityTableEntry *cte, MediaChannelState *pState
)
{
	HS_UINT i;
	HS_RESULT tRet = HS_OK;
	ChainUnit *rounder = HS_NULL;
	ICapability *tCapa = HS_NULL;
	NoLockList *tCapas = HS_NULL;
	OpenLogicalChannelSet *tOlcSet = HS_NULL;

	if( cte==HS_NULL || hStack==HS_INVALID_STACK_HANDLE || pCall==HS_NULL || pState==HS_NULL )
		return HS_ERR_NULL_PARAM;
	if( pCall->capabilities.size == 0 ) return HS_ERR_H323_NOUNIT;

	if(cte->m_capability.choice > e_ASNH245CapabilityChoice_nonStandard)
	{
		if( cte->m_capability.choice < e_ASNH245CapabilityChoice_receiveAudioCapability &&
			pState->sVideo == HS_YES ) return HS_ERR_H323_NOTFOUND;
		else if(cte->m_capability.choice < e_ASNH245CapabilityChoice_receiveDataApplicationCapability &&
			pState->sAudio == HS_YES ) return HS_ERR_H323_NOTFOUND;
		else if(cte->m_capability.choice < e_ASNH245CapabilityChoice_h233EncryptionTransmitCapability &&
			pState->sData == HS_YES ) return HS_ERR_H323_NOTFOUND;
	}
	tCapas = &(pCall->capabilities);

	rounder = tCapas->units;
	for( i=0; i<tCapas->size; i++ )
	{
		if( rounder == HS_NULL ) return HS_ERR_H323_CONFLICT;
		if( rounder->data == HS_NULL ) return HS_ERR_H323_CONFLICT;

		tCapa = (ICapability*)(rounder->data);
		if( AppCompareCapability(&(cte->m_capability), &(tCapa->capability)) )
		{
			if( (tRet=HapiAddOpenLogicalChannel(pEndpoint, pCall, tCapa)) != HS_OK ) return tRet;

			if( tCapa->capability.choice > e_ASNH245CapabilityChoice_nonStandard )
			{
				if( tCapa->capability.choice < e_ASNH245CapabilityChoice_receiveAudioCapability )
					pState->sVideo = HS_YES;
				else if( tCapa->capability.choice < e_ASNH245CapabilityChoice_receiveDataApplicationCapability )
					pState->sAudio = HS_YES;
				else if( tCapa->capability.choice < e_ASNH245CapabilityChoice_h233EncryptionTransmitCapability )
					pState->sData = HS_YES;
			}
		}

		rounder = rounder->next;
	}

	return HS_ERR_H323_NOTFOUND;
}


HS_RESULT AppCheckTerminalCapabilitySet(HS_STACK_HANDLE hStack, IEndpoint *pEndpoint, ICall *pCall, ASNH245TerminalCapabilitySet* pTcs)
{
	HS_UINT i;
	MediaChannelState mState;

	if( pTcs==HS_NULL || hStack==HS_INVALID_STACK_HANDLE || pEndpoint==HS_NULL || pCall==HS_NULL )
		return HS_ERR_NULL_PARAM;

	new_MediaChannelState(&mState);
	for( i=0; i<pTcs->m_capabilityTable.size; i++ )
	{
		AppCheckTerminalCapabilitySetUnit(
			hStack, pEndpoint, pCall,
			AsnSequenceOf_GetUnit(&(pTcs->m_capabilityTable), i), &mState
		);
	}

	if( pCall->h245Charge.size == 0 ) return HS_ERR_H323_NOUNIT;
	return HS_OK;
}


