/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<MsgName.c>		2006-01-18,23:15

*/

#include "MsgName.h"





const char *AppGetRasMessageName(ASNH225RasMessageChoice pType)
{
	switch(pType)
	{
	case e_ASNH225RasMessageChoice_gatekeeperRequest:	return "GRQ";
	case e_ASNH225RasMessageChoice_gatekeeperConfirm:	return "GCF";
	case e_ASNH225RasMessageChoice_gatekeeperReject:	return "GRJ";
	case e_ASNH225RasMessageChoice_registrationRequest:	return "RRQ";
	case e_ASNH225RasMessageChoice_registrationConfirm:	return "RCF";
	case e_ASNH225RasMessageChoice_registrationReject:	return "RRJ";
	case e_ASNH225RasMessageChoice_unregistrationRequest:	return "URQ";
	case e_ASNH225RasMessageChoice_unregistrationConfirm:	return "UCF";
	case e_ASNH225RasMessageChoice_unregistrationReject:	return "URJ";
	case e_ASNH225RasMessageChoice_admissionRequest:	return "ARQ";
	case e_ASNH225RasMessageChoice_admissionConfirm:	return "ACF";
	case e_ASNH225RasMessageChoice_admissionReject:	return "ARJ";
	case e_ASNH225RasMessageChoice_bandwidthRequest:	return "BRQ";
	case e_ASNH225RasMessageChoice_bandwidthConfirm:	return "BCF";
	case e_ASNH225RasMessageChoice_bandwidthReject:	return "BRJ";
	case e_ASNH225RasMessageChoice_disengageRequest:	return "DRQ";
	case e_ASNH225RasMessageChoice_disengageConfirm:	return "DCF";
	case e_ASNH225RasMessageChoice_disengageReject:	return "DRJ";
	case e_ASNH225RasMessageChoice_locationRequest:	return "LRQ";
	case e_ASNH225RasMessageChoice_locationConfirm:	return "LCF";
	case e_ASNH225RasMessageChoice_locationReject:	return "LRJ";
	case e_ASNH225RasMessageChoice_infoRequest:	return "IRQ";
	case e_ASNH225RasMessageChoice_infoRequestResponse:	return "IRR";
	case e_ASNH225RasMessageChoice_nonStandardMessage:	return "NSM";
	case e_ASNH225RasMessageChoice_unknownMessageResponse:	return "UMR";
	case e_ASNH225RasMessageChoice_requestInProgress:	return "RIP";
	case e_ASNH225RasMessageChoice_resourcesAvailableIndicate:	return "RAI";
	case e_ASNH225RasMessageChoice_resourcesAvailableConfirm:	return "RAC";
	case e_ASNH225RasMessageChoice_infoRequestAck:	return "IRA";
	case e_ASNH225RasMessageChoice_infoRequestNak:	return "IRN";
	case e_ASNH225RasMessageChoice_serviceControlIndication:	return "SCI";
	case e_ASNH225RasMessageChoice_serviceControlResponse:	return "SCR";
	}
	return "Unknown";
}


const char *AppGetQ931MessageName(ASNH225H323_UU_PDU_h323_message_bodyChoice pChoice)
{
	switch(pChoice)
	{
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_setup:	return "Setup";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_callProceeding:	return "CallProceeding";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_connect:	return "Connect";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_alerting:	return "Alerting";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_information:	return "information";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_releaseComplete:	return "releaseComplete";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_facility:	return "Facility";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_progress:	return "progress";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_empty:	return "Empty";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_status:	return "Status";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_statusInquiry:	return "StatusInquiry";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_setupAcknowledge:	return "SetupAcknowledge";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_notify:	return "Notify";
	}
	return "Unknown";
}


const char *AppGetH245MessageName(ControlMsg *pMsg)
{
	ASNH245RequestMessage *tRequest = HS_NULL;
	ASNH245ResponseMessage *tResponse = HS_NULL;
	ASNH245CommandMessage *tCommand = HS_NULL;
	ASNH245IndicationMessage *tIndication = HS_NULL;

	if( pMsg == HS_NULL ) return "null";
	switch(pMsg->choice)
	{
		case e_ASNH245MultimediaSystemControlMessageChoice_request:
			if( (tRequest=(ASNH245RequestMessage*)(pMsg->alter)) == HS_NULL ) return "null";
			switch(tRequest->choice)
			{
				case e_ASNH245RequestMessageChoice_nonStandard: return "req-ns";
				case e_ASNH245RequestMessageChoice_masterSlaveDetermination: return "req-msd";
				case e_ASNH245RequestMessageChoice_terminalCapabilitySet: return "req-tcs";
				case e_ASNH245RequestMessageChoice_openLogicalChannel: return "req-olc";
				case e_ASNH245RequestMessageChoice_closeLogicalChannel: return "req-clc";
				case e_ASNH245RequestMessageChoice_requestChannelClose: return "req-rcc";
				case e_ASNH245RequestMessageChoice_multiplexEntrySend: return "req-mes";
				case e_ASNH245RequestMessageChoice_requestMultiplexEntry: return "req-rme";
				case e_ASNH245RequestMessageChoice_requestMode: return "req-rm";
				case e_ASNH245RequestMessageChoice_roundTripDelayRequest: return "req-rtdr";
				case e_ASNH245RequestMessageChoice_maintenanceLoopRequest: return "req-mlr";
				case e_ASNH245RequestMessageChoice_communicationModeRequest: return "req-cmr";
				case e_ASNH245RequestMessageChoice_conferenceRequest: return "req-cr";
				case e_ASNH245RequestMessageChoice_multilinkRequest: return "req-mr";
				case e_ASNH245RequestMessageChoice_logicalChannelRateRequest: return "req-lcrr";
			}
			break;

		case e_ASNH245MultimediaSystemControlMessageChoice_response:
			if( (tResponse=(ASNH245ResponseMessage*)(pMsg->alter)) == HS_NULL ) return "null";
			switch(tResponse->choice)
			{
				case e_ASNH245ResponseMessageChoice_nonStandard: return "resp-ns";
				case e_ASNH245ResponseMessageChoice_masterSlaveDeterminationAck: return "resp-msd.a";
				case e_ASNH245ResponseMessageChoice_masterSlaveDeterminationReject: return "resp-msd.r";
				case e_ASNH245ResponseMessageChoice_terminalCapabilitySetAck: return "resp-tcs.a";
				case e_ASNH245ResponseMessageChoice_terminalCapabilitySetReject: return "resp-tcs.r";
				case e_ASNH245ResponseMessageChoice_openLogicalChannelAck: return "resp-olc.a";
				case e_ASNH245ResponseMessageChoice_openLogicalChannelReject: return "resp-olc.r";
				case e_ASNH245ResponseMessageChoice_closeLogicalChannelAck: return "resp-clc.a";
				case e_ASNH245ResponseMessageChoice_requestChannelCloseAck: return "resp-rcc.a";
				case e_ASNH245ResponseMessageChoice_requestChannelCloseReject: return "resp-rcc.r";
				case e_ASNH245ResponseMessageChoice_multiplexEntrySendAck: return "resp-mes.a";
				case e_ASNH245ResponseMessageChoice_multiplexEntrySendReject: return "resp-mes.r";
				case e_ASNH245ResponseMessageChoice_requestMultiplexEntryAck: return "resp-rme.a";
				case e_ASNH245ResponseMessageChoice_requestMultiplexEntryReject: return "resp-rme.r";
				case e_ASNH245ResponseMessageChoice_requestModeAck: return "resp-rm.a";
				case e_ASNH245ResponseMessageChoice_requestModeReject: return "resp-rm.r";
				case e_ASNH245ResponseMessageChoice_roundTripDelayResponse: return "resp-rtdr";
				case e_ASNH245ResponseMessageChoice_maintenanceLoopAck: return "resp-ml.a";
				case e_ASNH245ResponseMessageChoice_maintenanceLoopReject: return "resp-ml.r";
				case e_ASNH245ResponseMessageChoice_communicationModeResponse: return "resp-cmr";
				case e_ASNH245ResponseMessageChoice_conferenceResponse: return "resp-cr";
				case e_ASNH245ResponseMessageChoice_multilinkResponse: return "resp-mr";
				case e_ASNH245ResponseMessageChoice_logicalChannelRateAcknowledge: return "resp-lcr.a";
				case e_ASNH245ResponseMessageChoice_logicalChannelRateReject: return "resp-lcr.r";
			}
			break;

		case e_ASNH245MultimediaSystemControlMessageChoice_command:
			if( (tCommand=(ASNH245CommandMessage*)(pMsg->alter)) == HS_NULL ) return "null";
			switch( tCommand->choice )
			{
				case e_ASNH245CommandMessageChoice_nonStandard: return "com-ns";
				case e_ASNH245CommandMessageChoice_maintenanceLoopOffCommand: return "com-mloc";
				case e_ASNH245CommandMessageChoice_sendTerminalCapabilitySet: return "com-stcs";
				case e_ASNH245CommandMessageChoice_encryptionCommand: return "com-ec";
				case e_ASNH245CommandMessageChoice_flowControlCommand: return "com-fcc";
				case e_ASNH245CommandMessageChoice_endSessionCommand: return "com-esc";
				case e_ASNH245CommandMessageChoice_miscellaneousCommand: return "com-misc";
				case e_ASNH245CommandMessageChoice_communicationModeCommand: return "com-cmc";
				case e_ASNH245CommandMessageChoice_conferenceCommand: return "com-cc";
				case e_ASNH245CommandMessageChoice_h223MultiplexReconfiguration: return "com-h223";
				case e_ASNH245CommandMessageChoice_newATMVCCommand: return "com-ATM";
				case e_ASNH245CommandMessageChoice_mobileMultilinkReconfigurationCommand: return "com-mobile";
			}
			break;

		case e_ASNH245MultimediaSystemControlMessageChoice_indication:
			if( (tIndication=(ASNH245IndicationMessage*)(pMsg->alter)) == HS_NULL ) return "null";
			switch( tIndication->choice )
			{
				case e_ASNH245IndicationMessageChoice_nonStandard: return "ind-ns";
				case e_ASNH245IndicationMessageChoice_functionNotUnderstood: return "ind-fnu";
				case e_ASNH245IndicationMessageChoice_masterSlaveDeterminationRelease: return "ind-msd.r";
				case e_ASNH245IndicationMessageChoice_terminalCapabilitySetRelease: return "ind-tcs.r";
				case e_ASNH245IndicationMessageChoice_openLogicalChannelConfirm: return "ind-olc.c";
				case e_ASNH245IndicationMessageChoice_requestChannelCloseRelease: return "ind-rcc.r";
				case e_ASNH245IndicationMessageChoice_multiplexEntrySendRelease: return "ind-mes.r";
				case e_ASNH245IndicationMessageChoice_requestMultiplexEntryRelease: return "ind-rme.r";
				case e_ASNH245IndicationMessageChoice_requestModeRelease: return "ind-rm.r";
				case e_ASNH245IndicationMessageChoice_miscellaneousIndication: return "ind-misi";
				case e_ASNH245IndicationMessageChoice_jitterIndication: return "ind-ji";
				case e_ASNH245IndicationMessageChoice_h223SkewIndication: return "ind-h223";
				case e_ASNH245IndicationMessageChoice_newATMVCIndication: return "ind-ATM";
				case e_ASNH245IndicationMessageChoice_userInput: return "ind-ui";
				case e_ASNH245IndicationMessageChoice_h2250MaximumSkewIndication: return "ind-h2250";
				case e_ASNH245IndicationMessageChoice_mcLocationIndication: return "ind-mcli";
				case e_ASNH245IndicationMessageChoice_conferenceIndication: return "ind-ci";
				case e_ASNH245IndicationMessageChoice_vendorIdentification: return "ind-vendor";
				case e_ASNH245IndicationMessageChoice_functionNotSupported: return "ind-fns";
				case e_ASNH245IndicationMessageChoice_multilinkIndication: return "ind-multilink";
				case e_ASNH245IndicationMessageChoice_logicalChannelRateRelease: return "ind-lcr.r";
				case e_ASNH245IndicationMessageChoice_flowControlIndication: return "ind-fci";
				case e_ASNH245IndicationMessageChoice_mobileMultilinkReconfigurationIndication: return "ind-mobile";
			}
			break;
	}

	return "Unknown";
}


const char *AppGetCallCloseReasonName(CallCloseReason pReason)
{
	switch(pReason)
	{
		case e_CallCloseReason_Undefined:	return "Undefined";
		case e_CallCloseReason_UnknownDestination:	return "UnknownDestination";
		case e_CallCloseReason_Admission:	return "Admission";
		case e_CallCloseReason_Connection:	return "Connection";
		case e_CallCloseReason_H245Session:	return "H24Session";
		case e_CallCloseReason_MasterSlaveConflict:	return "MasterSlaveConflict";
		case e_CallCloseReason_ForceDrop:	return "ForceDrop";
		case e_CallCloseReason_Normal:	return "Normal";
		case e_CallCloseReason_Busy:	return "Busy";
		case e_CallCloseReason_NoAnswer:	return "NoAnswer";
		case e_CallCloseReason_InvalidNumber:	return "InvalidNumber";
	}
	return "Unknown";
}