/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<AppH323Main.c>		2005-03-22,11:39

*/

#include "AppH323Define.h"

#include "AppMediaNego.h"
#include "App245Dtmf.h"

#ifdef HS_EXTERNAL_MEDIA_PROGRAM
#include "AudioHandler.h"
#endif

#include "AppQMessage.h"

#include <conio.h>



typedef enum
{
	e_App_AddressType_Ip,
	e_App_AddressType_H323id,
	e_App_AddressType_E164id
} App_AddressType;
#define e_App_AddressTypeMax	2



/********************************************************************/
/* global variable
*/
/* flatform
*/
HWND			gHwnd = HS_NULL;
/*hstemp{*/
HS_UCHAR		gLocalIp[4] = {0,0,0,0};
/*hstemp}*/
/* registration
*/
char			gDefinePrimaryGk[256];
char			gDefineSecondaryGk[256];
BOOL			gIsRegisterTrying = HS_NO;
BOOL			gIsPrimaryGk = HS_YES;
/* only one call !
*/
HS_CALL_HANDLE	gCallHandle = HS_INVALID_CALL_HANDLE;
/* media controller
*/
#ifdef HS_EXTERNAL_MEDIA_PROGRAM
	#define HS_PIPE_PORT_MEDIA						61120

	AudioHandler	gAudioHandler;
	BOOL			gIsUseExternalMediaProgram = HS_NO;
#endif



/*********************************************************************/
/* Utilities
*/
const char *AppGetRasMessageName(ASNH225RasMessageChoice pType)
{
	switch(pType)
	{
	case e_ASNH225RasMessageChoice_gatekeeperRequest:	return "GRQ";
	case e_ASNH225RasMessageChoice_gatekeeperConfirm:	return "GCF";
	case e_ASNH225RasMessageChoice_gatekeeperReject:	return "GRJ";
	case e_ASNH225RasMessageChoice_registrationRequest:	return "RRQ";
	case e_ASNH225RasMessageChoice_registrationConfirm:	return "RCF";
	case e_ASNH225RasMessageChoice_registrationReject:	return "RRJ";
	case e_ASNH225RasMessageChoice_unregistrationRequest:	return "URQ";
	case e_ASNH225RasMessageChoice_unregistrationConfirm:	return "UCF";
	case e_ASNH225RasMessageChoice_unregistrationReject:	return "URJ";
	case e_ASNH225RasMessageChoice_admissionRequest:	return "ARQ";
	case e_ASNH225RasMessageChoice_admissionConfirm:	return "ACF";
	case e_ASNH225RasMessageChoice_admissionReject:	return "ARJ";
	case e_ASNH225RasMessageChoice_bandwidthRequest:	return "BRQ";
	case e_ASNH225RasMessageChoice_bandwidthConfirm:	return "BCF";
	case e_ASNH225RasMessageChoice_bandwidthReject:	return "BRJ";
	case e_ASNH225RasMessageChoice_disengageRequest:	return "DRQ";
	case e_ASNH225RasMessageChoice_disengageConfirm:	return "DCF";
	case e_ASNH225RasMessageChoice_disengageReject:	return "DRJ";
	case e_ASNH225RasMessageChoice_locationRequest:	return "LRQ";
	case e_ASNH225RasMessageChoice_locationConfirm:	return "LCF";
	case e_ASNH225RasMessageChoice_locationReject:	return "LRJ";
	case e_ASNH225RasMessageChoice_infoRequest:	return "IRQ";
	case e_ASNH225RasMessageChoice_infoRequestResponse:	return "IRR";
	case e_ASNH225RasMessageChoice_nonStandardMessage:	return "NSM";
	case e_ASNH225RasMessageChoice_unknownMessageResponse:	return "UMR";
	case e_ASNH225RasMessageChoice_requestInProgress:	return "RIP";
	case e_ASNH225RasMessageChoice_resourcesAvailableIndicate:	return "RAI";
	case e_ASNH225RasMessageChoice_resourcesAvailableConfirm:	return "RAC";
	case e_ASNH225RasMessageChoice_infoRequestAck:	return "IRA";
	case e_ASNH225RasMessageChoice_infoRequestNak:	return "IRN";
	case e_ASNH225RasMessageChoice_serviceControlIndication:	return "SCI";
	case e_ASNH225RasMessageChoice_serviceControlResponse:	return "SCR";
	}
	return "Unknown";
}
const char *AppGetQ931MessageName(ASNH225H323_UU_PDU_h323_message_bodyChoice pChoice)
{
	switch(pChoice)
	{
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_setup:	return "Setup";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_callProceeding:	return "CallProceeding";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_connect:	return "Connect";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_alerting:	return "Alerting";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_information:	return "Information";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_releaseComplete:	return "ReleaseComplete";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_facility:	return "Facility";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_progress:	return "progress";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_empty:	return "Empty";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_status:	return "Status";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_statusInquiry:	return "StatusInquiry";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_setupAcknowledge:	return "SetupAcknowledge";
	case e_ASNH225H323_UU_PDU_h323_message_bodyChoice_notify:	return "Notify";
	}
	return "Unknown";
}
const char *AppGetH245MessageName(ControlMsg *pMsg)
{
	ASNH245RequestMessage *tRequest = HS_NULL;
	ASNH245ResponseMessage *tResponse = HS_NULL;
	ASNH245CommandMessage *tCommand = HS_NULL;
	ASNH245IndicationMessage *tIndication = HS_NULL;

	if( pMsg == HS_NULL ) return "null";
	switch(pMsg->choice)
	{
		case e_ASNH245MultimediaSystemControlMessageChoice_request:
			if( (tRequest=(ASNH245RequestMessage*)(pMsg->alter)) == HS_NULL ) return "null";
			switch(tRequest->choice)
			{
				case e_ASNH245RequestMessageChoice_nonStandard: return "req-ns";
				case e_ASNH245RequestMessageChoice_masterSlaveDetermination: return "req-msd";
				case e_ASNH245RequestMessageChoice_terminalCapabilitySet: return "req-tcs";
				case e_ASNH245RequestMessageChoice_openLogicalChannel: return "req-olc";
				case e_ASNH245RequestMessageChoice_closeLogicalChannel: return "req-clc";
				case e_ASNH245RequestMessageChoice_requestChannelClose: return "req-rcc";
				case e_ASNH245RequestMessageChoice_multiplexEntrySend: return "req-mes";
				case e_ASNH245RequestMessageChoice_requestMultiplexEntry: return "req-rme";
				case e_ASNH245RequestMessageChoice_requestMode: return "req-rm";
				case e_ASNH245RequestMessageChoice_roundTripDelayRequest: return "req-rtdr";
				case e_ASNH245RequestMessageChoice_maintenanceLoopRequest: return "req-mlr";
				case e_ASNH245RequestMessageChoice_communicationModeRequest: return "req-cmr";
				case e_ASNH245RequestMessageChoice_conferenceRequest: return "req-cr";
				case e_ASNH245RequestMessageChoice_multilinkRequest: return "req-mr";
				case e_ASNH245RequestMessageChoice_logicalChannelRateRequest: return "req-lcrr";
			}
			break;

		case e_ASNH245MultimediaSystemControlMessageChoice_response:
			if( (tResponse=(ASNH245ResponseMessage*)(pMsg->alter)) == HS_NULL ) return "null";
			switch(tResponse->choice)
			{
				case e_ASNH245ResponseMessageChoice_nonStandard: return "resp-ns";
				case e_ASNH245ResponseMessageChoice_masterSlaveDeterminationAck: return "resp-msd.a";
				case e_ASNH245ResponseMessageChoice_masterSlaveDeterminationReject: return "resp-msd.r";
				case e_ASNH245ResponseMessageChoice_terminalCapabilitySetAck: return "resp-tcs.a";
				case e_ASNH245ResponseMessageChoice_terminalCapabilitySetReject: return "resp-tcs.r";
				case e_ASNH245ResponseMessageChoice_openLogicalChannelAck: return "resp-olc.a";
				case e_ASNH245ResponseMessageChoice_openLogicalChannelReject: return "resp-olc.r";
				case e_ASNH245ResponseMessageChoice_closeLogicalChannelAck: return "resp-clc.a";
				case e_ASNH245ResponseMessageChoice_requestChannelCloseAck: return "resp-rcc.a";
				case e_ASNH245ResponseMessageChoice_requestChannelCloseReject: return "resp-rcc.r";
				case e_ASNH245ResponseMessageChoice_multiplexEntrySendAck: return "resp-mes.a";
				case e_ASNH245ResponseMessageChoice_multiplexEntrySendReject: return "resp-mes.r";
				case e_ASNH245ResponseMessageChoice_requestMultiplexEntryAck: return "resp-rme.a";
				case e_ASNH245ResponseMessageChoice_requestMultiplexEntryReject: return "resp-rme.r";
				case e_ASNH245ResponseMessageChoice_requestModeAck: return "resp-rm.a";
				case e_ASNH245ResponseMessageChoice_requestModeReject: return "resp-rm.r";
				case e_ASNH245ResponseMessageChoice_roundTripDelayResponse: return "resp-rtdr";
				case e_ASNH245ResponseMessageChoice_maintenanceLoopAck: return "resp-ml.a";
				case e_ASNH245ResponseMessageChoice_maintenanceLoopReject: return "resp-ml.r";
				case e_ASNH245ResponseMessageChoice_communicationModeResponse: return "resp-cmr";
				case e_ASNH245ResponseMessageChoice_conferenceResponse: return "resp-cr";
				case e_ASNH245ResponseMessageChoice_multilinkResponse: return "resp-mr";
				case e_ASNH245ResponseMessageChoice_logicalChannelRateAcknowledge: return "resp-lcr.a";
				case e_ASNH245ResponseMessageChoice_logicalChannelRateReject: return "resp-lcr.r";
			}
			break;

		case e_ASNH245MultimediaSystemControlMessageChoice_command:
			if( (tCommand=(ASNH245CommandMessage*)(pMsg->alter)) == HS_NULL ) return "null";
			switch( tCommand->choice )
			{
				case e_ASNH245CommandMessageChoice_nonStandard: return "com-ns";
				case e_ASNH245CommandMessageChoice_maintenanceLoopOffCommand: return "com-mloc";
				case e_ASNH245CommandMessageChoice_sendTerminalCapabilitySet: return "com-stcs";
				case e_ASNH245CommandMessageChoice_encryptionCommand: return "com-ec";
				case e_ASNH245CommandMessageChoice_flowControlCommand: return "com-fcc";
				case e_ASNH245CommandMessageChoice_endSessionCommand: return "com-esc";
				case e_ASNH245CommandMessageChoice_miscellaneousCommand: return "com-misc";
				case e_ASNH245CommandMessageChoice_communicationModeCommand: return "com-cmc";
				case e_ASNH245CommandMessageChoice_conferenceCommand: return "com-cc";
				case e_ASNH245CommandMessageChoice_h223MultiplexReconfiguration: return "com-h223";
				case e_ASNH245CommandMessageChoice_newATMVCCommand: return "com-ATM";
				case e_ASNH245CommandMessageChoice_mobileMultilinkReconfigurationCommand: return "com-mobile";
			}
			break;

		case e_ASNH245MultimediaSystemControlMessageChoice_indication:
			if( (tIndication=(ASNH245IndicationMessage*)(pMsg->alter)) == HS_NULL ) return "null";
			switch( tIndication->choice )
			{
				case e_ASNH245IndicationMessageChoice_nonStandard: return "ind-ns";
				case e_ASNH245IndicationMessageChoice_functionNotUnderstood: return "ind-fnu";
				case e_ASNH245IndicationMessageChoice_masterSlaveDeterminationRelease: return "ind-msd.r";
				case e_ASNH245IndicationMessageChoice_terminalCapabilitySetRelease: return "ind-tcs.r";
				case e_ASNH245IndicationMessageChoice_openLogicalChannelConfirm: return "ind-olc.c";
				case e_ASNH245IndicationMessageChoice_requestChannelCloseRelease: return "ind-rcc.r";
				case e_ASNH245IndicationMessageChoice_multiplexEntrySendRelease: return "ind-mes.r";
				case e_ASNH245IndicationMessageChoice_requestMultiplexEntryRelease: return "ind-rme.r";
				case e_ASNH245IndicationMessageChoice_requestModeRelease: return "ind-rm.r";
				case e_ASNH245IndicationMessageChoice_miscellaneousIndication: return "ind-misi";
				case e_ASNH245IndicationMessageChoice_jitterIndication: return "ind-ji";
				case e_ASNH245IndicationMessageChoice_h223SkewIndication: return "ind-h223";
				case e_ASNH245IndicationMessageChoice_newATMVCIndication: return "ind-ATM";
				case e_ASNH245IndicationMessageChoice_userInput: return "ind-ui";
				case e_ASNH245IndicationMessageChoice_h2250MaximumSkewIndication: return "ind-h2250";
				case e_ASNH245IndicationMessageChoice_mcLocationIndication: return "ind-mcli";
				case e_ASNH245IndicationMessageChoice_conferenceIndication: return "ind-ci";
				case e_ASNH245IndicationMessageChoice_vendorIdentification: return "ind-vendor";
				case e_ASNH245IndicationMessageChoice_functionNotSupported: return "ind-fns";
				case e_ASNH245IndicationMessageChoice_multilinkIndication: return "ind-multilink";
				case e_ASNH245IndicationMessageChoice_logicalChannelRateRelease: return "ind-lcr.r";
				case e_ASNH245IndicationMessageChoice_flowControlIndication: return "ind-fci";
				case e_ASNH245IndicationMessageChoice_mobileMultilinkReconfigurationIndication: return "ind-mobile";
			}
			break;
	}

	return "Unknown";
}
const char *AppGetCallCloseReasonName(CallCloseReason pReason)
{
	switch(pReason)
	{
		case e_CallCloseReason_Undefined:	return "Undefined";
		case e_CallCloseReason_UnknownDestination:	return "UnknownDestination";
		case e_CallCloseReason_Admission:	return "Admission";
		case e_CallCloseReason_Connection:	return "Connection";
		case e_CallCloseReason_H245Session:	return "H24Session";
		case e_CallCloseReason_MasterSlaveConflict:	return "MasterSlaveConflict";
		case e_CallCloseReason_ForceDrop:	return "ForceDrop";
		case e_CallCloseReason_Normal:	return "Normal";
		case e_CallCloseReason_Busy:	return "Busy";
		case e_CallCloseReason_NoAnswer:	return "NoAnswer";
		case e_CallCloseReason_InvalidNumber:	return "InvalidNumber";
	}
	return "Unknown";
}




/*********************************************************************/
/* Stack Callback Event
*/
/* error, exception, call droping
*/
void AppOnException(HSException pException, HS_RESULT tRet)
{
	HSPrint( "\n <APP> OnException(exc:%d,tRet:%u)", pException, tRet );
}
void AppOnAsnDecodingError(HS_STACK_HANDLE hStack, HS_CALL_HANDLE hCall, AsnStream *tStrm)
{
	PostMessage(gHwnd,HS_QMESSAGE_APP_DECODE_ERROR,0,0);
}
void AppOnCallIncoming(HS_STACK_HANDLE hStack, void* pCall)
{
	ICall *tCall = (ICall*)pCall;

	if( tCall == HS_NULL ) return;
	/* only one call !
	*/
	if( gCallHandle != HS_INVALID_CALL_HANDLE )
	{
		HapiCommandRemoveCall(hStack, tCall->handle, e_CallCloseReason_Busy);
		return;
	}
	gCallHandle = tCall->handle;

	/* set capabilities
	*/
	HapiAddG711Alaw64k(tCall, HS_AUDIO_SIMUL_GROUP, 10);
	HapiAddG711Ulaw64k(tCall, HS_AUDIO_SIMUL_GROUP, 10);
/*	HapiAddG7231(tCall, HS_AUDIO_SIMUL_GROUP, 10, HS_NO);
	HapiAddG729(tCall, HS_AUDIO_SIMUL_GROUP, 10);*/

	/* send signal to flatform
	*/
	if( gHwnd != HS_NULL ) PostMessage(gHwnd,HS_QMESSAGE_APP_INCOMING,0,0);
}
void AppOnCallRemoved(HS_CALL_HANDLE pHandle, CallCloseReason pReason, Q931CauseType pCause)
{
	HSPrint( "\n <APP> OnCallRemoved(%u,%s,%d)", pHandle, AppGetCallCloseReasonName(pReason), (int)pCause );
	gCallHandle = HS_INVALID_CALL_HANDLE;

	/* send signal to flatform
	*/
	if( gHwnd != HS_NULL ) PostMessage(gHwnd,HS_QMESSAGE_APP_REMOVED,0,0);
}


/* timeout
*/
void AppOnRegistrationTimeout(HS_STACK_HANDLE hStack)
{
	if( gIsRegisterTrying == HS_YES )
	{
		if( gIsPrimaryGk == HS_YES )
		{
			HapiCommandChangeGatekeeper( hStack, gDefineSecondaryGk );
			gIsPrimaryGk = HS_NO;
		}
		else
		{
			HapiCommandChangeGatekeeper( hStack, gDefinePrimaryGk );
			gIsPrimaryGk = HS_YES;
		}
	}
}
void AppOnRasMessageTimeout(HS_STACK_HANDLE hStack, HS_CALL_HANDLE hCall, ASNH225RasMessageChoice pType, HS_USHORT pSN )
{
	HSPrint( "\n <APP> OnRasMessageTimeout(hStack,hcall,%s,sn:%u)", AppGetRasMessageName(pType), pSN );
}


/* message received
*/
BOOL AppOnReceiveRasRawData(HS_STACK_HANDLE hStack, HS_CALL_HANDLE hCall, AsnStream *pStrm)
{
	if( pStrm != HS_NULL )
	{
		if( gHwnd != HS_NULL )
		{
			QMAEmsg *tEmsg = new_QMAEmsg(e_ChannelType_Ras, HS_NO, pStrm->datas, pStrm->size);
			if( tEmsg != HS_NULL ) PostMessage(gHwnd, HS_QMESSAGE_APP_EMSG, 0, (LPARAM)tEmsg);
		}

		HSPrint( "\n <APP> [RAS] RECEIVE (raw:%d)", pStrm->size );
	}
	else
		HSPrint( "\n <APP> [RAS] RECEIVE (raw:null)" );
	return TRUE;
}
BOOL AppOnReceiveRasMessage(HS_STACK_HANDLE hStack, HS_CALL_HANDLE hCall, RasMsg *pMsg)
{
	if( pMsg != HS_NULL )
	{
		HSPrint( "\n <APP> [RAS] RECEIVE (msg:%s)", AppGetRasMessageName(pMsg->choice) );
#ifdef HS_DEBUG_H323_APP_MBODY
		RasMsg_Print(pMsg,3,"Ras");
#endif
	}
	else
		HSPrint( "\n <APP> [RAS] RECEIVE (msg:null)" );
	return TRUE;
}
BOOL AppOnReceiveQ931RawData(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, AsnStream *pStrm)
{
	if( pStrm != HS_NULL )
	{
		if( gHwnd != HS_NULL )
		{
			QMAEmsg *tEmsg = new_QMAEmsg(e_ChannelType_Q931, HS_NO, pStrm->datas, pStrm->size);
			if( tEmsg != HS_NULL ) PostMessage(gHwnd, HS_QMESSAGE_APP_EMSG, 0, (LPARAM)tEmsg);
		}

		HSPrint( "\n <APP> [Q931] RECEIVE (raw:%d)", pStrm->size );
	}
	else
		HSPrint( "\n <APP> [Q931] RECEIVE (raw:null)" );
	return TRUE;
}
BOOL AppOnReceiveQ931Message(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, Q931Message *pMsg)
{
	int tType = 256;

	if( pMsg != HS_NULL )
	{
		if( pMsg->uuie != HS_NULL )
			tType = pMsg->uuie->m_h323_uu_pdu.m_h323_message_body.choice;
	}

	if( tType == 256 )
		HSPrint( "\n <APP> [Q931] RECEIVE (msg:null)" );
	else
	{
		HSPrint( "\n <APP> [Q931] RECEIVE (msg:%s)", AppGetQ931MessageName((ASNH225H323_UU_PDU_h323_message_bodyChoice)tType) );
#ifdef HS_DEBUG_APP_MBODY
		Q931Message_Print(pMsg,3,"Q931");
#endif

		if( gHwnd != HS_NULL )
		{
			if( tType==e_ASNH225H323_UU_PDU_h323_message_bodyChoice_alerting )
				PostMessage(gHwnd,HS_QMESSAGE_APP_ALERT,0,0);
			else if( tType==e_ASNH225H323_UU_PDU_h323_message_bodyChoice_connect )
				PostMessage(gHwnd,HS_QMESSAGE_APP_CONNECT,0,0);
		}
	}

	return TRUE;
}
BOOL AppOnReceiveH245RawData(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, AsnStream *pStrm)
{
	if( pStrm != HS_NULL )
	{
		if( gHwnd != HS_NULL )
		{
			QMAEmsg *tEmsg = new_QMAEmsg(e_ChannelType_H245, HS_NO, pStrm->datas, pStrm->size);
			if( tEmsg != HS_NULL ) PostMessage(gHwnd, HS_QMESSAGE_APP_EMSG, 0, (LPARAM)tEmsg);
		}

		HSPrint( "\n <APP> [H245] RECEIVE (raw:%d)", pStrm->size );
	}
	else
		HSPrint( "\n <APP> [H245] RECEIVE (raw:null)" );
	return TRUE;
}
BOOL AppOnReceiveH245Message(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, ControlMsg *pMsg)
{
	if( pMsg != HS_NULL )
	{
		HSPrint( "\n <APP> [H245] RECEIVE (msg:%s)", AppGetH245MessageName(pMsg) );
#ifdef HS_DEBUG_H323_APP_MBODY
		ControlMsg_Print(pMsg,3,"H245");
#endif
	}
	else
		HSPrint( "\n <APP> [H245] RECEIVE (msg:null)" );
	return TRUE;
}


/* message sending
*/
BOOL AppOnSendRasMessage(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, RasMsg *pMsg)
{
	if( pMsg != HS_NULL )
	{
		HSPrint( "\n <APP> [RAS ] SEND (msg:%s)", AppGetRasMessageName(pMsg->choice) );
#ifdef HS_DEBUG_H323_APP_MBODY
		RasMsg_Print(pMsg, 3, "Ras");
#endif
	}
	else
		HSPrint( "\n <APP> [RAS ] SEND (msg:null)" );
	return TRUE;
}
BOOL AppOnSendRasRawData(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, AsnStream *pStrm)
{
	if( pStrm != HS_NULL )
	{
		if( gHwnd != HS_NULL )
		{
			QMAEmsg *tEmsg = new_QMAEmsg(e_ChannelType_Ras, HS_YES, pStrm->datas, pStrm->size);
			if( tEmsg != HS_NULL ) PostMessage(gHwnd, HS_QMESSAGE_APP_EMSG, 0, (LPARAM)tEmsg);
		}

		HSPrint( "\n <APP> [RAS ] SEND (raw:%d)", pStrm->byteOffset );
	}
	else
		HSPrint( "\n <APP> [RAS ] SEND (raw:null)" );
	return TRUE;
}
BOOL AppOnSendQ931Message(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, Q931Message *pMsg)
{
	int tType = 256;

	if( pMsg != HS_NULL )
	{
		if( pMsg->uuie != HS_NULL )
			tType = pMsg->uuie->m_h323_uu_pdu.m_h323_message_body.choice;
	}

	if( tType == 256 )
		HSPrint( "\n <APP> [Q931] SEND (msg:null)" );
	else
	{
		HSPrint( "\n <APP> [Q931] SEND (msg:%s)", AppGetQ931MessageName((ASNH225H323_UU_PDU_h323_message_bodyChoice)tType) );
#ifdef HS_DEBUG_H323_APP_MBODY
		Q931Message_Print(pMsg, 3, "Q931");
#endif

		if( pHandle != HS_INVALID_CALL_HANDLE )
		{
			if( tType==e_ASNH225H323_UU_PDU_h323_message_bodyChoice_connect )
			{
				/* send brq : for LUCENT gatekeeper.
				*/
				HapiCommandChangeBandwidth(hStack,pHandle,HS_BANDWIDTH_DEFAULT);
			}
		}

	}

	return TRUE;
}
BOOL AppOnSendQ931RawData(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, AsnStream *pStrm)
{
	if( pStrm != HS_NULL )
	{
		if( gHwnd != HS_NULL )
		{
			QMAEmsg *tEmsg = new_QMAEmsg(e_ChannelType_Q931, HS_YES, pStrm->datas, pStrm->size);
			if( tEmsg != HS_NULL ) PostMessage(gHwnd, HS_QMESSAGE_APP_EMSG, 0, (LPARAM)tEmsg);
		}

		HSPrint( "\n <APP> [Q931] SEND (raw:%d)", pStrm->byteOffset );
	}
	else
		HSPrint( "\n <APP> [Q931] SEND (raw:null)" );
	return TRUE;
}
/* if call is a h245 tunneling mode, hStack is a invalid handle
*/
BOOL AppOnSendH245Message(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, ControlMsg *pMsg)
{
	if( pMsg != HS_NULL )
	{
		HSPrint( "\n <APP> [H245] SEND (msg:%s)", AppGetH245MessageName(pMsg) );
#ifdef HS_DEBUG_H323_APP_MBODY
		ControlMsg_Print(pMsg, 3, "H245");
#endif
	}
	else
		HSPrint( "\n <APP> [H245] SEND (msg:null)" );

	return TRUE;
}
/* if call is a h245 tunneling mode, hStack is a invalid handle
*/
BOOL AppOnSendH245RawData(HS_STACK_HANDLE hStack, HS_CALL_HANDLE pHandle, AsnStream *pStrm)
{
	if( pStrm != HS_NULL )
	{
		if( gHwnd != HS_NULL )
		{
			QMAEmsg *tEmsg = new_QMAEmsg(e_ChannelType_H245, HS_YES, pStrm->datas, pStrm->size);
			if( tEmsg != HS_NULL ) PostMessage(gHwnd, HS_QMESSAGE_APP_EMSG, 0, (LPARAM)tEmsg);
		}

		HSPrint( "\n <APP> [H245] SEND (raw:%d)", pStrm->byteOffset );
	}
	else
		HSPrint( "\n <APP> [H245] SEND (raw:null)" );
	return TRUE;
}



/****************************************************************************************/
/* Media callback functions
*/
/* media channel check
*/
HS_RESULT AppOnCheckFastStart(AsnSequenceOf *pOctetString, NoLockList *pCapabilities, void *pCall)
{
	return AppCheckFastStart(pOctetString, pCapabilities, (ICall*)pCall);
}
HS_RESULT AppOnCheckTerminalCapabilitySet(HS_STACK_HANDLE hStack, void *pEndpoint, void *pCall, ASNH245TerminalCapabilitySet* pTcs)
{
	return AppCheckTerminalCapabilitySet(hStack, (IEndpoint*)pEndpoint, (ICall*)pCall, pTcs);
}

/* reverse media channel open
*/
void AppOnOpenReceiveMedia(
	HS_CALL_HANDLE pHandle,	HS_USHORT pRtpPort, HS_USHORT pRtcpPort, ASNH245DataType *pType
)
{
#ifdef HS_EXTERNAL_MEDIA_PROGRAM
	HS_RESULT tRet = HS_ERR;
#endif 

	HSPrint( "\n <APP> OnOpenReceiveMedia(rtp:%u, rtcp:%u)", pRtpPort, pRtcpPort );

	if( gHwnd != HS_NULL )
	{
		QMAMedia *tQMedia = new_QMAMedia(HS_NO, HS_YES);
		if( tQMedia != HS_NULL ) PostMessage(gHwnd, HS_QMESSAGE_APP_MEDIA, 0, (LPARAM)tQMedia);
	}

	/* StopRingbackTone();
	*/

#ifdef HS_EXTERNAL_MEDIA_PROGRAM
	if( gIsUseExternalMediaProgram == HS_NO ) return;
	if( pType == NULL ) return;
	if( pType->choice == e_ASNH245DataTypeChoice_audioData )
	{
		ASNH245AudioCapability *tAudio = (ASNH245AudioCapability*)(pType->alter);
		if( tAudio == HS_NULL ) return;

		if		( tAudio->choice == e_ASNH245AudioCapabilityChoice_g711Alaw64k ||
				  tAudio->choice == e_ASNH245AudioCapabilityChoice_g711Alaw56k )
			tRet = StartReverseAudioSession(&gAudioHandler, pRtpPort, e_G711Type_aLaw);
		else if	( tAudio->choice == e_ASNH245AudioCapabilityChoice_g711Ulaw64k ||
				  tAudio->choice == e_ASNH245AudioCapabilityChoice_g711Ulaw56k )
			tRet = StartReverseAudioSession(&gAudioHandler, pRtpPort, e_G711Type_uLaw);

		if( tRet != HS_OK )
			HSPrint( "\n <APP> Fail to start reverse audio rtp, tRet(%u)", tRet );
	}
#endif
}

/* forward media channel open
*/
void AppOnOpenSendMedia(
	HS_CALL_HANDLE pHandle,
	struct sockaddr_in pRtpIn, struct sockaddr_in pRtcpIn, ASNH245DataType *pType
)
{
#ifdef HS_EXTERNAL_MEDIA_PROGRAM
	HS_RESULT tRet = HS_OK;
#endif 

	HSPrint( "\n <APP> OnOpenSendMedia(ip:%x, rtp:%u, rtcp:%u)",
		pRtpIn.sin_addr.S_un.S_addr, htons(pRtpIn.sin_port), htons(pRtcpIn.sin_port)
	);

	if( gHwnd != HS_NULL )
	{
		QMAMedia *tQMedia = new_QMAMedia(HS_YES, HS_YES);
		if( tQMedia != HS_NULL ) PostMessage(gHwnd, HS_QMESSAGE_APP_MEDIA, 0, (LPARAM)tQMedia);
	}

#ifdef HS_EXTERNAL_MEDIA_PROGRAM
	if( gIsUseExternalMediaProgram == HS_NO ) return;
	if( pType == NULL ) return;
	if( pType->choice == e_ASNH245DataTypeChoice_audioData )
	{
		ASNH245AudioCapability *tAudio = (ASNH245AudioCapability*)(pType->alter);
		if( tAudio == HS_NULL ) return;

		if		( tAudio->choice == e_ASNH245AudioCapabilityChoice_g711Alaw64k ||
				  tAudio->choice == e_ASNH245AudioCapabilityChoice_g711Alaw56k )
			tRet = StartForwardAudioSession(&gAudioHandler, pRtpIn, e_G711Type_aLaw);
		else if	( tAudio->choice == e_ASNH245AudioCapabilityChoice_g711Ulaw64k ||
				  tAudio->choice == e_ASNH245AudioCapabilityChoice_g711Ulaw56k )
			tRet = StartForwardAudioSession(&gAudioHandler, pRtpIn, e_G711Type_uLaw);

		if( tRet != HS_OK )
			HSPrint( "\n <APP> Fail to start forward audio rtp, tRet(%u)", tRet );
	}
#endif
}

/* reverse media channel close
*/
void AppOnCloseReceiveMedia(HS_CALL_HANDLE pHandle, ASNH245DataType *pType)
{
#ifdef HS_EXTERNAL_MEDIA_PROGRAM
	HS_RESULT tRet = HS_OK;
#endif 

	HSPrint( "\n <APP> OnCloseReceiveMedia()" );

	if( gHwnd != HS_NULL )
	{
		QMAMedia *tQMedia = new_QMAMedia(HS_NO, HS_NO);
		if( tQMedia != HS_NULL ) PostMessage(gHwnd, HS_QMESSAGE_APP_MEDIA, 0, (LPARAM)tQMedia);
	}

#ifdef HS_EXTERNAL_MEDIA_PROGRAM
	if( gIsUseExternalMediaProgram == HS_NO ) return;
	if( (tRet=StopReverseAudioSession(&gAudioHandler)) != HS_OK )
		HSPrint( "\n <APP> Fail to stop reverse audio rtp, tRet(%u)", tRet );
#endif
}

/* forward media channel close
*/
void AppOnCloseSendMedia(HS_CALL_HANDLE pHandle, ASNH245DataType *pType)
{
#ifdef HS_EXTERNAL_MEDIA_PROGRAM
	HS_RESULT tRet = HS_OK;
#endif 

	HSPrint( "\n <APP> OnCloseSendMedia()" );

	if( gHwnd != HS_NULL )
	{
		QMAMedia *tQMedia = new_QMAMedia(HS_NO, HS_YES);
		if( tQMedia != HS_NULL ) PostMessage(gHwnd, HS_QMESSAGE_APP_MEDIA, 0, (LPARAM)tQMedia);
	}

#ifdef HS_EXTERNAL_MEDIA_PROGRAM
	if( gIsUseExternalMediaProgram == HS_NO ) return;
	if( (tRet=StopForwardAudioSession(&gAudioHandler)) != HS_OK )
		HSPrint( "\n Fail to stop forward audio rtp, tRet(%u)", tRet );
#endif
}





/*********************************************************************/
/* Application Functions
*/
IEndpoint *AppH323MakeEndpoint()
{
	IEndpoint *tEndpoint;

	if( (tEndpoint=(IEndpoint*)HSMalloc(sizeof(IEndpoint))) == HS_NULL )
	{
		HSPrint( "\n <APP> Endpoint Alloc Error." );
		return HS_NULL;
	}
	new_IEndpoint(tEndpoint);

	tEndpoint->type = e_EndpointType_gateway;
	HapiSetRasAddress(tEndpoint,gLocalIp,1729);
	HapiSetCallSignalingAddress(tEndpoint,gLocalIp,1720);

	HapiAddEndpointAliasH323Id	(tEndpoint, "OEHPhone");
	HapiAddEndpointAliasDial	(tEndpoint, "023337777");
	/*HapiAddEndpointAliasUrlId	(tEndpoint, "www.voiper.co.kr");
	HapiAddEndpointAliasEmailId	(tEndpoint, "admin@voiper.co.kr");*/

	strcpy(tEndpoint->productId,"HS.H323.STACK");
	strcpy(tEndpoint->versionId,"0.001");

	tEndpoint->gatekeeper.ttl = 120;
	tEndpoint->gatekeeper.ttlForce = FALSE;
	tEndpoint->gatekeeper.attemptTime = 5;
	tEndpoint->gatekeeper.isGRQ = FALSE;
	tEndpoint->gatekeeper.isUseLightRRQ = TRUE;

	/* mapping callback functions
	*/
	tEndpoint->CallbackException			= AppOnException;
	tEndpoint->CallbackAsnDecodingError		= AppOnAsnDecodingError;
	tEndpoint->CallbackCallIncoming			= AppOnCallIncoming;
	tEndpoint->CallbackCallRemoved			= AppOnCallRemoved;

	tEndpoint->CallbackRegistrationTimeout	= AppOnRegistrationTimeout;
	tEndpoint->CallbackRasMessageTimeout	= AppOnRasMessageTimeout;

	tEndpoint->CallbackReceiveRasRawData	= AppOnReceiveRasRawData;
	tEndpoint->CallbackReceiveRasMessage	= AppOnReceiveRasMessage;
	tEndpoint->CallbackReceiveQ931RawData	= AppOnReceiveQ931RawData;
	tEndpoint->CallbackReceiveQ931Message	= AppOnReceiveQ931Message;
	tEndpoint->CallbackReceiveH245RawData	= AppOnReceiveH245RawData;
	tEndpoint->CallbackReceiveH245Message	= AppOnReceiveH245Message;
	tEndpoint->CallbackSendRasMessage		= AppOnSendRasMessage;
	tEndpoint->CallbackSendRasRawData		= AppOnSendRasRawData;
	tEndpoint->CallbackSendQ931Message		= AppOnSendQ931Message;
	tEndpoint->CallbackSendQ931RawData		= AppOnSendQ931RawData;
	tEndpoint->CallbackSendH245Message		= AppOnSendH245Message;
	tEndpoint->CallbackSendH245RawData		= AppOnSendH245RawData;

	tEndpoint->CallbackCheckFastStart		= AppOnCheckFastStart;
	tEndpoint->CallbackCheckTerminalCapabilitySet = AppOnCheckTerminalCapabilitySet;
	tEndpoint->CallbackOpenReceiveMedia		= AppOnOpenReceiveMedia;
	tEndpoint->CallbackOpenSendMedia		= AppOnOpenSendMedia;
	tEndpoint->CallbackCloseReceiveMedia	= AppOnCloseReceiveMedia;
	tEndpoint->CallbackCloseSendMedia		= AppOnCloseSendMedia;

	return tEndpoint;
}



HS_CALL_HANDLE AppH323MakeCall(HS_STACK_HANDLE pHandle, ICall *pCall)
{
	if( pCall == HS_NULL ) return HS_INVALID_CALL_HANDLE;

	/* set source call tsap
	*/
	Tsap2ASNH225TransportAddress( &(pCall->scsaTsap), gLocalIp, 1720 );

	if( HapiCommandMakeCall(pHandle, pCall) != HS_OK )
	{
		HapiCallClose(pCall);
		return HS_INVALID_CALL_HANDLE;
	}

	return pCall->handle;
}



HS_RESULT AppChangeEndpointAlias(HS_STACK_HANDLE hStack, QMAChangeId *pQmsg)
{
	HS_RESULT tRet = HS_OK;
	NoLockList *tAliases = HS_NULL;

	if( hStack == HS_INVALID_STACK_HANDLE || pQmsg == HS_NULL ) return HS_ERR_NULL_PARAM;
	if( (tAliases=HapiMakeAliasList()) == HS_NULL ) return HS_ERR_H323_MALLOC;

	if( (tRet=HapiAddAliasH323Id(tAliases, pQmsg->h323Id)) != HS_OK )
	{
		delete_NoLockList(tAliases);
		HSFree(tAliases);
		return tRet;
	}
	if( (tRet=HapiAddAliasDial(tAliases, pQmsg->e164Id)) != HS_OK )
	{
		delete_NoLockList(tAliases);
		HSFree(tAliases);
		return tRet;
	}
/*	if( (tRet=HapiAddAliasUrlId(tAliases, "mail.voiper.co.kr")) != HS_OK )
	{
		delete_NoLockList(tAliases);
		HSFree(tAliases);
		return tRet;
	}
	if( (tRet=HapiAddAliasEmailId(tAliases, "root@voiper.co.kr")) != HS_OK )
	{
		delete_NoLockList(tAliases);
		HSFree(tAliases);
		return tRet;
	}*/

	return HapiCommandChangeEndpointAliases(hStack, tAliases);
}





unsigned __stdcall AppMain( void *pArg )
{
	MSG qMsg;
	BOOL stackOut = HS_NO;

	HS_RESULT tRet = HS_OK;
	HS_CALL_HANDLE callHandle = HS_INVALID_CALL_HANDLE;
	HS_STACK_HANDLE stackHandle = HS_INVALID_STACK_HANDLE;

	QMARegist *tQRegist = HS_NULL;
	ControlMsg *tUserInput = HS_NULL;

	/* stack start
	*/
	stackHandle = HapiStartStack( AppH323MakeEndpoint() );
	if( stackHandle == HS_INVALID_STACK_HANDLE )
	{
		HSPrint( "\n <APP> Stack Start Error." );
		return 0;
	}

	/* Use External Program For Media Processing
	*/
#ifdef HS_EXTERNAL_MEDIA_PROGRAM
	if( (tRet=OpenAudioHandler(&gAudioHandler, HS_PIPE_PORT_MEDIA)) == HS_OK )
		gIsUseExternalMediaProgram = HS_YES;
	else
	{
		HSPrint( "\n <APP> Fail to use external media program, tRet(%d)", tRet );
		gIsUseExternalMediaProgram = HS_YES;
	}
#endif

	/* application demon
	*/
	while( stackOut == HS_NO )
	{
        GetMessage(&qMsg, NULL, HS_QMESSAGE_APP, HS_QMESSAGE_APP_MAX);
		switch(qMsg.message)
		{
			case HS_QMESSAGE_APP_REGIST:
				HSPrint( "\n [] App : Registration..."  );
				if( (tQRegist=(QMARegist*)(qMsg.lParam)) != HS_NULL )
				{
					strcpy(gDefinePrimaryGk, (char*)(tQRegist->prime));
					strcpy(gDefineSecondaryGk, (char*)(tQRegist->second));
					HapiCommandChangeGatekeeper(stackHandle, gDefinePrimaryGk);
					gIsRegisterTrying = HS_YES;
					delete_QMARegist(tQRegist);
				}
				break;

			case HS_QMESSAGE_APP_UNREGIST:
				HSPrint( "\n [] App : Unregistration..."  );
				HapiCommandChangeGatekeeper( stackHandle, "" );
				gIsRegisterTrying = HS_NO;
				gIsPrimaryGk = HS_YES;
				break;

			case HS_QMESSAGE_APP_CHANGE_ID:
				if( gCallHandle == HS_INVALID_CALL_HANDLE )
					AppChangeEndpointAlias(stackHandle, (QMAChangeId*)(qMsg.lParam));

				delete_QMAChangeId( (QMAChangeId*)(qMsg.lParam) );
				break;

			case HS_QMESSAGE_APP_CALL:
				/* only one call !
				*/
				if( gCallHandle == HS_INVALID_CALL_HANDLE )
				{
					callHandle = AppH323MakeCall(stackHandle, (ICall*)(qMsg.lParam));
					if( callHandle != HS_INVALID_CALL_HANDLE )
						gCallHandle = callHandle;
					else
					{
						HapiCallClose( (ICall*)(qMsg.lParam) );
						if( gHwnd != HS_NULL )
							PostMessage(gHwnd, HS_QMESSAGE_APP_REMOVED, 0, 0);
					}
				}
				else
				{
					HapiCallClose( (ICall*)(qMsg.lParam) );
					if( gHwnd != HS_NULL )
						PostMessage(gHwnd, HS_QMESSAGE_APP_REMOVED, 0, 0);
				}
				break;

			case HS_QMESSAGE_APP_ACCEPT:
				if( gCallHandle != HS_INVALID_CALL_HANDLE )
					HapiCommandAcceptCall(stackHandle, gCallHandle);
				else
				{
					if( gHwnd != HS_NULL )
						PostMessage(gHwnd, HS_QMESSAGE_APP_REMOVED, 0, 0);
				}
				break;

			case HS_QMESSAGE_APP_DROP:
				if( gCallHandle != HS_INVALID_CALL_HANDLE )
					HapiCommandRemoveCall(stackHandle, gCallHandle,e_CallCloseReason_Normal);
				else
				{
					if( gHwnd != HS_NULL )
						PostMessage(gHwnd, HS_QMESSAGE_APP_REMOVED, 0, 0);
				}
				break;

			case HS_QMESSAGE_APP_GRQ:
				if( qMsg.lParam == 0 )	HapiCommandUseGRQ(stackHandle, HS_NO );
				else					HapiCommandUseGRQ(stackHandle, HS_YES);
				break;

			case HS_QMESSAGE_APP_DTMF:
				if( gCallHandle != HS_INVALID_CALL_HANDLE )
				{
					tUserInput = AppMakeDtmfH245UserInputIndication( (char)(qMsg.lParam), 100 );
					HapiCommandH245UserInputIndication(stackHandle, gCallHandle, tUserInput);
				}
				else
				{
					if( gHwnd != HS_NULL )
						PostMessage(gHwnd, HS_QMESSAGE_APP_REMOVED, 0, 0);
				}
				break;

			case HS_QMESSAGE_APP_END:
			case 0:
				if( gCallHandle != HS_INVALID_CALL_HANDLE )
					HapiCommandRemoveCall(stackHandle, gCallHandle,e_CallCloseReason_Normal);
				HSPrint( "\n - Ending Application..." );
				stackOut = HS_YES;
				break;

			default:
				break;
		}
	}


	/* closing
	*/
#ifdef HS_EXTERNAL_MEDIA_PROGRAM
	if( gIsUseExternalMediaProgram == HS_YES )
	{
		if( (tRet=CloseAudioHandler(&gAudioHandler)) != HS_OK )
			HSPrint( "\n <APP> Fail to close external media progream, tRet(%u)", tRet );
	}
#endif

	HapiStopStack( stackHandle );
	return 0;
}


HS_QUEUE_ID AppStartH323Stack(HWND pHwnd, IEndpoint *pEndpoint, HS_UCHAR *pLocalIp)
{
	HS_QUEUE_ID	tQ;

	if( pHwnd == HS_NULL ) return HS_INVALID_QUEUE_ID;

	gHwnd = pHwnd;
	memcpy(gLocalIp, pLocalIp, 4);

	if( _beginthreadex(HS_NULL, 0, &AppMain, pEndpoint, 0, &tQ) == -1 )
	{
		gHwnd = HS_NULL;
		return HS_INVALID_QUEUE_ID;
	}

	return tQ;
}
