/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/ 

/*

	<AppMain.cpp>	2005-11-02,23:01

*/

#include "AppMain.h"
#include "AppQmessage.h"
#include <conio.h>





/********************************************************************/
/* global variable
*/
HWND gHwnd = NULL;
HS_STACK_HANDLE gHStack = HS_INVALID_STACK_HANDLE;
HS_RTP_HANDLE	gRtpHandle = HS_INVALID_RTP_HANDLE;





/*
 *
 * callback functions
 *
 */
BOOL AppCallbackReceiveRawData(HS_UCHAR *pRaw, int pLen)
{
	HSPrint( "\n[APP] callback:AppCallbackReceiveRawData" );
#if 0
	HSPrint( "\n====================================\n" );
	HSPrint( "%s", pRaw );
	HSPrint( "====================================" );
#endif

	if( gHwnd != NULL )
		PostMessage(gHwnd,HS_QM_APP_RECV_MSG,(WPARAM)pLen,(LPARAM)SipStringAlloc((char*)pRaw));

	return TRUE;
}
/* request messages except ACK,PRACK
   return value, SipResponse is selected response about request by programer user
   if it is a e_SipResponseMax, stack do process by his decision
*/
SipResponse AppCallbackReceiveMessageToResponse(
	HS_UA_HANDLE pHUa,
	HS_CALL_HANDLE pHCall,
	SipMessage *pMessage
)
{
	HSPrint( "\n[APP] callback:AppCallbackReceiveMessageToResponse" );

	if( pMessage==NULL ) return e_SipResponse_BadRequest;
	if( pMessage->mHeadLine.mMethod==NULL ) return e_SipResponse_BadRequest;

	HSPrint( ":%s", pMessage->mHeadLine.mMethod );

	if( !strcmp(pMessage->mHeadLine.mMethod,"INVITE") )
		return e_SipResponse_Ringing;
	return e_SipResponse_Ok;
}
/* response message and ACK,PRACK request message event
*/
BOOL AppCallbackReceiveMessage(HS_UA_HANDLE pHUa, HS_CALL_HANDLE pHCall, SipMessage *pMessage)
{
	HSPrint( "\n[APP] callback:AppCallbackReceiveMessage" );

	if( pMessage==NULL ) return FALSE;

	if( pMessage->mHeadLine.mMethod!=NULL )
		HSPrint( ":%s", pMessage->mHeadLine.mMethod );
	HSPrint( ":%d", pMessage->mHeadLine.mResponseValue );

	return TRUE;
}


BOOL AppCallbackSendMessage(HS_UA_HANDLE pHUa, HS_CALL_HANDLE pHCall, SipMessage *pMessage)
{
	HSPrint( "\n[APP] callback:AppCallbackSendMessage" );

	if( pMessage==NULL ) return FALSE;

	if( pMessage->mHeadLine.mMethod!=NULL )
		HSPrint( ":%s", pMessage->mHeadLine.mMethod );
	HSPrint( ":%d", pMessage->mHeadLine.mResponseValue );

	return TRUE;
}


BOOL AppCallbackSendRawData(HS_UA_HANDLE pHUa, HS_CALL_HANDLE pHCall, HS_UCHAR *pRaw, int pLen)
{
	HSPrint( "\n[APP] callback:AppCallbackSendRawData" );
#if 0
	HSPrint( "\n====================================\n" );
	HSPrint( "%s", pRaw );
	HSPrint( "====================================" );
#endif

	if( gHwnd != NULL )
		PostMessage(gHwnd,HS_QM_APP_SEND_MSG,(WPARAM)pLen,(LPARAM)SipStringAlloc((char*)pRaw));

	return TRUE;
}


void AppCallbackBnfDecodingError(HS_UCHAR* pData, int pLen)
{
	HSPrint( "\n[APP] callback:AppCallbackBnfDecodingError" );
	HSPrint( "\n====================================\n" );
	HSPrint( "%s", pData );
	HSPrint( "====================================" );

	if( gHwnd != NULL )
		PostMessage(gHwnd,HS_QM_APP_BAD_MSG,(WPARAM)pLen,(LPARAM)SipStringAlloc((char*)pData));
}


void AppCallbackCallIncoming(HS_STACK_HANDLE pHandle, void* pCall)
{
	HS_CALL_HANDLE tHandle = HS_INVALID_HANDLE;

	HSPrint( "\n[APP] callback:AppCallbackCallIncoming" );

	if( pCall==NULL ) return;

	if( (tHandle=SapiGetDialogueHandle((IDialogue*)pCall))==HS_INVALID_HANDLE ) return;
	SapiAddMediaCapabilityToDialogue(pHandle,(IDialogue*)pCall,"audio",e_RtpPayloadType_Pcma);
	SapiAddMediaCapabilityToDialogue(pHandle,(IDialogue*)pCall,"audio",e_RtpPayloadType_Pcmu);
	SapiAddMediaCapabilityToDialogue(pHandle,(IDialogue*)pCall,"audio",e_RtpPayloadType_G729);

	if( gHwnd != NULL )
		PostMessage(gHwnd,HS_QM_APP_CALL_INCOMING,0,(LPARAM)tHandle);
}


void AppCallbackCallEnded(HS_UA_HANDLE pHUa, HS_CALL_HANDLE pHCall, SipResponse pResponse)
{
	HSPrint( "\n[APP] callback:AppCallbackCallEnded" );

	if( gHwnd != NULL )
		PostMessage(gHwnd,HS_QM_APP_CALL_ENDED,(WPARAM)pResponse,(LPARAM)pHCall);
}


void AppCallbackCallRemoved(HS_UA_HANDLE pHUa, HS_CALL_HANDLE pHCall)
{
	HSPrint( "\n[APP] callback:AppCallbackCallRemoved" );

	if( gHwnd != NULL )
		PostMessage(gHwnd,HS_QM_APP_CALL_REMOVED,0,(LPARAM)pHCall);
}


BOOL AppCallbackCallToRemove(HS_UA_HANDLE pHUa, HS_CALL_HANDLE pHCall, RemoveReason pReason)
{
	HSPrint( "\n[APP] callback:AppCallbackCallToRemove" );

	if( gHwnd != NULL )
		PostMessage(gHwnd,HS_QM_APP_CALL_TO_REMOVE,0,(LPARAM)pHCall);

	return TRUE;
}


HS_RESULT AppCallbackCheckSdp(void* pCall, SdpMessage* pSdp)
{
	HSPrint( "\n[APP] callback:AppCallbackCheckSdp" );
	return HS_ERR;
}


void AppCallbackOpenMedia(HS_CALL_HANDLE pHandle,void* pMediaInfo)
{
	HS_UINT tFpp = 1;
	MediaInfo *tInfo = (MediaInfo*)pMediaInfo;
	HSPrint( "\n[APP] callback:AppCallbackOpenMedia" );

	if( tInfo==NULL ) return;
	if( tInfo->mType==NULL ) return;
	if( tInfo->mRemoteRtpAddr==NULL ) return;

	HSPrint( ":handle(%u)", pHandle );
	HSPrint( ":type(%s)", tInfo->mType );
	HSPrint( ":remote(%s:%u)", tInfo->mRemoteRtpAddr, tInfo->mRemoteRtpPort );
	HSPrint( ":local(%s:%u)", (tInfo->mLocalRtpAddr==NULL)? "NULL":tInfo->mLocalRtpAddr, tInfo->mLocalRtpPort );

	if( strcmp(tInfo->mType,"audio") ) return;
	if( gRtpHandle!=HS_INVALID_RTP_HANDLE )
	{
		CloseRtp(gRtpHandle);
		gRtpHandle = HS_INVALID_RTP_HANDLE; 
	}

	if( (gRtpHandle=OpenRtp())==HS_INVALID_RTP_HANDLE )
		return;

	switch((RtpPayloadType)(tInfo->mNumber))
	{
		case e_RtpPayloadType_Pcma:
		case e_RtpPayloadType_Pcmu:
			tFpp = 4;
			break;
		case e_RtpPayloadType_G729:
			tFpp = 2;
			break;
		default:
			tFpp = 1;
			break;
	}

	/* hearing
	*/
	if( tInfo->mLocalRtpAddr != NULL )
		StartReverseRtp(gRtpHandle,(RtpPayloadType)(tInfo->mNumber),tInfo->mLocalRtpPort);
	/* talking
	*/
	if( tInfo->mRemoteRtpAddr!=NULL )
		StartForwardRtp(gRtpHandle,(RtpPayloadType)(tInfo->mNumber),tInfo->mRemoteRtpAddr,tInfo->mRemoteRtpPort,tFpp);

	if( gHwnd != NULL )
		PostMessage(gHwnd,HS_QM_APP_MEDIA_OPEN,0,(LPARAM)(tInfo->mNumber));
}


void AppCallbackCloseMedia(HS_CALL_HANDLE pHandle,void* pMediaInfo)
{
	MediaInfo *tInfo = (MediaInfo*)pMediaInfo;
	HSPrint( "\n[APP] callback:AppCallbackCloseMedia" );

	if( tInfo==NULL ) return;
	printf( "\n:handle(%u)", pHandle );

	if( tInfo->mType != NULL ) printf( ":type(%s)", tInfo->mType );
	if( tInfo->mLocalRtpAddr != NULL ) printf( ":local(%s:%u)", tInfo->mLocalRtpAddr, tInfo->mLocalRtpPort );
	if( tInfo->mRemoteRtpAddr!= NULL ) printf( ":remote(%s:%u)", tInfo->mRemoteRtpAddr, tInfo->mRemoteRtpPort );
	if( gRtpHandle==HS_INVALID_RTP_HANDLE ) return;

	CloseRtp(gRtpHandle);
	gRtpHandle = HS_INVALID_RTP_HANDLE;

	if( gHwnd != NULL )
		PostMessage(gHwnd,HS_QM_APP_MEDIA_CLOSE,0,(LPARAM)(tInfo->mNumber));
}


void AppCallbackRegisted(HS_UA_HANDLE pHUa)
{
	HSPrint( "\n[APP] callback:AppCallbackRegisted:ua(%u)", pHUa );

	if( gHwnd != NULL )
		PostMessage(gHwnd,HS_QM_APP_UA_REGI_SUCC,0,(LPARAM)pHUa);
}


void AppCallbackRegisterFail(HS_UA_HANDLE pHUa)
{
	HSPrint( "\n[APP] callback:AppCallbackRegisterFail:ua(%u)", pHUa );

	if( gHwnd != NULL )
		PostMessage(gHwnd,HS_QM_APP_UA_REGI_FAIL,0,(LPARAM)pHUa);
}


void AppCallbackUaRemoved(HS_UA_HANDLE pHUa)
{
	HSPrint( "\n[APP] callback:AppCallbackUaRemoved:ua(%u)", pHUa );

	if( gHwnd != NULL )
		PostMessage(gHwnd,HS_QM_APP_UA_REMOVED,0,(LPARAM)pHUa);
}


void AppCallbackStackInformation(HS_STACK_HANDLE pHStack)
{
	HSPrint( "\n[APP] callback:AppCallbackStackInformation" );
}





/*
 *
 * rapping functions
 *
 */
HS_RESULT AppStartSipStack(HWND pHwnd, char *pLocalIp)
{
	HS_RESULT tRet = HS_OK;
	IStack *tStack = HS_INVALID_STACK_HANDLE;

	if( gHStack != HS_INVALID_STACK_HANDLE ) return HS_OK;
	if( pHwnd==NULL || pLocalIp==NULL ) return HS_ERR_NULL_PARAM;

	if( (tStack=(IStack*)SapiMakeStackHandle(pLocalIp,"cryptack_sip_ua_by_voiper"))==HS_INVALID_STACK_HANDLE )
		return HS_ERR_MALLOC;

	tStack->CallbackBnfDecodingError = AppCallbackBnfDecodingError;
	tStack->CallbackCallIncoming = AppCallbackCallIncoming;
	tStack->CallbackCallEnded = AppCallbackCallEnded;
	tStack->CallbackCallRemoved = AppCallbackCallRemoved;
	tStack->CallbackCallToRemove = AppCallbackCallToRemove;
	tStack->CallbackCheckSdp = AppCallbackCheckSdp;
	tStack->CallbackCloseMedia = AppCallbackCloseMedia;
	tStack->CallbackOpenMedia = AppCallbackOpenMedia;
	tStack->CallbackReceiveMessage = AppCallbackReceiveMessage;
	tStack->CallbackReceiveMessageToResponse = AppCallbackReceiveMessageToResponse;
	tStack->CallbackReceiveRawData = AppCallbackReceiveRawData;
	tStack->CallbackRegisted = AppCallbackRegisted;
	tStack->CallbackRegisterFail = AppCallbackRegisterFail;
	tStack->CallbackSendMessage = AppCallbackSendMessage;
	tStack->CallbackSendRawData = AppCallbackSendRawData;
	tStack->CallbackStackInformation = AppCallbackStackInformation;
	tStack->CallbackUaRemoved = AppCallbackUaRemoved;

	if( (tRet=SapiStartStack(tStack,5060,5060)) != HS_OK )
	{
		SapiRemoveStackHandle(tStack);
		return tRet;
	}

	OpenHSPrint(pLocalIp);
	gHwnd = pHwnd;
	gHStack = (HS_STACK_HANDLE)tStack;
	return HS_OK;
}


HS_RESULT AppStopSipStack()
{
	if( gHStack == HS_INVALID_STACK_HANDLE )
		return HS_OK;

	/* stop stack
	*/
	CloseHSPrint();
	gHwnd = NULL;
	gHStack = HS_INVALID_STACK_HANDLE;
	return SapiStopStack(gHStack);
}


HS_RESULT AppDirectCall(
	char *pSourceIp,
	char *pDestIp,
	char *pSource,
	char *pDest,
	char *pPassword,
	HS_UA_HANDLE *pUaHandle,
	HS_CALL_HANDLE *pCallHandle
)
{
	IUa *tUa = NULL;
	IDialogue *tDialogue = NULL;
	HS_UA_HANDLE tUaHandle = HS_INVALID_HANDLE;
	HS_CALL_HANDLE tCallHandle = HS_INVALID_HANDLE;

	if( gHStack==HS_INVALID_STACK_HANDLE || pDestIp==NULL || pSource==NULL || pDest==NULL 
		|| pUaHandle==NULL || pCallHandle==NULL ) return HS_ERR_NULL_PARAM;

	if( (tUa=SapiMakeUa(pDestIp,NULL,5060,60))==NULL ) return HS_ERR_MALLOC;

	if( SapiAddContactToUa(gHStack,tUa,NULL,pSource,pSourceIp,5060,HS_UINT_MAX)!=HS_OK )
	{
		SapiRemoveUa(tUa);
		return HS_ERR;
	}
	if( pPassword != NULL )
	{
		if( SapiSetPasswordToUa(tUa,pPassword)!=HS_OK )
		{
			SapiRemoveUa(tUa);
			return HS_ERR;
		}
	}
	if( (tUaHandle=SapiCommandAddUa(gHStack,tUa))==HS_INVALID_HANDLE )
	{
		SapiRemoveUa(tUa);
		return HS_ERR;
	}

	if( (tDialogue=SapiMakeDialogue(NULL,pDest,NULL,HS_INVALID_TSAP_PORT,FALSE))==NULL )
	{
		SapiCommandRemoveUa(gHStack,tUaHandle);
		return HS_ERR_MALLOC;
	}

	if( SapiAddMediaCapabilityToDialogue(gHStack,tDialogue,"audio",e_RtpPayloadType_Pcma) != HS_OK )
	{
		SapiCommandRemoveUa(gHStack,tUaHandle);
		SapiRemoveDialogue(tDialogue);
		return HS_ERR;
	}
	if( SapiAddMediaCapabilityToDialogue(gHStack,tDialogue,"audio",e_RtpPayloadType_Pcmu) != HS_OK )
	{
		SapiCommandRemoveUa(gHStack,tUaHandle);
		SapiRemoveDialogue(tDialogue);
		return HS_ERR;
	}

	if( (tCallHandle=SapiCommandMakeCall(gHStack,tUaHandle,tDialogue))==HS_INVALID_HANDLE )
	{
		SapiCommandRemoveUa(gHStack,tUaHandle);
		SapiRemoveDialogue(tDialogue);
		return HS_ERR;
	}

	/* when direct call is over,
	   temp UA have to delete on stack.
	*/
	SapiCommandRemoveUa(gHStack,tUaHandle);
	*pUaHandle = tUaHandle;
	*pCallHandle = tCallHandle;
	return HS_OK;
}


HS_UA_HANDLE AppUaRegist(
	char *pProxy,
	char *pOutboundProxy,
	char *pDisplayName,
	char *pUserName,
	char *pPassword,
	char *pLocalIp,
	HS_UINT pExpires
)
{
	IUa *tUa = NULL;
	HS_UA_HANDLE tResult = HS_INVALID_HANDLE;

	if( gHStack==HS_INVALID_STACK_HANDLE || pProxy==NULL || pUserName==NULL || pLocalIp==NULL || pExpires==0 )
		return HS_INVALID_HANDLE;

	if( (tUa=SapiMakeUa(pProxy,pOutboundProxy,5060,pExpires))==NULL ) return HS_INVALID_HANDLE;

	if( SapiAddContactToUa(gHStack,tUa,pDisplayName,pUserName,pLocalIp,5060,HS_UINT_MAX)!=HS_OK )
	{
		SapiRemoveUa(tUa);
		return HS_INVALID_HANDLE;
	}
	if( pPassword != NULL )
	{
		if( SapiSetPasswordToUa(tUa,pPassword)!=HS_OK )
		{
			SapiRemoveUa(tUa);
			return HS_INVALID_HANDLE;
		}
	}
	if( (tResult=SapiCommandAddUa(gHStack,tUa))==HS_INVALID_HANDLE )
	{
		SapiRemoveUa(tUa);
		return HS_INVALID_HANDLE;
	}

	if( SapiCommandRegistUa(gHStack,tResult) != HS_OK )
	{
		SapiCommandRemoveUa(gHStack,tResult);
		return HS_INVALID_HANDLE;
	}

	return tResult;
}


HS_RESULT AppUaRegist(HS_UA_HANDLE pHandle)
{
	if( gHStack == HS_INVALID_STACK_HANDLE )
		return HS_ERR;
	return SapiCommandRegistUa(gHStack,pHandle);
}


HS_RESULT AppUaRemove(HS_UA_HANDLE pHandle)
{
	if( gHStack == HS_INVALID_STACK_HANDLE )
		return HS_ERR;
	return SapiCommandRemoveUa(gHStack,pHandle);
}


HS_CALL_HANDLE AppMakeCall(HS_UA_HANDLE pHUa, char *pDest)
{
	IDialogue *tDialogue = NULL;
	HS_CALL_HANDLE tResult = HS_INVALID_HANDLE;

	if( gHStack==HS_INVALID_STACK_HANDLE || pHUa==HS_INVALID_HANDLE || pDest==NULL ) return HS_INVALID_HANDLE;
	if( (tDialogue=SapiMakeDialogue(NULL,pDest,NULL,HS_INVALID_TSAP_PORT,FALSE))==NULL )
		return HS_INVALID_HANDLE;

	if( SapiAddMediaCapabilityToDialogue(gHStack,tDialogue,"audio",e_RtpPayloadType_Pcma) != HS_OK )
	{
		SapiRemoveDialogue(tDialogue);
		return HS_INVALID_HANDLE;
	}
	if( SapiAddMediaCapabilityToDialogue(gHStack,tDialogue,"audio",e_RtpPayloadType_Pcmu) != HS_OK )
	{
		SapiRemoveDialogue(tDialogue);
		return HS_INVALID_HANDLE;
	}
	if( SapiAddMediaCapabilityToDialogue(gHStack,tDialogue,"audio",e_RtpPayloadType_G729) != HS_OK )
	{
		SapiRemoveDialogue(tDialogue);
		return HS_INVALID_HANDLE;
	}

	if( (tResult=SapiCommandMakeCall(gHStack,pHUa,tDialogue))==HS_INVALID_HANDLE )
	{
		SapiRemoveDialogue(tDialogue);
		return HS_INVALID_HANDLE;
	}
	return tResult;
}


HS_RESULT AppAcceptCall(HS_CALL_HANDLE pCallHandle)
{
	if( gHStack==HS_INVALID_STACK_HANDLE || pCallHandle==HS_INVALID_HANDLE )
		return HS_ERR_NULL_PARAM;

	IS_INCOMING_CALL(pCallHandle)
		return SapiCommandAcceptCall(gHStack,pCallHandle);
	return HS_ERR;
}


HS_RESULT AppDropCall(HS_CALL_HANDLE pCallHandle, SipResponse pReason)
{
	if( gHStack==HS_INVALID_STACK_HANDLE || pCallHandle==HS_INVALID_HANDLE )
		return HS_ERR_NULL_PARAM;

	return SapiCommandRemoveCall(gHStack,pCallHandle,pReason);
}



