/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ppCbSip.h>		2006-03-07,22:18

  : callback functions for SIP UA stack.
*/

#ifndef __2006_03_07__22_18__PPCBSIP_H__
#define __2006_03_07__22_18__PPCBSIP_H__

#include "ppDefine.h"
#include "ppHandle.h"





#define HS_DEBUG_SIP
//#define HS_DEBUG_SIP_MSG




BOOL AppCallbackReceiveRawData(HS_UCHAR *pRaw, int pLen);
SipResponse AppCallbackReceiveMessageToResponse(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,SipMessage *pMessage);
BOOL AppCallbackReceiveMessage(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,SipMessage *pMessage);
BOOL AppCallbackSendMessage(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,SipMessage *pMessage);
BOOL AppCallbackSendRawData(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,HS_UCHAR *pRaw,int pLen);
void AppCallbackBnfDecodingError(HS_UCHAR* pData,int pLen);

void AppCallbackCallIncoming(HS_STACK_HANDLE pHandle,void* pCall);
void AppCallbackCallEnded(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,SipResponse pResponse);
void AppCallbackCallRemoved(HS_UA_HANDLE pUa, HS_CALL_HANDLE pCall);
BOOL AppCallbackCallToRemove(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,RemoveReason pReason);

void AppCallbackOutbandDtmf(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,char *pType,char *pBody,HS_UINT pBodyLen);
void AppCallbackInstantMessage(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,char *pType,char *pBody,HS_UINT pBodyLen);

HS_RESULT AppCallbackCheckSdp(void* pCall,SdpMessage* pSdp);
void AppCallbackOpenMedia(HS_CALL_HANDLE pCall,void* pMediaInfo);
void AppCallbackCloseMedia(HS_CALL_HANDLE pCall,void* pMediaInfo);

void AppCallbackRegisted(HS_UA_HANDLE pUa);
void AppCallbackRegisterFail(HS_UA_HANDLE pUa);

void AppCallbackUaRemoved(HS_UA_HANDLE pUa);
void AppCallbackStackInformation(HS_STACK_HANDLE pHStack);





#endif/*__2006_03_07__22_18__PPCBSIP_H__*/