/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ppCore.c>		2006-03-07,22:12

*/

#include "ppCore.h"





/*
 *
 * ppCore main task
 *
 */
static HS_RESULT PPCore_Main(HS_TQ pQ,void *pObject,void *pArg)
{
	HSQmsg tQmsg;
	HSTimerEvent *tTimerEvent = NULL;
	PPCore *pObj = (PPCore*)pObject;

	if( pObj==NULL )
		return HSExitThread(pQ,HS_ERR_NULL_PARAM);

	if( PPCore_Initialize(pObj) != HS_OK )
	{
		deletem_PPCore(pObj);
		if( pObj->mHwnd != NULL )
			SendMessage(pObj->mHwnd,HS_QM_APP_STACK_FAIL,0,0);
		return HSExitThread(pQ,HS_ERR);
	}
	HSSetTimer(
		PP_REGI_INTERVAL*1000,
		pObj->mQid,
		PP_REGI_TID,0,
		e_TimerType_Forever
	);

	/* core demon
	*/
	pObj->mActive = TRUE;
	while(pObj->mActive)
	{
		if( HSThreadGetMessage(pQ,&tQmsg,HS_QM,HS_QM_PP_MAX,TRUE)==HS_OK )
		{
			switch(tQmsg.message)
			{
				case HS_QM_STOP:
					pObj->mActive = FALSE;
					break;
				case HS_QM_CHECK:
					HSPrint("\n%s alive.",pObj->mName);
					break;
				case HS_QM_TIMER:
					if( (tTimerEvent=(HSTimerEvent*)(tQmsg.lParam))==NULL )
						break;
					if( tTimerEvent->mTid==PP_REGI_TID )
						PPCore_HandleRegistCheck(pObj);
					deletem_HSTimerEvent(tTimerEvent);
					break;
			/*
			 *
			 * event from user interface to PP
			 *
			 */
				case HS_QM_PP_OPTION:
					PPCore_HandleOption(pObj,(PPOption*)(tQmsg.lParam));
					break;
				case HS_QM_PP_HOOK_OFF:
					PPCore_HandleHookOff(pObj);
					break;
				case HS_QM_PP_HOOK_ON:
					PPCore_HandleHookOn(pObj);
					break;
				case HS_QM_PP_DTMF:
					PPCore_HandleDtmf(pObj,(BOOL)(tQmsg.wParam),(char)(tQmsg.lParam));
					break;
				case HS_QM_PP_DTMF_CANCEL:
					PPCore_HandleDtmfCancel(pObj);
					break;
				case HS_QM_PP_DTMF_CLEAR:
					PPCore_HandleDtmfClear(pObj);
					break;
				case HS_QM_PP_MAKE_CALL:
					PPCore_HandleMakeCall(pObj,tQmsg.wParam,(char*)(tQmsg.lParam)/*(if it's null,try by DTMF signal buffer)*/);
					break;
				case HS_QM_PP_HOLD:
					PPCore_HandleRtpHold(pObj,(PPDirection)(tQmsg.lParam));
					break;
				case HS_QM_PP_RESUME:
					PPCore_HandleRtpResume(pObj,(PPDirection)(tQmsg.lParam));
					break;
				case HS_QM_PP_INST_MSG:
					PPCore_HandleSndInstantMessage(pObj,(char*)(tQmsg.lParam));
					break;
			/*
			 *
			 * event from callback to PP
			 *
			 */
				case HS_QM_PP_CID:
					PPCore_HandleCid(pObj,tQmsg.wParam,(char*)(tQmsg.lParam));
					break;
				case HS_QM_PP_INCOMING:
					PPCore_HandleIncomingCall(pObj,tQmsg.wParam,(HS_CALL_HANDLE)(tQmsg.lParam));
					break;
				case HS_QM_PP_RING_BACK:
					PPCore_HandleRingback(pObj,tQmsg.wParam,(HS_CALL_HANDLE)(tQmsg.lParam));
					break;
				case HS_QM_PP_SESSION:
					PPCore_HandleSession(pObj,(QmMediaInfo*)(tQmsg.lParam));
					break;
				case HS_QM_PP_UNSESSION:
					PPCore_HandleUnsession(pObj,(PPDirection)(tQmsg.lParam));
					break;
				case HS_QM_PP_CONNECTED:
					PPCore_HandleConnected(pObj,tQmsg.wParam,(HS_CALL_HANDLE)(tQmsg.lParam));
					break;
				case HS_QM_PP_OUT_DTMF:
					PPCore_HandleOutDtmf(pObj,(QmSipContext*)(tQmsg.lParam));
					break;
				case HS_QM_PP_INSTANT_MSG:
					PPCore_HandleRcvInstantMessage(pObj,(QmSipContext*)(tQmsg.lParam));
					break;
				case HS_QM_PP_CALL_END:
					PPCore_HandleCallEnd(pObj,tQmsg.wParam,(QmCallEnd*)(tQmsg.lParam));
					break;
				case HS_QM_PP_REGIST_SUCC:
					PPCore_HandleRegistSuccess(pObj,tQmsg.wParam,tQmsg.lParam);
					break;
				case HS_QM_PP_REGIST_FAIL:
					PPCore_HandleRegistFail(pObj,tQmsg.wParam,tQmsg.lParam);
					break;
			}
		}
	}

	deletem_PPCore(pObj);
	return HSExitThread(pQ,HS_OK);
}





HS_QID PPCore_Start(HWND pHwnd,HS_UCHAR *pLocalIp,PPOption pOption)
{
	PPCore *tCore = NULL;
	HS_QID tQid = HS_INVALID_QID;

	if( pLocalIp==NULL ) return HS_INVALID_QID;
	if( (tCore=newm_PPCore(pHwnd,pLocalIp,pOption))==NULL ) return HS_INVALID_QID;
	if( (tQid=HSThreadStart(tCore,NULL,PPCore_Main))==HS_INVALID_QID )
	{
		deletem_PPCore(tCore);
		return HS_INVALID_QID;
	}

	ppHandle_SetCoreQid(tQid);
	return tQid;
}


HS_RESULT PPCore_Stop(HS_QID pQid)
{
	if( pQid==HS_INVALID_QID ) return HS_ERR_NULL_PARAM;

	ppHandle_SetCoreQid(HS_INVALID_QID);
	return _HSThreadStop(pQid);
}




