/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ppOption.h>	2006-02-16:21:08

  : option data about H.323 and SIP protocol.
*/

#ifndef __2006_02_16__21_08__PPOPTION_H__
#define __2006_02_16__21_08__PPOPTION_H__





#include "ppDefine.h"





#define PP_LETTER_MAX				128
#define PP_CODEC_G711A				0x00000001
#define PP_CODEC_G711U				0x00000002
#define PP_CODEC_G729				0x00000004
#define PP_CODEC_MSGSM				0x00000008
#define PP_CODEC_ILBC				0x00000010
#define PP_CODEC_NOTHING			0x00000000
#define PP_CODEC_ALL				(PP_CODEC_G711A+ PP_CODEC_G711U+ PP_CODEC_G729+ PP_CODEC_MSGSM+ PP_CODEC_ILBC)
#define PP_INCLUDE_G711A(codec)		(codec & PP_CODEC_G711A)
#define PP_INCLUDE_G711U(codec)		(codec & PP_CODEC_G711U)
#define PP_INCLUDE_G729(codec)		(codec & PP_CODEC_G729)
#define PP_INCLUDE_MSGSM(codec)		(codec & PP_CODEC_MSGSM)
#define PP_INCLUDE_ILBC(codec)		(codec & PP_CODEC_ILBC)

typedef enum
{
	e_PPOptionDtmfBand_Inband,
	e_PPOptionDtmfBand_Outband,
	e_PPOptionDtmfBand_Rfc2833,
	e_PPOptionDtmfBandMax
} PPOptionDtmfBand;
typedef enum
{
	e_PPOptionPreferProtocol_H323,
	e_PPOptionPreferProtocol_Sip,
	e_PPOptionPreferProtocolMax
} PPOptionPreferProtocol;

typedef struct
{
	HS_UINT					mCodec;
	PPOptionDtmfBand		mDtmfBand;
	PPOptionPreferProtocol	mPreferProtocol;
	char					mLogServer[128];
} PPOptionGeneral;

HS_RESULT new_PPOptionGeneral(void *pObject);
HS_RESULT delete_PPOptionGeneral(void *pObject);



typedef enum
{
	e_PPOptionH245AddrPoint_CallProceed,
	e_PPOptionH245AddrPoint_Alert,
	e_PPOptionH245AddrPoint_Connect,
	e_PPOptionH245AddrPointMax
} PPOptionH245AddrPoint;
typedef enum
{
	e_PPOptionFSRespPoint_CallProceed,
	e_PPOptionFSRespPoint_Alert,
	e_PPOptionFSRespPoint_Connect,
	e_PPOptionFSRespPointMax
} PPOptionFSRespPoint;

typedef struct
{
	/* mandatory values
	*/
	char		mH323Id[PP_LETTER_MAX];
	char		mPhoneNumber[PP_LETTER_MAX];
	char		mPrimeGk[PP_LETTER_MAX];
	HS_UINT		mTtl;
	/* optional values
	*/
	char		mSecondGk[PP_LETTER_MAX];
	BOOL		mFastStart;
	BOOL		mTunneling;
	BOOL		mEarlyH245;
	BOOL		mCanMapAlias;
	BOOL		mUseGRQ;
	BOOL		mUseBRQ;
	BOOL		mUseIRR;
	BOOL		mUseLightWeightRRQ;
	char		mCallingPartyNumber[PP_LETTER_MAX];
	/* further values
	*/
	PPOptionH245AddrPoint	mH245Point;
	PPOptionFSRespPoint		mFSPoint;
} PPOptionH323;

HS_RESULT new_PPOptionH323(void *pObject);
HS_RESULT delete_PPOptionH323(void *pObject);



typedef struct
{
	/* mandatory values
	*/
	char		mUserName[PP_LETTER_MAX];
	char		mPhoneNumber[PP_LETTER_MAX];
	HS_USHORT	mLocalUdpPort;
	HS_USHORT	mLocalTcpPort;

	char		mPrimeProxy[PP_LETTER_MAX];
	HS_USHORT	mPrimePort;
	HS_UINT		mTtl;
	/* optional values
	*/
	char		mSecondProxy[PP_LETTER_MAX];
	HS_USHORT	mSecondPort;

	char		mOutboundProxy[PP_LETTER_MAX];
	char		mDisplayName[PP_LETTER_MAX];
	char		mAuthId[PP_LETTER_MAX];
	char		mPassword[PP_LETTER_MAX];
	char		mTargetGw[PP_LETTER_MAX];
} PPOptionSip;

HS_RESULT new_PPOptionSip(void *pObject);
HS_RESULT delete_PPOptionSip(void *pObject);



typedef struct
{
	PPOptionGeneral		mGeneral;
	PPOptionH323		mH323;
	PPOptionSip		mSip;
} PPOption;

HS_RESULT new_PPOption(void *pObject);
HS_RESULT delete_PPOption(void *pObject);





#endif/*__2006_02_16__21_08__PPOPTION_H__*/


