// OptionH3231Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlusPhone.h"
#include "OptionH3231Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionH3231Dlg dialog


COptionH3231Dlg::COptionH3231Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionH3231Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionH3231Dlg)
	mRcdCheckEarly = FALSE;
	mRcdCheckFastStart = FALSE;
	mRcdCheckTunnel = FALSE;
	mRcdEditE164Id = _T("");
	mRcdEditGkAddr = _T("");
	mRcdEditGkPort = _T("");
	mRcdEditTtl = _T("");
	mRcdEditH323Id = _T("");
	//}}AFX_DATA_INIT
}


void COptionH3231Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionH3231Dlg)
	DDX_Check(pDX, IDC_CHECK_EARLY, mRcdCheckEarly);
	DDX_Check(pDX, IDC_CHECK_FASTSTART, mRcdCheckFastStart);
	DDX_Check(pDX, IDC_CHECK_TUNNEL, mRcdCheckTunnel);
	DDX_Text(pDX, IDC_EDIT_E164ID, mRcdEditE164Id);
	DDX_Text(pDX, IDC_EDIT_GK_ADDR, mRcdEditGkAddr);
	DDX_Text(pDX, IDC_EDIT_GK_PORT, mRcdEditGkPort);
	DDX_Text(pDX, IDC_EDIT_GK_TTL, mRcdEditTtl);
	DDX_Text(pDX, IDC_EDIT_H323ID, mRcdEditH323Id);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptionH3231Dlg, CDialog)
	//{{AFX_MSG_MAP(COptionH3231Dlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionH3231Dlg message handlers

BOOL COptionH3231Dlg::PreTranslateMessage(MSG* pMsg) 
{
	if( pMsg->message != WM_KEYDOWN )
		return CDialog::PreTranslateMessage(pMsg);
		
	/* ENTER, ESC and SPACE to TAP
	*/
	if( pMsg->wParam==13 || pMsg->wParam==27 || pMsg->wParam==32 )
		pMsg->wParam = 9;

	return CDialog::PreTranslateMessage(pMsg);
}

BOOL COptionH3231Dlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	mRcdCheckEarly = mOption.mEarlyH245;
	mRcdCheckFastStart = mOption.mFastStart;
	mRcdCheckTunnel = mOption.mTunneling;
	mRcdEditE164Id = mOption.mPhoneNumber;

	mRcdEditGkAddr = mOption.mPrimeGk;
	mRcdEditGkPort = mRcdEditGkAddr.Left( mRcdEditGkAddr.Find('@',0) );
	mRcdEditGkAddr = mRcdEditGkAddr.Right(
		mRcdEditGkAddr.GetLength()-mRcdEditGkPort.GetLength()-1
	);

#if defined(_WIN32_WCE)
	mRcdEditTtl.Format(_T("%u"),mOption.mTtl);
#else
	mRcdEditTtl.Format("%u",mOption.mTtl);
#endif
	mRcdEditH323Id = mOption.mH323Id;

	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void COptionH3231Dlg::UpdateDataEx()
{
	CString tString;

	UpdateData();

	new_PPOptionH323(&mOption);

	mOption.mEarlyH245 = mRcdCheckEarly;
	mOption.mFastStart = mRcdCheckFastStart;
	mOption.mTunneling = mRcdCheckTunnel;

#if defined(_WIN32_WCE)
	CString2CharString(mOption.mPhoneNumber,mRcdEditE164Id);
	tString = mRcdEditGkPort + (CString)"@" + mRcdEditGkAddr;
	CString2CharString(mOption.mPrimeGk,tString);
	mOption.mTtl = CString2Integer(mRcdEditTtl);
	CString2CharString(mOption.mH323Id,mRcdEditH323Id);
#else
	strcpy(mOption.mPhoneNumber,mRcdEditE164Id.GetBuffer(0));
	sprintf(mOption.mPrimeGk,"%s@%s",mRcdEditGkPort.GetBuffer(0),mRcdEditGkAddr.GetBuffer(0));
	mOption.mTtl = atoi(mRcdEditTtl.GetBuffer(0));
	strcpy(mOption.mH323Id,mRcdEditH323Id.GetBuffer(0));
#endif

	return;
}