// OptionSip2Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlusPhone.h"
#include "OptionSip2Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionSip2Dlg dialog


COptionSip2Dlg::COptionSip2Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionSip2Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionSip2Dlg)
	mRcdEditDisplayName = _T("");
	mRcdEditOutboundProxy = _T("");
	mRcdEditPassword = _T("");
	mRcdEditSProxyAddr = _T("");
	mRcdEditSProxyPort = _T("");
	mRcdEditAuthId = _T("");
	mRcdEditTargetGw = _T("");
	//}}AFX_DATA_INIT
}


void COptionSip2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionSip2Dlg)
	DDX_Text(pDX, IDC_EDIT_DISPLAY_NAME, mRcdEditDisplayName);
	DDX_Text(pDX, IDC_EDIT_OUTBOUND_PROXY, mRcdEditOutboundProxy);
	DDX_Text(pDX, IDC_EDIT_PASSWORD, mRcdEditPassword);
	DDX_Text(pDX, IDC_EDIT_SPROXY_ADDR, mRcdEditSProxyAddr);
	DDX_Text(pDX, IDC_EDIT_SPROXY_PORT, mRcdEditSProxyPort);
	DDX_Text(pDX, IDC_EDIT_AUTH_ID, mRcdEditAuthId);
	DDX_Text(pDX, IDC_EDIT_TARGET_GW, mRcdEditTargetGw);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptionSip2Dlg, CDialog)
	//{{AFX_MSG_MAP(COptionSip2Dlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionSip2Dlg message handlers

BOOL COptionSip2Dlg::PreTranslateMessage(MSG* pMsg) 
{
	if( pMsg->message != WM_KEYDOWN )
		return CDialog::PreTranslateMessage(pMsg);
		
	/* ENTER, ESC and SPACE to TAP
	*/
	if( pMsg->wParam==13 || pMsg->wParam==27 || pMsg->wParam==32 )
		pMsg->wParam = 9;

	return CDialog::PreTranslateMessage(pMsg);
}

BOOL COptionSip2Dlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	mRcdEditDisplayName = mOption.mDisplayName;
	mRcdEditOutboundProxy = mOption.mOutboundProxy;
	mRcdEditAuthId = mOption.mAuthId;
	mRcdEditPassword = mOption.mPassword;
	mRcdEditSProxyAddr = mOption.mSecondProxy;
	mRcdEditTargetGw = mOption.mTargetGw;
#if defined(_WIN32_WCE)
	mRcdEditSProxyPort.Format(_T("%u"),mOption.mSecondPort);
#else
	mRcdEditSProxyPort.Format("%u",mOption.mSecondPort);
#endif
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void COptionSip2Dlg::UpdateDataEx()
{
	UpdateData();

	new_PPOptionSip(&mOption);

#if defined(_WIN32_WCE)
	CString2CharString(mOption.mDisplayName,mRcdEditDisplayName);
	CString2CharString(mOption.mOutboundProxy,mRcdEditOutboundProxy);
	CString2CharString(mOption.mAuthId,mRcdEditAuthId);
	CString2CharString(mOption.mPassword,mRcdEditPassword);
	CString2CharString(mOption.mSecondProxy,mRcdEditSProxyAddr);
	mOption.mSecondPort = CString2Integer(mRcdEditSProxyPort);
	CString2CharString(mOption.mTargetGw,mRcdEditTargetGw);
#else
	strcpy(mOption.mDisplayName,mRcdEditDisplayName.GetBuffer(0));
	strcpy(mOption.mOutboundProxy,mRcdEditOutboundProxy.GetBuffer(0));
	strcpy(mOption.mAuthId,mRcdEditAuthId.GetBuffer(0));
	strcpy(mOption.mPassword,mRcdEditPassword.GetBuffer(0));
	strcpy(mOption.mSecondProxy,mRcdEditSProxyAddr.GetBuffer(0));
	mOption.mSecondPort = atoi(mRcdEditSProxyPort.GetBuffer(0));
	strcpy(mOption.mTargetGw,mRcdEditTargetGw.GetBuffer(0));
#endif

	return;
}

