/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<RtpSample.c>		2006-02-25,16:11

  : RTP Sample code

*/

#include <stdio.h>
#include <conio.h>

#include "RtpSample.h"





WORD wVersionRequested;
WSADATA wsaData;

int RtpSample_NetworkStartup()
{ 
	wVersionRequested = MAKEWORD( 2, 2 );
 	return WSAStartup(wVersionRequested,&wsaData);
}
void RtpSample_NetworkCleanup()
{
	if ( LOBYTE( wsaData.wVersion ) != 2 ||	HIBYTE( wsaData.wVersion ) != 2 )
		WSACleanup( );
}





/*
 *
 * main function
 *
 */
int main(int argc,char **argv)
{
	BOOL tProcOut = FALSE;
	HS_RTP_HANDLE tHandle = HS_INVALID_RTP_HANDLE;

	if( argc != 3 )
	{
		printf("> err: usage: RtpSample <direction:'a'/'f'/'r'> <destination IP address>");
		return 0;
	}
	if( RtpSample_NetworkStartup() != 0 )
	{
		printf("\n> err: fail to startup of network.");
		return 0;
	}
	if( (tHandle=OpenRtp())==HS_INVALID_RTP_HANDLE )
	{
		printf("\n> err: fail to get resource.");
		return 0;
	}

	switch(argv[1][0])
	{
		case 'a':
			StartForwardRtp(tHandle,e_RtpPayloadType_Pcmu,argv[2],7777,4);
			StartReverseRtp(tHandle,e_RtpPayloadType_Pcmu,7777);
			printf("\n> inf: RTP All Channel established");
			break;
		case 'f':
			StartForwardRtp(tHandle,e_RtpPayloadType_Pcmu,argv[2],7777,4);
			printf("\n> inf: RTP Forward Channel established");
			break;
		case 'r':
			StartReverseRtp(tHandle,e_RtpPayloadType_Pcmu,7777);
			printf("\n> inf: RTP Reverse Channel established");
			break;
	}

	while(tProcOut==FALSE)
	{
		switch(getch())
		{
			case 'e':
				tProcOut = TRUE;
				break;
			default:
				CheckRtp(tHandle);
				break;
		}
	}

	CloseRtp(tHandle);
	printf("\n> inf: RTP Channel closed, press any key to exit");
	getch();
	return 0;
}