/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<winTimer.h>	2005-03-13,10:30

*/

#ifndef __2005_03_13__10_30__WINTIMER_H__
#define __2005_03_13__10_30__WINTIMER_H__


#include "H323Define.h"
#include "EpDefine.h"
#include "QMessage.h"



HS_RESULT _h323_InitTimerList();
HS_RESULT _h323_CloseTimerList();
#define InitTimerList	_h323_InitTimerList
#define CloseTimerList	_h323_CloseTimerList



typedef enum
{
	e_TimerType_Once,
	e_TimerType_Forever
} TimerType;

typedef struct
{
	unsigned	milliSecond;
	HS_QUEUE_ID	queueId;
	HS_TIMER_ID timerId;
	HS_UINT		subId;
	TimerType	type;

	HS_UINT		timerListId;
} TimerObject;


/* when timer expire,
   timer thread send queue message to origin thread(calling thread)
   with #HSTimerEvent# struct.
*/
typedef struct
{
	HS_TIMER_ID	timerId;
	HS_UINT subId;
} HSTimerEvent;
HSTimerEvent *_h323_new_HSTimerEvent(HS_TIMER_ID pTimerId, HS_UINT pSubId);
HS_RESULT _h323_delete_HSTimerEvent(HSTimerEvent *pObj);
#define new_HSTimerEvent		_h323_new_HSTimerEvent
#define delete_HSTimerEvent		_h323_delete_HSTimerEvent



HS_RESULT _h323_HSSetTimer(HS_UINT pMilliSecond, HS_QUEUE_ID pQueueId, HS_TIMER_ID pTimerId, HS_UINT pSubId, TimerType pType);
HS_RESULT _h323_HSKillTimer(HS_TIMER_ID pTimerId, HS_UINT pSubId);
#define HSSetTimer		_h323_HSSetTimer
#define HSKillTimer		_h323_HSKillTimer



#endif/*__2005_03_13__10_30__WINTIMER_H__*/