'''
'''
#!/usr/bin/env python

import cgi
import Cookie, os
import time
import urllib
import urlparse
import traceback
import StringIO

import bbslib
import config
import memo
import session
import users
import userGroup
import exceptionLib
import mail
import emoticons
from templateProcessor import templateProcessor, getTemplate
from i18n import _
from logger import WebLogAnalyzer

version_info = (0, 7, 0)
version = '%s.%s.%s' % version_info
weblog = WebLogAnalyzer()

def run():
    try:
        form = cgi.FieldStorage()
        action = form.getvalue('action', 'showMainPage')
        user = authUser()
        actionFunc = globals()['do_'+action]
        ret = actionFunc(form, user)
        print 'Content-Type: text/html\r\n\r\n'
        print ret
    except exceptionLib.Redirect, msg:
        raise exceptionLib.Redirect, msg
    except KeyError, msg:
        print 'Content-Type: text/html\r\n\r\n'
        print errorTemplate('ERROR : ' + _('action is not defined') + ' :', action)
        return
    except Exception, msg:
        print 'Content-Type: text/html\r\n\r\n'
        print getErrorMessage()
        return

def authUser():
    c = Cookie.SimpleCookie()
    try:
        c.load(os.environ['HTTP_COOKIE'])
        sessionId = c['sid'].value
    except (Cookie.CookieError, KeyError), errMsg:
        config.errlogger.log(__name__, errMsg)
        sessionId = ''
    userSession = session.getSession(sessionId)
    if userSession == None:
        userId = 'anonymous'
        userSession = session.createSession(userId)
        userSession.printCookie()
        userSession['notReadMemoCount'] = 0
    else:
        userId = userSession['uid']
    user = users.getUser(userId)
    user.session = userSession
    # setting global variables
    globalNS = bbslib.getGlobalNS()
    globalNS['user'] = user
    globalNS['userId'] = user.uid
    globalNS['session'] = userSession
    globalNS['config'] = config
    globalNS['_'] = _
    globalNS['weblog'] = weblog
    globalNS['version'] = version
    user.lastLoginTimeMyself = userSession['lastLoginTimeMyself']
    envlist = 'REMOTE_ADDR HTTP_USER_AGENT HTTP_ACCEPT_CHARSET \
            HTTP_ACCEPT_LANGUAGE HTTP_HOST'.split()
    for name in envlist:
        if name in os.environ:
            globalNS[name] = os.environ[name]
    return user

def forumAdmission(forum, permission, user, article=None, topicStarter=''):
    permLevel = {'all':int(config.anonymousLevel), 'waiting':int(config.waitingLevel),
             'member':int(config.memberLevel), 'admin':int(config.adminLevel)}
    moderators = forum.moderator.split()
    if permission == 'moderator':
        if user.uid in moderators:
            return True
        else:
            return False
    if permission == 'private':
        if (article and article.uid == user.uid) or (user.uid in moderators) \
           or (user.level >= permLevel['admin']):
            return True
        else:
            return False
    if permission == 'topicStarter':
        if (topicStarter == user.uid) or (user.uid in moderators) \
           or (user.level >= permLevel['admin']):
            return True
        else:
            return False
    if permission == 'userGroup':
        return forum.isUserGroupMember(user) or user.level >= int(config.adminLevel)
    level = permLevel[permission]
    if user.level >= level or user.uid in moderators:
        return True
    return False

def errorTemplate(msg, errorMsg=''):
    msg = _(msg)
    template = getTemplate(os.path.join(config.skinPath, 'error.teul'))
    return templateProcessor(template, bbslib.getGlobalNS(), locals())

def getErrorMessage():
    s = StringIO.StringIO()
    traceback.print_exc(file=s)
    errMsg = s.getvalue()
    config.errlogger.log(__name__, errMsg)
    template = getTemplate('systemError.teul')
    msg = '''
    <table>
    <tr><td>
        <pre>%s</pre>
    </td></tr>
    </table>
    ''' % errMsg
    errorMsg = ''
    return templateProcessor(template, {}, locals())

#######################################
# basic user's operations
def do_showMainPage(form, user):
    user.log('do_showMainPage')
    globalNS = bbslib.getGlobalNS()
    groups = bbslib.getGroups()
    return groups.toHTML(html='index.teul')

def do_showGroups(form, user):
    user.log('do_showGroups')
    groups = bbslib.getGroups()
    return groups.toHTML(locals=locals())

def do_showForum(form, user):
    forumId = form.getvalue('forumId', '')
    curSortBy = form.getvalue('curSortBy', '').strip()
    curOrder = form.getvalue('curOrder', '')
    pageNo = int(form.getvalue('pageNo', '1'))
    groups = bbslib.getGroups()
    forum = groups.getForum(forumId)
    if forum == False:
        return errorTemplate('ERROR : ' + _('Wrong forumId'))
    if not forumAdmission(forum, forum.view, user):
        return do_login(form, user)
    if not curSortBy:
        curSortBy = forum.sortBy
    if not curOrder:
        curOrder = forum.order
    if forum.curSortBy != curSortBy or forum.curOrder != curOrder:
        forum.refresh(sortBy=curSortBy, order=curOrder)
    user.log('do_showForum', forumId)
    forum.pageNo = int(pageNo)
    forum.curSortBy = curSortBy
    forum.curOrder = curOrder
    return forum.toHTML()

def do_showThread(form, user): 
    forumId = form.getvalue('forumId', '')
    threadId = int(form.getvalue('threadId', '-1'))
    pageNo = int(form.getvalue('pageNo', 1))

    groups = bbslib.getGroups()
    forum = groups.getForum(forumId)
    if not forum: raise exceptionLib.RecordNotFound, forumId
    if forum == False:
        return errorTemplate('ERROR : ' + _('Wrong forumId'))
    else:
        curSortBy = form.getvalue('curSortBy', forum.sortBy) # FIXME sort - jangc
        curOrder = form.getvalue('curOrder', forum.order)    # FIXME sort
    try:
        if curOrder == 'asc':
            forum.sort(lambda lhs, rhs: cmp(getattr(lhs, curSortBy), getattr(rhs, curSortBy)))
        elif curOrder == 'desc':
            forum.sort(lambda lhs, rhs: cmp(getattr(rhs, curSortBy), getattr(lhs, curSortBy)))
        forum.setnPages()
    except Exception, errMsg:
        return getErrorMessage()
    pThreadId = forum.getPreviousThread(threadId)[0]
    nThreadId = forum.getNextThread(threadId)[0]

    thread = forum.getThreadById(threadId)
    thread.refresh()
    thread.incrReadCount()
    if not forumAdmission(forum, forum.read, user, topicStarter=thread.starter):
        return do_login(form, user)

    user.log('do_showThread', '%s %s' % (forumId, threadId))
    list = []
    thread.pThreadId = pThreadId
    thread.nThreadId = nThreadId
    thread.pageNo = pageNo   # CAUTION!
    thread.curOrder = curOrder    # FIXME sort 
    thread.curSortBy = curSortBy  # FIXME sort
    return thread.toHTML()

def do_download(form, user):
    forumId = form.getvalue('forumId', '')
    articleId = int(form.getvalue('articleId', '-1'))
    groups = bbslib.getGroups()
    forum = groups.getForum(forumId)
    if not forumAdmission(forum, forum.read, user):
        return do_login(form, user)
    article = bbslib.readArticle(forumId, articleId)
    article.incrDownCount(forumId)
    user.log('do_download', '%s %s "%s"' % (forumId, articleId, article.upload1))
    redirect(article.upload1)

def do_showUserProfile(form, user):
    if user.uid == 'anonymous':
        return do_login(form, user)
    uid = form.getvalue('uid', '')
    if uid == 'anonymous':
        return errorTemplate(_('anonymous is a not registered user'))
    user.log('do_showUserProfile', uid)
    if user.uid == uid:
        return user.toHTML('userShowMyself.teul')
    otherUser = users.getUser(uid)
    if otherUser:
        return otherUser.toHTML()
    return errorTemplate("ERROR : " + _('no such user')+" %s" % uid)

def do_showMemberList(form, user):
    if user.uid == 'anonymous':
        return do_login(form, user)
    by = form.getvalue('by', 'registeredTime').strip()
    order = form.getvalue('order', 'desc').strip()
    pageNo = int(form.getvalue('pageNo', '1'))
    search = form.getvalue('search', '')
    keyword = form.getvalue('keyword', '')
    user.log('do_showMemberList', '%s %s %s %s %s' % (by, order, pageNo, search, keyword))
    userList = users.getUserList(page=pageNo, sortBy=by, order=order, search=search, keyword=keyword)
    template = getTemplate(os.path.join(config.skinPath, 'memberList.teul'))
    return templateProcessor(template, bbslib.getGlobalNS(), locals())

def do_newThread(form, user):
    '''Posting new thread'''
    forumId = form.getvalue('forumId', '')
    subject = form.getvalue('subject', '')
    body = form.getvalue('body', '')
    articleId = form.getvalue('articleId', -1)
    htmltag = form.getvalue('htmltag', 0)
    emoticon = form.getvalue('emoticon', 0)
    bbcode = form.getvalue('bbcode', 1)
    notify = form.getvalue('notify', 0)
    type = form.getvalue('type', bbslib.DISCUSSION)
    type = int(type)

    try:
        fileName = form['file'].filename
        fileStr = form['file'].value
    except:
        fileName = ''
        fileStr = ''
    groups = bbslib.getGroups()
    forum = groups.getForum(forumId)

    if not isinstance(forum, bbslib.Forum):
        return errorTemplate('ERROR : ' + _('Invalid access.'))
    if forum.lock == 'locked':
        return errorTemplate('ERROR : ' + _('This forum is locked'))
    if not (subject.strip() and body.strip()):
        if not forumAdmission(forum, forum.post, user):
            return do_login(form, user)
        action = 'newThread'
        subject = ''
        body = ''
        emoticonPanel = emoticons.emoticonPanel()
        upload1 = ''
        if user.level >= int(config.adminLevel):
            notice = True
        else:
            notice = False
        return forum.toHTML('newThread.teul', locals=locals())

    if not forumAdmission(forum, forum.post, user):
        return errorTemplate('ERROR : ' + _('Session expired. Login and try again'))
    subject = bbslib.strCutter(subject, config.subjectLength - 5)
    article = bbslib.Article(None, uid=user.uid, htmltag=htmltag,
                             emoticon=emoticon, bbcode=bbcode, notify=notify, subject=subject, body=body)
    try:
        threadId = bbslib.writeThread(forumId, article, fileName=fileName, fileStr=fileStr, type=type)
    except SyntaxError, msg:
        return errorTemplate('Not well formed document : ', msg)
    except Exception, msg:
        return getErrorMessage()
    thread = forum.getThreadById(threadId)
    user.log('do_newThread', '%s %s' % (forumId, threadId))
    redirectPath = 'pybbs.py?action=showThread&forumId=%s&threadId=%s' % (forumId, threadId)
    redirect(redirectPath)

def do_deleteArticle(form, user):
    forumId = form.getvalue('forumId', '')
    threadId = int(form.getvalue('threadId', '-1'))
    articleId = int(form.getvalue('articleId', ''))
    confirm = form.getvalue('confirm', '')
    pageNo = int(form.getvalue('pageNo', 1))
    curSortBy = form.getvalue('curSortBy', '')
    curOrder = form.getvalue('curOrder', '')
    
    groups = bbslib.getGroups()
    forum = groups.getForum(forumId)
    if not isinstance(forum, bbslib.Forum):
        return errorTemplate('ERROR : ' + _('Invalid access.') + '(forumId' + _(' is not found') + ')', forumId)

    if forum.lock == 'locked':
        return errorTemplate('ERROR : ' + _('This forum is locked'))
    thread = forum.getThreadById(threadId)
    if not isinstance(thread, bbslib.Thread):
        return errorTemplate('ERROR : ' + _('Invalid access.') + '(threadId' + _(' is not found') + ')', threadId)
    thread.refresh()
    article = thread.getArticleById(articleId)
    if not isinstance(article, bbslib.Article):
        return errorTemplate('ERROR : ' + _('Invalid access.') + '(articleId' + _(' is not found') + ')', articleId)
    if not forumAdmission(forum, forum.delete, user, article):
        return do_login(form, user)
    if confirm == 'ok':
        article = bbslib.readArticle(forumId, articleId)
        if article.offset == 0:
            idList = bbslib.deleteThread(forumId, threadId)
            user.log('do_deleteThread', '%s %s' % (forumId, threadId))
            for articleId in idList:
                user.log('deleteArticle', '%s %s %s' % (forumId, threadId, articleId))
            redirectPath = 'pybbs.py?action=showForum&forumId=%s&curSortBy=%s&curOrder=%s&pageNo=%s' % \
                           (forumId, curSortBy, curOrder, pageNo)
            redirect(redirectPath)
        else:
            bbslib.deleteArticle(forumId, articleId, user.uid)
            user.log('do_deleteArticle', '%s %s %s' % (forumId, threadId, articleId))
        redirectPath = 'pybbs.py?action=showThread&forumId=%s&threadId=%s&curSortBy=%s&curOrder=%s' % \
                       (forumId, threadId, curSortBy, curOrder)
        redirect(redirectPath)

def do_editArticle(form, user):
    forumId = form.getvalue('forumId', '')
    subject = form.getvalue('subject', '')
    body = form.getvalue('body', '')
    threadId = int(form.getvalue('threadId', '-1'))
    articleId = int(form.getvalue('articleId', '-1'))
    remove = form.getvalue('removeUploadedFile','none')
    htmltag = int(form.getvalue('htmltag', 0))
    emoticon = int(form.getvalue('emoticon', 0))
    bbcode = int(form.getvalue('bbcode', 0))
    notify = int(form.getvalue('notify', 0))
    type = int(form.getvalue('type', 0))
    pageNo = int(form.getvalue('pageNo', 1))

    try:
        fileName = form['file'].filename
        fileStr = form['file'].value
    except:
        fileName = ''
        fileStr = ''

    globalNS = bbslib.getGlobalNS()
    globalNS['action'] = 'editArticle'
    groups = bbslib.getGroups()
    forum = groups.getForum(forumId)

    if forum.lock == 'locked':
        return errorTemplate('ERROR : ' + _('This forum is locked'))
    if not isinstance(forum, bbslib.Forum):
        return errorTemplate('ERROR : ' + _('Invalid access.') + '(forumId' + _(' is not found') + ')', forumId)
    thread = forum.getThreadById(threadId)
    if not isinstance(thread, bbslib.Thread):
        return errorTemplate('ERROR : ' + _('Invalid access.') + '(threadId' + _(' is not found') + ')', threadId)
    thread.refresh()
    article = thread.getArticleById(articleId)
    if not isinstance(article, bbslib.Article):
        return errorTemplate('ERROR : ' + _('Invalid access.') + '(articleId' + _(' is not found') + ')', articleId)


    globalNS['emoticonPanel'] = emoticons.emoticonPanel() # module variable
    globalNS['threadId'] = threadId
    globalNS['articleId'] = articleId

    if not (subject.strip() and body.strip()):
        if not forumAdmission(forum, forum.edit, user, article):
            return do_login(form, user)
        subject = article.subject
        body = bbslib.escapeTextForm(article.body)
        upload1 = os.path.split(article.upload1)[1]
        htmltag = article.htmltag
        emoticon = article.emoticon
        bbcode = article.bbcode
        notify = article.notify
        type = thread.type
        if article.offset == 0 and user.level >= int(config.adminLevel):
            notice = True   # show notice tag
        else:
            notice = False
        html = forum.toHTML('newThread.teul', locals=locals())
        return html

    if not forumAdmission(forum, forum.edit, user, article):
        return errorTemplate('ERROR : ' + _('Session expired. Login and try again'))
        
    article.subject = bbslib.strCutter(subject, config.subjectLength - 5)
    article.body = body
    article.htmltag = htmltag
    article.emoticon = emoticon
    article.bbcode = bbcode
    article.notify = notify
    if article.offset == 0:
        thread.changeType(type)
    try:        
        bbslib.editArticle(forumId, articleId, article, user.uid, fileName, fileStr, remove == 'remove')
        m = mail.Mail()
        mSubject = _('article edited') + (' : %s' % subject)
        mBody = '''The thread you askded to notify has been edited. Visit the link.
        URL : %s
        subject : %s
        body : %s
        --------------------
        PyBB''' % ('http://%s:%s/pybbs.py?action=showThread&forumId=%s&threadId=%s' % (config.HOST_URL, config.HTTP_PORT, forumId, threadId), subject, body)
        uidList = thread.getUserListToBeNotified()
        user.uid in uidList and uidList.remove(user.uid)
        emailList = [users.getUser(uid).email.strip() for uid in uidList]
        emailList = filter(None, emailList)
        m.send(config.webmaster, emailList, mSubject, mBody)
    except mail.SendMailError, msg:
        config.errlogger.log('bbsmain:do_editArticle', 'send mail error')
    except SyntaxError, msg:
        return errorTemplate('Not well formed document : ',msg)
    except Exception, msg:
        return getErrorMessage()
    user.log('do_editArticle', '%s %s %s' % (forumId, threadId, articleId))
    redirectPath = 'pybbs.py?action=showThread&forumId=%s&threadId=%s&pageNo=%s' % (forumId, threadId, pageNo)
    redirect(redirectPath)

def do_reply(form, user):
    forumId = form.getvalue('forumId', '')
    subject = form.getvalue('subject', '')
    body = form.getvalue('body', '')
    threadId = int(form.getvalue('threadId', '-1'))
    articleId = int(form.getvalue('articleId', '-1'))
    htmltag = form.getvalue('htmltag', 0)
    emoticon = form.getvalue('emoticon', 0)
    bbcode = form.getvalue('bbcode', 0)
    notify = form.getvalue('notify', 0)
    try:
        fileName = form['file'].filename
        fileStr = form['file'].value
    except:
        fileName = ''
        fileStr = ''

    globalNS = bbslib.getGlobalNS()
    globalNS['action'] = 'reply'
    globalNS['emoticonPanel'] = emoticons.emoticonPanel()
    groups = bbslib.getGroups()
    forum = groups.getForum(forumId)
    if forum.lock == 'locked':
        return errorTemplate('ERROR : ' + _('This forum is locked'))
    if not isinstance(forum, bbslib.Forum):
        return errorTemplate('ERROR : ' + _('Invalid access.') + '(forumId' + _(' is not found') + ')', forumId)
    thread = forum.getThreadById(threadId)
    thread.refresh()
    if not isinstance(thread, bbslib.Thread):
        return errorTemplate('ERROR : ' + _('Invalid access.') + '(threadId' + _(' is not found') + ')', threadId)

    if not (subject.strip() and body.strip()):
        if not forumAdmission(forum, forum.reply, user, topicStarter=thread.starter):
            return do_login(form, user)
        article = thread.getArticleById(articleId)
        if not isinstance(article, bbslib.Article): # Post reply
            htmltag = 0
            emoticon = 0
            bbcode = 1
            notify = 0
            subject = 'Re: ' + thread.subject
            body = ''
        else:       # article reply
            htmltag = article.htmltag
            emoticon = article.emoticon
            bbcode = article.bbcode
            notify = 0#notify = article.notify
            subject = article.subject
            body = bbslib.escapeTextForm(article.body)
            subject = 'Re: ' + subject
            body = '[quote]' + body + '[/quote]'
        upload1 = ''
        notice = False
        return forum.toHTML('newThread.teul', locals=locals())

    if not forumAdmission(forum, forum.reply, user, topicStarter=thread.starter):
        return errorTemplate('ERROR : ' + _('Session expired. Login and try again'))
    subject = bbslib.strCutter(subject, config.subjectLength - 5)    
    article = bbslib.Article(None, uid=user.uid, htmltag=htmltag, emoticon=emoticon,
                             bbcode=bbcode, notify=notify, subject=subject, body=body)
    try:
        offset, newArticleId = bbslib.replyArticle(forumId, article, threadId=threadId,
                                 fileName=fileName, fileStr=fileStr)
        m = mail.Mail()
        mSubject = _('article replied') + (' : %s' % subject)
        mBody = '''The thread you askded to notify has been REPLIED. Visit the link.
        URL : %s
        subject : %s
        body : %s
        --------------------
        PyBB''' % ('http://%s:%s/pybbs.py?action=showThread&forumId=%s&threadId=%s' % (config.HOST_URL, config.HTTP_PORT, forumId, threadId), subject, body)
        uidList = thread.getUserListToBeNotified()
        user.uid in uidList and uidList.remove(user.uid)            
        emailList = [users.getUser(uid).email.strip() for uid in uidList]
        emailList = filter(None, emailList)
        m.send(config.webmaster, emailList, mSubject, mBody)
    except mail.SendMailError, msg:
        config.errlogger.log('bbsmain:do_reply', 'send mail error')
    except SyntaxError, msg:
        return errorTemplate('Not well formed document : ',msg)
    except Exception, msg:
        return getErrorMessage()
    user.log('do_reply', '%s %s %s %s' % (forumId, threadId, articleId, newArticleId))
    from math import ceil
    firstArticle = 1
    pageNo = int(ceil((firstArticle+thread.replies) / float(config.numberOfArticlesInAPage))) # FIXME
    redirectPath = 'pybbs.py?action=showThread&forumId=%s&threadId=%s&pageNo=%s' % (forumId, threadId, pageNo)
    redirect(redirectPath)


#######################################
# administrator's operations
def do_adminPage(form, user):
    '''Administrator's main page'''
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    user.log('do_adminPage')
    globalNS = bbslib.getGlobalNS()
    template = getTemplate(os.path.join(config.skinPath, 'admin.teul'))
    return templateProcessor(template, globalNS)

def do_adminForumManager(form, user):
    '''Administrator's forum management Page'''
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    user.log('do_adminForumManager')
    reload(config)
    groups = bbslib.getGroups()
    return groups.toHTML('groupsManage.teul')

def do_addCategory(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    groups = bbslib.getGroups()
    categoryName = form.getvalue('categoryName', '')
    user.log('do_addCategory', categoryName)
    if categoryName and isinstance(groups.addCategory(categoryName), bbslib.Category):
        redirectPath = 'pybbs.py?action=adminForumManager'
        redirect(redirectPath)
    else:
        return groups.toHTML('addCategory.teul')

def do_changeCategoryName(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    groups = bbslib.getGroups()
    categoryName = urllib.unquote(form.getvalue('categoryName', ''))
    oldCategoryName = form.getvalue('oldCategoryName', '')
    user.log('do_changeCategoryName', '%s -> %s' % (oldCategoryName, categoryName))
    newCategoryName = form.getvalue('newCategoryName', '')
    if oldCategoryName and newCategoryName and groups.changeCategoryName(oldCategoryName, newCategoryName):
        redirectPath = 'pybbs.py?action=adminForumManager'
        redirect(redirectPath)
    else:
        globalNS = bbslib.getGlobalNS()
        globalNS['categoryName'] = categoryName
        return groups.toHTML('changeCategoryName.teul')

def do_deleteCategory(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    categoryName = urllib.unquote(form.getvalue('categoryName', ''))
    user.log('do_deleteCategory', categoryName)
    groups = bbslib.getGroups()
    if not groups.deleteCategory(categoryName):
        return errorTemplate('ERROR : ' + _('category name is not defined') + ' :', categoryName)
    redirectPath = 'pybbs.py?action=adminForumManager'
    redirect(redirectPath)

def do_moveUpCategory(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    categoryName = urllib.unquote(form.getvalue('categoryName', ''))
    groups = bbslib.getGroups()
    groups.moveUpCategory(categoryName)
    user.log('do_moveUpCategory', categoryName)
    redirectPath = 'pybbs.py?action=adminForumManager'
    redirect(redirectPath)

def do_moveDownCategory(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    categoryName = urllib.unquote(form.getvalue('categoryName', ''))
    groups = bbslib.getGroups()
    groups.moveDownCategory(categoryName)
    user.log('do_moveDownCategory', categoryName)
    redirectPath = 'pybbs.py?action=adminForumManager'
    redirect(redirectPath)

def do_editForum(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    forumId = form.getvalue('forumId', '')
    forumName = form.getvalue('forumName', '')
    forumDesc = form.getvalue('forumDesc', '')
    lock = form.getvalue('lock', '')
    moderator = form.getvalue('moderator', '')
    view = form.getvalue('view', '')
    read = form.getvalue('read', '')
    post = form.getvalue('post', '')
    reply = form.getvalue('reply', '')
    edit = form.getvalue('edit', '')
    delete = form.getvalue('delete', '')
    sortBy = form.getvalue('sortBy', 'mdate')
    order = form.getvalue('order', 'desc')
    userGroupList = form.getvalue('userGroupList', '').split()
    registeredUserGroupList = userGroup.getUserGroupList()
    L = []
    for userGroupName in userGroupList:
        if userGroupName not in registeredUserGroupList:
            L.append(userGroupName)
    if L:
        return errorTemplate('ERROR : ', 'Not registered user group (%s)' % (' '.join(L)))
    groups = bbslib.getGroups()
    forum = groups.getForum(forumId)

    for id in moderator.split():
        mod = users.getUser(id)
        if not mod:
            return errorTemplate('ERROR : ', _('Invalid user id') + ' - ' + id)
        if mod.level < int(config.memberLevel):
            return errorTemplate('ERROR : ', _('This member has not enough level to be a moderator') + ' - ' + id)
    if forumId and forumName and lock and view \
       and read and post and reply and edit and delete and sortBy and order:
        forum.getParent().editForum(forumId, forumName, forumDesc, lock, moderator,
                                    view, read, post, reply, edit, delete, sortBy, order, userGroupList)
        user.log('do_editForum', forumId)
        redirectPath = 'pybbs.py?action=adminForumManager'
        redirect(redirectPath)
    else:
        return forum.toHTML('editForum.teul', locals={'registeredUserGroupList':registeredUserGroupList})


def do_addForum(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    categoryName = form.getvalue('categoryName', '')
    forumName = form.getvalue('forumName', '')
    forumDesc = form.getvalue('forumDesc', '')
    lock = form.getvalue('lock', '')
    moderator = form.getvalue('moderator', '')
    view = form.getvalue('view', '')
    read = form.getvalue('read', '')
    post = form.getvalue('post', '')
    reply = form.getvalue('reply', '')
    edit = form.getvalue('edit', '')
    delete = form.getvalue('delete', '')
    sortBy = form.getvalue('sortBy', 'mdate')
    order = form.getvalue('order', 'desc')
    userGroupList = form.getvalue('userGroupList', '').split()
    groups = bbslib.getGroups()
    category = groups.getCategoryByName(categoryName)

    registeredUserGroupList = userGroup.getUserGroupList()
    L = []
    for userGroupName in userGroupList:
        if userGroupName not in registeredUserGroupList:
            L.append(userGroupName)
    if L:
        return errorTemplate('ERROR : ', 'Not registered user group (%s)' % (' '.join(L)))

    for id in moderator.split():
        mod = users.getUser(id)
        if not mod:
            return errorTemplate('ERROR : ' + _('Invalid user id') + ' - ' + id)
        if mod.level < int(config.memberLevel):
            return errorTemplate('ERROR : ' + _('This member has not enough level to be a moderator') + ' - ' + id)
    if forumName and lock:
        category.addForum(forumName, forumDesc, lock, moderator, view, read, post, reply, edit, delete, sortBy, order, userGroupList)
        user.log('do_addForum', forumName)
        redirectPath = 'pybbs.py?action=adminForumManager'
        redirect(redirectPath)
    else:
        return category.toHTML('addForum.teul', locals={'registeredUserGroupList':registeredUserGroupList})

def do_deleteForum(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    forumId = form.getvalue('forumId', '')
    groups = bbslib.getGroups()
    forum = groups.getForum(forumId)
    confirm = form.getvalue('confirm', '')

    if confirm == 'ok':
        forum.getParent().deleteForumById(forumId)
        user.log('do_deleteForum', forumId)
        groups.refresh()
    redirectPath = 'pybbs.py?action=adminForumManager'
    redirect(redirectPath)

def do_moveUpForum(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    forumId = form.getvalue('forumId', '')
    groups = bbslib.getGroups()
    forum = groups.getForum(forumId)
    forum.getParent().moveUpForum(forumId)
    user.log('do_moveUpForum', forumId)
    redirectPath = 'pybbs.py?action=adminForumManager'
    redirect(redirectPath)

def do_moveDownForum(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    forumId = form.getvalue('forumId', '')
    groups = bbslib.getGroups()
    forum = groups.getForum(forumId)
    forum.getParent().moveDownForum(forumId)
    user.log('do_moveDownForum', forumId)
    redirectPath = 'pybbs.py?action=adminForumManager'
    redirect(redirectPath)

def do_adminUserManager(form, user):
    '''user level change'''
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    try:
        permLevel = {'all':-1, 'waiting':int(config.waitingLevel),
             'member':int(config.memberLevel), 'admin':int(config.adminLevel)}
        userLevel = form.getvalue('userLevel', 'all')
        userLevel = permLevel.get(userLevel, 99)
        level = int(form.getvalue('level', userLevel))
        for key in form.keys():
            if key.startswith('user'):
                uid = form.getvalue(key, '')
                if uid and key.endswith(uid):
                    changeUser = users.getUser(uid)
                    orgLevel = changeUser.level
                    changeUser.changeLevel(level)
                    changeUser.log('LevelChange', 'from %s to %s' % (orgLevel, level))
                    if orgLevel == int(config.waitingLevel) and level == int(config.memberLevel):
                        try:
                            m = mail.Mail()
                            subject = _('Membership approved')
                            body = '''Congratulations!
                            You have given a membership to our community.
                            '''
                            m.send(config.webmaster, changeUser.email, subject, body)
                        except:
                            config.errlogger.log(__name__, 'failed to send an email to %s(%s)' % (changeUser.uid, changeUser.email))

    except Exception, errMsg:
        return getErrorMessage()

    by = form.getvalue('by', 'uid')
    order = form.getvalue('order', 'desc')
    pageNo = int(form.getvalue('pageNo', '1'))
    search = form.getvalue('search', '')
    keyword = form.getvalue('keyword', '')
    user.log('do_adminUserManager', '%s %s %s %s %s' % (by, order, pageNo, search, keyword))
    userList = users.getUserList(userLevel=userLevel, page=pageNo, sortBy=by, order=order, search=search, keyword=keyword)

    globalNS = bbslib.getGlobalNS()
    template = getTemplate(os.path.join(config.skinPath, 'adminUserManager.teul'))
    return templateProcessor(template, globalNS, locals())

#######################################
# emoticon operations
def do_emoticonManager(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    user.log('do_emoticonManager')
    emo = emoticons.Emoticons()
    return emo.toHTML()

def do_emoticonRegister(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    code = form.getvalue('code', '')
    fileName = form.getvalue('fileName', '')
    if code.count('<:') or code.count(':>'):
        return errorTemplate('ERROR : ' + _("this code can't use"))
    emo = emoticons.Emoticons()
    if code and fileName:
        emo.register(code, fileName)
    user.log('do_emoticonRegister', '%s %s' % (code, fileName))
    redirectPath = 'pybbs.py?action=emoticonManager'
    redirect(redirectPath)

def do_emoticonDelete(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    id = form.getvalue('id', '')
    emo = emoticons.Emoticons()
    if id:
        emo.remove(id)
    user.log('do_emoticonDelete', '%s' % id)
    redirectPath = 'pybbs.py?action=emoticonManager'
    redirect(redirectPath)

def do_emoticonEdit(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    id = form.getvalue('id', '')
    code = form.getvalue('code', '')
    fileName = form.getvalue('fileName', '')
    emo = emoticons.Emoticons()
    if id and code and fileName:
        emo.edit(id, code, fileName)
    elif id:
        emo.mode = id
    user.log('do_emoticonEdit', '%s %s %s' % (id, code, fileName))
    return emo.toHTML()

#######################################
# Configuration operations
def do_configManager(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    submit = form.getvalue('submit', '')
    globalNS = bbslib.getGlobalNS()
    if not submit:
        return config.conf.toHTML(globalNS)
    else:
        for section in config.conf.sections:
            for option, value in config.conf.sections[section].items():
                if option != '__name__':
                    value = form.getvalue(option, value)
                    config.conf.updateOne(section, option, value)
        reload(config)
        d = config.__dict__
        for key, value in d.items():
            globalNS[key] = value
        users.changeUsersLevel('adminLevel', int(config.adminLevel))
        users.changeUsersLevel('memberLevel', int(config.memberLevel))
        users.changeUsersLevel('waitingLevel', int(config.waitingLevel))
        users.changeUsersLevel('anonymousLevel', int(config.anonymousLevel))
        groups = bbslib.getGroups()
        groups.refresh()
        user.log('do_configManager')
        redirectPath = 'pybbs.py?action=configManager'
        redirect(redirectPath)


#######################################
# personal operations
def do_showMemoBox(form, user):
    if user.level < int(config.waitingLevel):
        return do_login(form, user)
    memobox = memo.MemoBox(user.uid, user.session['sent'], form.getvalue('order','desc'))
    memobox.refresh()
    user.session['notReadMemoCount'] = memobox.getNotReadMemoCount() 
    sortType = form.getvalue('sort',user.session['memosort'])
    try:
        exec('memobox.sort%s()' % (sortType))
        user.session['memosort'] = sortType
    except:
        memobox.sortSendDate()
        user.session['memosort'] = 'SendDate'
    user.log('do_showMemoBox')
    order = form.getvalue('order','desc')
    return memobox.toHTML(locals={'order':order, 'by':sortType})

def do_showSentMemoBox(form, user):
    if user.level < int(config.waitingLevel):
        return do_login(form, user)
    user.log('do_showSentMemoBox')
    user.session['sent'] = True
    return do_showMemoBox(form, user)

def do_showReceivedMemoBox(form, user):
    if user.level < int(config.waitingLevel):
        return do_login(form, user)
    user.log('do_showReceivedMemoBox')
    user.session['sent'] = False
    return do_showMemoBox(form, user)

def do_showMemo(form, user):
    if user.level < int(config.waitingLevel):
        return do_login(form, user)
    try:
        memoid = int(form.getvalue('memoid',''))
        rmemo = memo.readMemo(user.uid, memoid)
    except:
        rmemo = False
    if rmemo:
        if rmemo.checkRead(user.uid):
            user.session['notReadMemoCount'] -= 1
        user.log('do_showMemo', memoid)
        return rmemo.toHTML()
    else:
        return do_showMemoBox(form, user)

def do_sendMemo(form, user):
    if user.level < int(config.memberLevel):
        return do_login(form, user)
    toId = form.getvalue('toId', '')
    subject = form.getvalue('subject', '')
    body = form.getvalue('body', '')
    fromId = user.uid

    if not (subject.strip() and body.strip()):
        action = 'sendMemo'
        errorMsg = ''
        memoid = -1
        wmemo = memo.Memo(fromId=user.uid, toId=toId, subject=subject, body=body)
        return wmemo.toHTML('sendMemo.teul', locals())

    sendMailErrorUserList = []
    sendMailOpenError = False
    invalidUserList = []
    for receiverId in toId.split():
        try:
            if receiverId == 'anonymous':
                invalidUserList.append(receiverId)
                continue
            sendMemoToAUser(sender=user, receiverUid=receiverId, subject=subject, body=body, sendMail=not sendMailOpenError)
        except users.InvalidUser, msg:
            invalidUserList.append(receiverId)
        except mail.SMTPError, msg:
            sendMailOpenError = True
        except mail.SendMailFailed, msg:
            sendMailErrorUserList.append(receiverId)
    errMsg = ''
    if invalidUserList:
        errMsg += _('Invalid user')+'-' + (' '.join(invalidUserList)) + '\n'
    if sendMailOpenError:
        errMsg += _('the memo has been sent but email notification has not sent. check your SMTP server.') + '\n'
    if sendMailErrorUserList:
        errMsg += _('the memo has been sent but email notification has not sent to the following users.') + ':'+' '.join(sendMailErrorUserList) + '\n'
    if errMsg:
        return errorTemplate('WARNING', errMsg)
    redirectPath = 'pybbs.py?action=showMemoBox'
    redirect(redirectPath)

def sendMemoToAUser(sender, receiverUid, subject, body, sendMail):
    sender.log('do_sendMemo', '%s %s' % (receiverUid, subject))
    wmemo = memo.Memo(fromId=sender.uid, toId=receiverUid, subject=subject, body=body)
    memoId = wmemo.send()
    receiver = users.getUser(receiverUid)
    if receiver.memoEmailNotice and sendMail:
        m = mail.Mail()
        subject = _('You\'ve got memo from') + ' %s'%(sender.uid)
        body = _('You have a new memo. Click the following link.') + 'http://%s:%s/pybbs.py?action=showMemo&memoid=%s' % (
            config.HOST_URL,
            config.HTTP_PORT,
            memoId)
        m.send(config.webmaster, receiver.email, subject, body)


def do_replyMemo(form, user):
    if user.level < int(config.memberLevel):
        return do_login(form, user)
    memoid = int(form.getvalue('memoid', ''))
    subject = form.getvalue('subject', '')
    body = form.getvalue('body', '')
    rmemo = memo.readMemo(user.uid, memoid)
    toId = rmemo.fromId
    globalNS = bbslib.getGlobalNS()
    globalNS['action'] = 'replyMemo'
    globalNS['memoid'] = memoid
    if not (subject.strip() and body.strip()):
        if rmemo.checkRead(user.uid):
            user.session['notReadMemoCount'] -= 1
        subject = 'Re: ' + rmemo.subject
        body = '[quote]' + bbslib.escapeTextForm(rmemo.body) + '[/quote]'
        wmemo = memo.Memo(fromId=user.uid, toId=toId, subject=subject, body=body)
        return wmemo.toHTML('sendMemo.teul')
    wmemo = memo.Memo(fromId=user.uid, toId=toId, subject=subject, body=body)
    wmemo.send()
    user.log('do_replyMemo', memoid)
    redirectPath = 'pybbs.py?action=showMemoBox'
    redirect(redirectPath)

def do_deleteMemo(form, user):
    if user.level < int(config.waitingLevel):
        return do_login(form, user)
    memoid = form.getvalue('memoid', '')
    confirm = form.getvalue('confirm', '')
    globalNS = bbslib.getGlobalNS()
    globalNS['memoid'] = memoid
    if confirm == 'ok':
        if memo.readMemo(user.uid, memoid).checkRead(user.uid):
            user.session['notReadMemoCount'] -= 1
        memo.deleteMemo(memoid, user.uid, user.session['sent'])
        user.log('do_deleteMemo', memoid)
        return do_showMemoBox(form, user)
    return do_showMemo(form, user)

#######################################
# login & logout
def makeRedirectString(form):
    L = ['%s=%s' % (key, form[key].value) for key in form.keys()]
    return 'pybbs.py?'+'&'.join(L)

def do_login(form, user):
    globalNS = bbslib.getGlobalNS()
    uid = form.getvalue('userID', '')
    passwd = form.getvalue('passwd', '')
    action = form.getvalue('action', '')
    redirectPath = form.getvalue('redirect', 'pybbs.py')
    if not (uid or passwd):
        redirectPath = makeRedirectString(form)
        if action != 'login':
            message = _('You need to login to proceed')
        else:
            message = _('Please enter your username and password to log in')
        template = getTemplate(os.path.join(config.skinPath, 'login.teul'))
        return templateProcessor(template, globalNS, locals())
    user = users.isValidUser(uid, passwd)
    if user and user.level > int(config.waitingLevel):
        login(user)
        if redirectPath.find('action=login') >= 0:
            redirect('pybbs.py')
        redirect(redirectPath)
    elif user:
        if user.level == int(config.waitingLevel):
            message = _("You are waiting for approval. Try it later")
        if user.level == int(config.anonymousLevel):
            message = _("You are not a member of this community, anymore.")
    else:
        message = _('ERROR : ' + _('login failed. Try again'))
    template = getTemplate(os.path.join(config.skinPath, 'login.teul'))
    del user
    return templateProcessor(template, globalNS, locals())

def login(user):
    sess = session.createSession(user.uid)
    sess.printCookie()
    memobox = memo.MemoBox(user.uid)
    sess['notReadMemoCount'] = memobox.getNotReadMemoCount()
    sess['lastLoginTimeMyself'] = user.getLastLoginTime() #To get previous login time
    user.getLoginCount()
    user.updateLoginInfo()
    globalNS = bbslib.getGlobalNS()
    globalNS['user'] = user
    globalNS['userId'] = user.uid
    
def do_logout(form, user):
    user.session.removeSelf()
    user.log('do_logout')
    redirect('pybbs.py')


def do_lostPasswd(form, user):
    userId = form.getvalue('userId', '')
    email = form.getvalue('email', '')
    globalNS = bbslib.getGlobalNS()
    if not (userId and email):
        template = getTemplate(os.path.join(config.skinPath, 'lostPassword.teul'))
        html = templateProcessor(template, globalNS, locals())
        return html
    user = users.getUser(userId)
    if not user or user.email != email:
        return errorTemplate('ERROR : ' + _('Invalid userId or email'))
    # make new password
    import random
    catalyst = str(random.randrange(10000))
    newPasswd = users.encryptPasswd(catalyst)[:8]
    # change password
    user.passwd = users.encryptPasswd(newPasswd)
    # email notification
    import mail
    subject = '%s : %s' % (config.siteName, _('changed password notification'))
    try:
        m = mail.Mail()
        template = getTemplate(os.path.join(config.skinPath, 'lostEmailNotification.temp'))
        html = templateProcessor(template, globalNS, locals())
        m.send(config.webmaster, user.email, subject, html)
        user.log('do_lostPasswd', '%s %s' % (userId, email))
        return errorTemplate('changed password has been emailed to you')
    except:
        return errorTemplate('ERROR : ' + _('failed to send an email. contact to the webmaster'))

def redirect(url):
    raise exceptionLib.Redirect, url

#######################################
# user operation
def do_joinMembership(form, user):
    globalNS = bbslib.getGlobalNS()
    user.log('do_joinMembership')
    template = getTemplate(os.path.join(config.skinPath, 'userRegisterForm.teul'))
    return templateProcessor(template, globalNS, locals())

def do_registerUser(form, user):
    uid = form.getvalue('uid', '').strip()
    name = form.getvalue('name', '').strip()
    if name == '':
        name = uid
    email = form.getvalue('email', '').strip()
    passwd = form.getvalue('passwd', '').strip()
    passwdConfirm = form.getvalue('passwdConfirm', '').strip()
    if not (uid and email and passwd and passwdConfirm):
        return errorTemplate('Items marked with a * are required unless stated otherwise.')
    if uid == 'anonymous':
        return errorTemplate('ERROR : ' + _("You does not use 'anonymous'."))
    sc = ["\r", '\n', ' ', '/', '\\', "`", "'", '~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '-', '+', '=', '|', ',', '.', '<', '>', '?', ':', ';', '"']
    for ch in uid:
        if ch in sc:
            return errorTemplate('ERROR : ' + _('You does not use specific character.'))

    if passwd != passwdConfirm:
        return errorTemplate('ERROR : ' + _('Your new password entries did not match.'))

    mType1 = form.getvalue('mType1', '')
    mId1 = form.getvalue('mId1', '')
    mType2 = form.getvalue('mType2', '')
    mId2 = form.getvalue('mId2', '')
    icq = form.getvalue('icq', '')
    msn = form.getvalue('msn', '')
    homepage = form.getvalue('homepage', '')
    location = form.getvalue('location', '')
    occupation = form.getvalue('occupation', '')
    interests = form.getvalue('interests', '')
    signature = form.getvalue('signature', '')
    viewOnline = form.getvalue('viewOnline', '')
    threadEmailNotice = form.getvalue('threadEmailNotice', '')
    memoEmailNotice = form.getvalue('memoEmailNotice', '')

    userMembershipApprovalRequired = config.userMembershipApprovalRequired in ('True', 'true', True, 1, '1')
    if userMembershipApprovalRequired:
        level = int(config.waitingLevel)
    else:
        level = int(config.memberLevel)

    user = users.User(uid, name, email, passwd, level, mType1, mId1, mType2, mId2,
                      homepage, location, occupation, interests,
                      signature, viewOnline,
                      threadEmailNotice, memoEmailNotice)
    if not user.register():
        return errorTemplate('ERROR : ' + _('Someone else has already chosen ID. Please try another ID.'))
    if userMembershipApprovalRequired:
        subject = _('new user is waiting for the membership approval') + ('(%s)' % user.uid)
        body = 'http://%s:%s/pybbs.py?action=adminUserManager&userLevel=waiting' % (
            config.HOST_URL, config.HTTP_PORT)
        adminList = users.getUserList(int(config.adminLevel))
        for admin in adminList:
            wmemo = memo.Memo(fromId=user.uid, toId=admin.uid, subject=subject, body=body)
            wmemo.send()
        cSubject = _('Thank you for the registration')
        cBody = _('''Thank you for the registration to our community.
According to our policy, user membership will be given by the administrator.
A mail will be delivered to you when administrator approves your membership.''')
        return errorTemplate(cSubject, cBody)
    else:
        if user and user.level > int(config.waitingLevel):
            login(user)
            cSubject = _('Welcome') + ' %s,' % user.uid
            cBody = _('''Thank you for registering. Now you are a member of this site. Enjoy you time.''')
            return errorTemplate(cSubject, cBody)
    user.log('do_registerUser', uid)
    redirect('pybbs.py')

def do_editUserProfile(form, user):
    if user.level < int(config.waitingLevel):
        return do_login(form, user)
    globalNS = bbslib.getGlobalNS()
    user.log('do_editUserProfile')
    template = getTemplate(os.path.join(config.skinPath, 'userUpdateForm.teul'))
    return templateProcessor(template, globalNS, user.__dict__)

def do_updateUser(form, user):
    if user.level < int(config.waitingLevel):
        return do_login(form, user)
    ns = {}
    for key in user.updateFieldNames:
        ns[key] = form.getvalue(key, '')
    for key in form.keys():
        if key not in ns:
            ns[key] = form[key].value
    oldpasswd = ns['passwd']

    if not users.isValidUser(user.uid, oldpasswd):
        return errorTemplate('ERROR : ' + _('Invalid user or wrong password'))
    if ns.get('newPasswd', '') and ns.get('newPasswdConf', ''):
        ns['passwd'] = ns['newPasswd']
    else:
        ns['passwd'] = oldpasswd
    ns['passwd'] = users.encryptPasswd(ns['passwd'])
    for name in ['newPasswd', 'newPasswdConf', 'uploadAvatar', 'avatarUrl']:
        if name in ns:
            del ns[name]
    try:
        user.update(**ns)
    except Exception, errMsg:
        return getErrorMessage()
    try:
        if form.has_key('uploadAvatar') and form['uploadAvatar'].value:
            avatarFileName = form['uploadAvatar'].filename
            avatarFileValue = form['uploadAvatar'].value
            user.uploadAvatar(avatarFileName, avatarFileValue)
        if form.has_key('avatarUrl') and form['avatarUrl'].value and form['avatarUrl'].value != 'http://':
            avatarFileName = urlparse.urlsplit(form['avatarUrl'].value)[2]
            avatarFileName = os.path.split(avatarFileName)[-1]
            avatarFileValue = urllib.urlopen(form['avatarUrl'].value).read()
            user.uploadAvatar(avatarFileName, avatarFileValue)
    except Exception, errMsg:
        return errorTemplate('ERROR : ', _('avatar path might not be correct'))

    user.log('do_updateUser')
    redirect('pybbs.py')

def do_showUserArticles(form, user):
    if user.level < int(config.memberLevel):
        return do_login(form, user)
    uid = form.getvalue('uid', '')
    pageNo = form.getvalue('pageNo', 1)
    forumId = form.getvalue('forumId', 'all')
    if not (uid and users.getUser(uid)):
        return errorTemplate('ERROR : ' + _('Invalid user'))
    user.log('do_showUserArticles', '%s %s %s' % (uid, forumId, pageNo))
    import search
    articlesHtml = search.displaySearchArticles(user, 'uid', uid, forumId, int(pageNo), template='searchResult.teul')
    return articlesHtml

def do_search(form, user):
    import search
    method = form.getvalue('method', '')
    keyword = form.getvalue('keyword', '')
    forumId = form.getvalue('forumId', 'all')
    pageNo = form.getvalue('pageNo', 1)
    user.log('do_search', '%s %s %s %s' % (method, keyword, forumId, pageNo))

    if method and keyword:
        return search.displaySearchArticles(user, method, keyword, forumId, int(pageNo), template='searchResult.teul')
    else:
        globalNS = bbslib.getGlobalNS()
        template = getTemplate(os.path.join(config.skinPath, 'searchForm.teul'))
        return templateProcessor(template, globalNS, locals())

def do_searchUser(form, user):
    if user.level < int(config.memberLevel):
        return do_login(form, user)
    uid = form.getvalue('uid', '').strip()
    user.log('do_searchUser', '%s' % uid)
    if uid:
        userList = users.getUserListById(uid)
    else:
        userList = []
    globalNS = bbslib.getGlobalNS()
    template = getTemplate(os.path.join(config.skinPath, 'searchUser.teul'))
    return templateProcessor(template, globalNS, locals())

def do_statistic(form, user):
    if user.level < int(config.memberLevel):
        return do_login(form, user)
    import statistic
    user.log('do_statistic')
    stat = statistic.Statistic()
    stat.getAll()
    return stat.toHTML()

def do_deleteUser(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)

    notFoundUsers = []
    for key in form.keys():
        if key.startswith('user'):
            uid = form.getvalue(key, '')
            if uid and key.endswith(uid):
                user.log('do_deleteUser', uid)
                userToBeDeleted = users.getUser(uid)
                if userToBeDeleted:
                    users.deleteUser(uid)
                else:
                    notFoundUsers.append(uid)
    if notFoundUsers:
        return errorTemplate('WARNING : ', _('No such users exist') + ' - %s' % str(notFoundUsers))
    redirectPath = 'pybbs.py?action=adminUserManager'
    redirect(redirectPath)
    
def do_userGroupManager(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    submit = form.getvalue('submit', '')
    if not submit:
        userGroupConfigFile = userGroup.readUserGroupConfigFile()
        globalNS = bbslib.getGlobalNS()
        template = getTemplate(os.path.join(config.skinPath, 'userGroupManager.teul'))
        return templateProcessor(template, globalNS, locals())
    else:
        userGroupConfigFile = form.getvalue('userGroupConfigFile', '')
        userGroup.writeUserGroupConfigFile(userGroupConfigFile)
        for user, time in users.userCache.values():
            user.getGroupList()
            user.accessibleForumList = user.getAccessibleForumList()
        redirectPath = 'pybbs.py?action=adminPage'
        redirect(redirectPath)

def do_groupMail(form, user):
    if user.level < int(config.adminLevel):
        return do_login(form, user)
    toGroups = form.getvalue('toGroups', '')
    subject = form.getvalue('subject', '')
    body = form.getvalue('body', '')
    globalNS = bbslib.getGlobalNS()

    userGroupObj = userGroup.getUserGroup()
    if not (subject.strip() and body.strip() and toGroups.strip()):       
        user.log('do_groupMail write form')
        groupNameList = userGroupObj.sections()
        globalNS = bbslib.getGlobalNS()
        template = getTemplate(os.path.join(config.skinPath, 'groupMail.teul'))
        return templateProcessor(template, globalNS, locals())
    else:        
        user.log('do_groupMail sent', '%s %s' % (toGroups, subject))

        toGroupNameList = toGroups.split()
        doesntExistGroups = []
        for groupName in toGroupNameList:
            if not userGroupObj.has_section(groupName):
                doesntExistGroups.append(groupName)
        if doesntExistGroups:
            return errorTemplate('doesnt exist groupName : ', ', '.join(doesntExistGroups))            
        userGroupEmailList = [user.email for user in userGroupObj.getMembersOfGroups(toGroupNameList)]
        try:
            m = mail.Mail()
        except:
            return errorTemplate('email has not sent. check your SMTP server.')
        else:
            try:
                subject = subject
                body = body
                m.send(config.webmaster, userGroupEmailList, subject, body)
            except mail.SendMailError:
                return errorTemplate('email has not sent. check your SMTP server.')
    redirectPath = 'pybbs.py?action=adminPage'
    redirect(redirectPath)

def do_showHtml(form, user):
    fname = form.getvalue('file', '')
    try:
        ext = os.path.splitext(fname)[1]
    except IndexError, errMsg:
        return errorTemplate(errMsg)
    extList = ['.teul', '.html', '.htm']
    if not ext.lower() in extList:
        return errorTemplate('ERROR : Can\'t read this file', fname)
    if not fname.lower().endswith('.teul'):
        return open(fname).read()
    template = getTemplate(os.path.join(config.skinPath, fname))
    return templateProcessor(template, bbslib.getGlobalNS(), locals())
