import time

class Cache(dict):
    def __init__(self, maxCount):
        self.maxCount = maxCount
        dict.__init__(self)

    def getItem(self, key):
        item, atime = self.get(key, (False, False))
        if item:
            self[key] = item, time.time()
            return item
        return None

    def putItem(self, key, item):
        self[key] = item, time.time()
        if len(self) > self.maxCount:
            L = self.items()
            L.sort(lambda a, b: cmp(a[1][1], b[1][1]))
            key = L[0][0]
            self.deleteItem(key)
        return item

    def deleteItem(self, key):
        if key in self:
            del self[key]
