import sys
import ConfigParser

class MyDict(dict):
    def __init__(self, *args):
        dict.__init__(self, *args)
        self.order = []
    def __setitem__(self, name, value):
        if not name in self:
            self.order.append(name)
        dict.__setitem__(self, name, value)
    def __iter__(self):
        self.accessIndex = 0
        return self
    def __delitem__(self, name):
        self.order.remove(name)
        dict.__delitem__(self, name)
    def next(self):
        try:
            key = self.order[self.accessIndex]
        except IndexError:
            raise StopIteration
        self.accessIndex += 1
        return key
    def keys(self):
        return self.order
    def values(self):
        return map(self.__getitem__, self.order)
    def items(self):
        return zip(self.order, map(self.__getitem__, self.order))
    def copy(self):
        newD = MyDict()
        for key, value in self.items():
            newD[key] = value
        return newD


class CookedConfigParser(ConfigParser.ConfigParser):
    def __init__(self, defaults=None):
        ConfigParser.ConfigParser.__init__(self, defaults)
        if sys.version_info[:2] <= (2, 2):
            self._ConfigParser__sections = MyDict()
            self._sections = self._ConfigParser__sections
        else:
            self._sections = MyDict()
    def sections(self):
        return self._sections
    def add_section(self, section):
        if section in self._sections:
            raise DuplicateSectionError(section)
        self._sections[section] = MyDict()
    def optionxform(self, optstr):
        return optstr
    def options(self, section):
        try:
            opts = self._sections[section].copy()
        except KeyError:
            raise ConfigParser.NoSectionError(section)
        opts.update(self.defaults())
        tempKeys = []
        for key in opts.keys():
            if key == '__name__':
                continue
            tempKeys.append(key)                
        return tempKeys
        
    def _read(self, fp, fpname):
        cursect = None                           
        optname = None
        lineno = 0
        e = None
        DEFAULTSECT = "DEFAULT"
        while 1:
            line = fp.readline()
            if not line:
                break
            lineno = lineno + 1
            if line.strip() == '' or line[0] in '#;':
                continue
            if line.split(None, 1)[0].lower() == 'rem' and line[0] in "rR":
                continue
            if line[0].isspace() and cursect is not None and optname:
                value = line.strip()
                if value:
                    cursect[optname] = "%s\n%s" % (cursect[optname], value)
            else:
                mo = self.SECTCRE.match(line)
                if mo:
                    sectname = mo.group('header')
                    if sectname in self._sections:
                        cursect = self._sections[sectname]
                    elif sectname == DEFAULTSECT:
                        cursect = self.defaults()
                    else:
                        cursect = MyDict()
                        cursect['__name__'] = sectname
                        self._sections[sectname] = cursect
                    optname = None
                elif cursect is None:
                    raise MissingSectionHeaderError(fpname, lineno, `line`)
                else:
                    mo = self.OPTCRE.match(line)
                    if mo:
                        optname, vi, optval = mo.group('option', 'vi', 'value')
                        if vi in ('=', ':') and ';' in optval:
                            pos = optval.find(';')
                            if pos != -1 and optval[pos-1].isspace():
                                optval = optval[:pos]
                        optval = optval.strip()
                        if optval == '""':
                            optval = ''
                        optname = self.optionxform(optname.rstrip())
                        cursect[optname] = optval
                    else:
                        if not e:
                            raise ConfigParser.ParsingError, fpname
                        e.append(lineno, `line`)
        if e:
            raise e
   
    _ConfigParser__read = _read # another name of _read
