'''
'''
import os
import dblib
import bbslib
import config
from templateProcessor import templateProcessor, getTemplate

def searchArticles(user, method, keyword, forumId='all', pageNo=1, sortBy='date', order='DESC'):
    cursor = dblib.getCursor()
    groups = bbslib.getGroups()
    tableNames = []
    if forumId == 'all':    
        for category in groups:
            for forum in category:
                if forum.read == 'all' or user.level >= int(config.adminLevel) or forum.isUserGroupMember(user):
                    tableNames.append(forum.forumId)
    else:
        forum = groups.getForum(forumId)
        if forum.read == 'all' or user.level >= int(config.adminLevel) or forum.isUserGroupMember(user):
            tableNames = [forumId]
        else:
            tableNames = []

    articleList = bbslib.PageList(int(config.numberOfArticlesInAPage), pageNo)
    if method == 'uid':
        nkeyword = keyword
    else:
        nkeyword = "%" + keyword + "%"

    N = 0
    numberOfArticles = {}
    for table in tableNames:
        cursor.execute('''
        SELECT COUNT(*) FROM %s WHERE %s LIKE '%s' ORDER BY %s %s
        ''' % (table, method, nkeyword, sortBy, order))
        numberOfArticles[table] = int(cursor.fetchone()[0])
        N += numberOfArticles[table]
    T = 0
    count = int(config.numberOfArticlesInAPage)
    from math import ceil
    for table in tableNames:
        subPageNo = pageNo - int(ceil(T / float(config.numberOfArticlesInAPage)))
        offset = T % config.numberOfArticlesInAPage
        T += numberOfArticles[table]
        if subPageNo == 0:
            start = 0
        else:
            start = (subPageNo-1) * config.numberOfArticlesInAPage + offset
        if T <= (pageNo-1)*config.numberOfArticlesInAPage:
            continue
        cursor.execute('''
        SELECT * FROM %s WHERE %s LIKE '%s' ORDER BY %s %s LIMIT %d, %d
        ''' % (table, method, nkeyword, sortBy, order, start, count))
        for args in cursor.fetchall():
            fieldNames = dblib.getFieldNames(table)            
            article = bbslib.Article(None, **dict(zip(fieldNames, args)))
#            article = bbslib.Article(None, *args)
            article.forumId = table
            forum = groups.getForum(article.forumId)
            article.forumName = forum.forumName
            thread = forum.getThreadById(article.threadId)
            thread.refresh()
            article.threadSubject = thread.subject
            article.replies = thread.replies
            article.readCount = thread.readCount
            article.escapeBodyHtml()
#            article.escapedHtmlBody = article.escapedHtmlBody.replace(keyword, '<span class="search">%s</span>'%keyword)
            articleList.append(article)
            count -= 1
        if count <= 0: break
    articleList.setnPages(N)
    return articleList

def displaySearchArticles(user, method, keyword, forumId='all', pageNo=1,
                           template='searchResult.teul'):
    articleList = searchArticles(user, method, keyword, forumId, pageNo)
    globalNS = bbslib.getGlobalNS()
    globalNS['pageNo'] = pageNo
    template = bbslib.getTemplate(os.path.join(config.skinPath, template))
    return templateProcessor(template, globalNS, locals())
