'''
    PyBB - Upgrade 

    Copyright (c) 2003-2004 Gang Seong Lee <gslee@mail.kw.ac.kr>
    All rights reserved, see COPYING for details.
'''

import os
def upgradeTo0_9_0():
    # setup.cgi upgrade
    if os.path.exists('setup.cfg') and not os.path.exists('setup.cgi'):
        os.rename('setup.cfg', 'setup.cgi')
    from bbs import pyConfigParser
    cfg = pyConfigParser.CookedConfigParser()
    cfg.readfp(open('setup.cgi'))
    toBeAddedItems = [
        ('ip control', (
            ('allowIpList', ''), 
            ('denyIpList', ''))
        ),
        ('machine blocking', (
            ('machineBlocking', 'False'), 
            ('readBlockingTime', '0.5'), 
            ('writeBlockingTime', '3'))
        ),
        ('read/write blocking', (
            ('allowedMaxNumberOfArticlesToWritePerIpADay', '0'), 
            ('allowedMaxNumberOfArticlesToReadPerIpADay', '0'))
        ),
        ('site information', (
            ('urlPrefix', '/'),)
        ),
        ('page setup', (
            ('numberOfSearchResultsInAPage', '10'),)
        ),
        ('env', (
            ('bannedExtensions', 'php htm'),)
        ),
        ('paths', (
            ('systemFolder', './'),)
        )]
    for item in toBeAddedItems:
        section, options = item
        if not cfg.has_section(section):
            cfg.add_section(section)
        for optionItem in options:
            option, optionValue = optionItem
            if not cfg.has_option(section, option):
                cfg.set(section, option, optionValue)
    toBeRemovedItems = (
        ('page setup', 'numberOfTitlesInAPage'),
        ('page setup', 'numberOfArticlesInAPage')
    )
    for section, option in toBeRemovedItems:
        if cfg.has_option(section, option):
            cfg.remove_option(section, option)
    cfg.write(open('setup.cgi', 'w'))

    # forum.ini upgrade
    toBeAddedSection = 'CategoryConfiguration'
    toBeAddedOptions = {
        'forumId':'',                # FIXME???
        'DefaultType':'Discussion',
        'NumberOfTitlesInAPage':'10',
        'NumberOfArticlesInAPage':'10',
        'ThumbnailSizeX':'128',
        'ThumbnailSizeY':'96',
        'ThumbnailColumns':'5',
        'EmailNoticeUserGroupList':'',
    }
    toBeRemovedOptions = [
        'ForumSkinPath', 'ThreadSkinPath', 'ArticleSkinPath', 'articleSkinPath2'
    ]
    
    iniList = filter(None, map(lambda fileName: fileName.strip(), open('groupDesc.txt', 'r').readlines()))
    for iniFileName in iniList:
        cfg = pyConfigParser.CookedConfigParser()
        cfg.add_section(toBeAddedSection)
        cfg.set(toBeAddedSection, 'Fold', 'unfolding')
        cfg.readfp(open(iniFileName))
        forumSectionList = cfg.sections().keys()[1:]
        for forumSection in forumSectionList:
            for option, value in toBeAddedOptions.items():
                if not cfg.has_option(forumSection, option):
                    cfg.set(forumSection, option, value)
            cfg.set(forumSection, 'forumId', forumSection) # FIXME
        for forumSection in forumSectionList:
            for option in toBeRemovedOptions:
                if cfg.has_option(forumSection, option):
                    cfg.remove_option(forumSection, option)
        cfg.write(open(iniFileName, 'w'))
 
    # database table upgrade
    from bbs import config
    from bbs import dblib
    names = map(lambda f: f[0], dblib.getFieldInfo(config.userTableName))
    if 'forumEmailNotice' not in names:
        print 'Adding new column forumEmailNotice to %s' % config.userTableName
        cursor = dblib.getCursor()
        cursor.execute('ALTER TABLE %s ADD forumEmailNotice VARCHAR(255)' % (config.userTableName))
        cursor.execute('UPDATE %s SET forumEmailNotice=""' % (config.userTableName))
    # user.log remove
    if os.path.isfile('user.log'):
        i = 1
        while i:
            if not os.path.exists('user%s.log' % i):
                os.rename('user.log', 'user%s.log' % i)
                break
            i += 1
   
    

def upgrade():
    upgradeTo0_9_0()

def init():
    from bbs import bbslib
    bbslib.initializeForumEmailNotificationFiles()
    
def run():
    upgrade()
    init()

if __name__ == '__main__':
    run()
