// devil_pyd.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"

#include <eter/py_tinker.h>

#include <il/il.h>

ILuint devil_ilGenImage()
{
	ILuint ret_img;
	ilGenImages(1, &ret_img);
	return ret_img;
}

void devil_ilDeleteImage(ILuint del_img)
{
	ilDeleteImages(1, &del_img);
}

ILboolean devil_ilLoad(ILenum type, const char* fileName)
{
	return ilLoad(type, (ILstring)fileName);
}

ILboolean devil_ilSave(ILenum type, const char* fileName)
{
	return ilSave(type, (ILstring)fileName);
}



ILvoid devil_ilCopyPixels(PyObject* poOffset, PyObject* poSize, ILenum format, ILenum type, ILvoid* data)
{
	if (!PyTuple_Check(poOffset))
	{
		throw PyTinkerException(PyExc_TypeError, "args[0]:offset is not tuple");
		return;
	}
	if (!PyTuple_Check(poSize))
	{
		throw PyTinkerException(PyExc_TypeError, "args[1]:size is not tuple");
		return;
	}
	ILuint x = py_tinker::arg_<int>(poOffset, 0);
	ILuint y = py_tinker::arg_<int>(poOffset, 1);
	ILuint z = py_tinker::arg_<int>(poOffset, 2);
	ILuint w = py_tinker::arg_<int>(poSize, 0);
	ILuint h = py_tinker::arg_<int>(poSize, 1);
	ILuint d = py_tinker::arg_<int>(poSize, 2);

	if (ilGetInteger(IL_ORIGIN_MODE) == IL_ORIGIN_LOWER_LEFT)
	{
		int img_height = ilGetInteger(IL_IMAGE_HEIGHT);
		ilCopyPixels(x, img_height - y - h, z, w, h, d, format, type, data);
	}
	else
	{
		ilCopyPixels(x, y, z, w, h, d, format, type, data);
	}
}

ILvoid devil_ilSetPixels(PyObject* poOffset, PyObject* poSize, ILenum format, ILenum type, ILvoid* data)
{
	if (!PyTuple_Check(poOffset))
	{
		throw PyTinkerException(PyExc_TypeError, "args[0]:offset is not tuple");
		return;
	}
	if (!PyTuple_Check(poSize))
	{
		throw PyTinkerException(PyExc_TypeError, "args[1]:size is not tuple");
		return;
	}
	ILuint x = py_tinker::arg_<int>(poOffset, 0);
	ILuint y = py_tinker::arg_<int>(poOffset, 1);
	ILuint z = py_tinker::arg_<int>(poOffset, 2);
	ILuint w = py_tinker::arg_<int>(poSize, 0);
	ILuint h = py_tinker::arg_<int>(poSize, 1);
	ILuint d = py_tinker::arg_<int>(poSize, 2);

	if (ilGetInteger(IL_ORIGIN_MODE) == IL_ORIGIN_LOWER_LEFT)
	{
		int img_height = ilGetInteger(IL_IMAGE_HEIGHT);
		ilSetPixels(x, img_height - y - h, z, w, h, d, format, type, data);
	}
	else
	{
		ilSetPixels(x, y, z, w, h, d, format, type, data);
	}	
}

ILuint devil_ilTexImage(PyObject* poSize)
{
	if (!PyTuple_Check(poSize))
	{
		throw PyTinkerException(PyExc_TypeError, "args[0]:size is not tuple");
		return 0;
	}

	ILuint w = py_tinker::arg_<int>(poSize, 0);
	ILuint h = py_tinker::arg_<int>(poSize, 1);
	ILuint d = py_tinker::arg_<int>(poSize, 2);
	
	if (!ilTexImage(w, h, d, 4, IL_BGRA, IL_UNSIGNED_BYTE, NULL))
	{
		throw PyTinkerException(PyExc_TypeError, "ilTexImage - FAILURE");
		return 0;
	}

	return 0;
}

PyMODINIT_FUNC
initdevil()
{
	py_tinker::module_("devil")
		.STDCALL_DEFV(ilInit)
		.STDCALL_DEFV(ilBindImage)
		.STDCALL_DEFT(ilGetInteger)
		.STDCALL_DEFT(ilEnable)
		.STDCALL_DEFV(ilSetInteger)	
		.STDCALL_DEFT(ilConvertImage)
		.STDCALL_DEFT(ilGetData)		
		.STDCALL_DEFT(ilOriginFunc)
		.DEFE(IL_IMAGE_WIDTH)
		.DEFE(IL_IMAGE_HEIGHT)
		.DEFE(IL_TYPE_UNKNOWN)
		.DEFE(IL_UNSIGNED_BYTE)
		.DEFE(IL_FILE_OVERWRITE)
		.DEFE(IL_JPG_QUALITY)
		.DEFE(IL_ORIGIN_SET)
		.DEFE(IL_ORIGIN_MODE)
		.DEFE(IL_ORIGIN_UPPER_LEFT)
		.DEFE(IL_ORIGIN_LOWER_LEFT)
		.DEFE(IL_BYTE) 
		.DEFE(IL_UNSIGNED_BYTE)
		.DEFE(IL_FLOAT)
		.DEFE(IL_BGRA) 
		.DEFE(IL_BGR) 
		.DEFE(IL_RGBA)
		.DEFE(IL_RGB)
		.DEFE(IL_BYTE)
		.DEFE(IL_BMP)
		.DEFE(IL_TGA)
		.DEFE(IL_PNG)
		.DEFE(IL_PCX)
		.DEFE(IL_JPG)
		.deft("ilLoad", devil_ilLoad)		
		.deft("ilSave", devil_ilSave)		
		.deft("ilGenImage", devil_ilGenImage)		
		.defv("ilDeleteImage", devil_ilDeleteImage)		
		.deft("ilTexImage", devil_ilTexImage)
		.defv("ilCopyPixels", devil_ilCopyPixels)
		.defv("ilSetPixels", devil_ilSetPixels)
		;
}



BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    return TRUE;
}

