#pragma once

#define WIN32_LEAN_AND_MEAN

#include <assert.h>
#include <windows.h>

class ELDIB32
{
	public:
		ELDIB32()
		{
			__Initialize();
		}
		virtual ~ELDIB32()
		{
			Destroy();
		}
		bool IsEmpty()
		{
			if (!m_hBmp)
				return true;

			if (!m_hDC)
				return true;

			return false;
		}
		void Destroy()
		{
			if (m_hBmp) DeleteObject(m_hBmp);			
			if (m_hDC)	DeleteDC(m_hDC);
	
			__Initialize();	
		}
		bool Create(HDC hDC, int width, int height)
		{
			assert(NULL == m_hBmp);
			assert(NULL == m_hDC);
			
			m_width = width;
			m_height = height;
			
			memset(&m_bmi.bmiHeader,  0, sizeof(BITMAPINFOHEADER));
			m_bmi.bmiHeader.biSize        = sizeof(BITMAPINFOHEADER);
			m_bmi.bmiHeader.biWidth       =  m_width;
			m_bmi.bmiHeader.biHeight      = -m_height;
			m_bmi.bmiHeader.biPlanes      = 1;			
			m_bmi.bmiHeader.biBitCount    = 32;
			m_bmi.bmiHeader.biCompression = BI_RGB;
			
			m_hDC=CreateCompatibleDC(hDC);
			if (!m_hDC)
			{
				assert(!"CGraphicDib::Create CreateCompatibleDC Error");
				return false;
			}
			
			m_hBmp=CreateDIBSection(m_hDC, &m_bmi, DIB_RGB_COLORS, &m_pvBuf, NULL, 0);
			if (!m_hBmp)
			{
				assert(!"CGraphicDib::Create CreateDIBSection Error");
				return false;
			}
						
			SelectObject(m_hDC, m_hBmp);

			return true;
		}

		void Draw(HDC hDC, int x, int y)
		{
			SetDIBitsToDevice(hDC, 
				x, y, m_width, m_height,
				0, 0, 0, m_height, m_pvBuf, &m_bmi, DIB_RGB_COLORS);
		}

		int GetWidth()
		{
			return m_width;
		}

		int GetHeight()
		{
			return m_height;
		}

		int GetDataSize()
		{return m_width * m_height * 4;}	
		
		void* GetDataPtr()
		{return m_pvBuf;}

		HDC GetDC()
		{return m_hDC;}
		
	protected:
		void __Initialize()
		{
			m_hDC=NULL;
			m_hBmp=NULL;
			m_pvBuf=NULL;
			m_width=0;
			m_height=0;
		}
		
	protected:		
		HDC			m_hDC;
		HBITMAP		m_hBmp;
		BITMAPINFO	m_bmi;

		int			m_width;
		int			m_height;

		void *		m_pvBuf;
};