// py_ex_dib.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "dib.h"

#include <eter/py_tinker.h>
#include <eter/py_tinker_win32.h>

class PyDIB32 : public ELDIB32
{
public:
	PyDIB32()
	{
	}
	virtual ~PyDIB32()
	{
	}
	void Create(HDC hDC, int width, int height)
	{
		if (!ELDIB32::IsEmpty())
		{
			throw PyTinkerException(PyExc_RuntimeError, "dib.not_empty_error");
			return;
		}
		if (!ELDIB32::Create(hDC, width, height))
		{
			throw PyTinkerException(PyExc_RuntimeError, "dib.create_error");
			return;
		}		
	}
};

py_tinker::class_<PyDIB32> build_dib()
{
	using namespace py_tinker;
	return class_<PyDIB32>("dib")
		.defv("create",		&PyDIB32::Create)
		.defv("destroy",	&PyDIB32::Destroy)
		.deft("empty",		&PyDIB32::IsEmpty)
		.defv("draw",		&PyDIB32::Draw)
		.deft("dc",			&PyDIB32::GetDC)
		.deft("data",		&PyDIB32::GetDataPtr)
		.deft("width",		&PyDIB32::GetWidth)
		.deft("height",		&PyDIB32::GetHeight)	
		;
}


void initdib()
{
	py_tinker::module_("dib")
		.def(build_dib())		
		;
}

impl_arg_class_(PyDIB32)

int main(int argc, char* argv[])
{
	Py_Initialize();
	Py_SetProgramName((char*)"py_test");
				
	initdib();
	py_tinker::PyEmbed_RunMainFile("ex_dib.py");
	Py_Finalize();		
	return 0;
}
