// py_ex_gwnd.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "GameWindow.h"

#include <eter/py_tinker.h>
#include <eter/py_tinker_win32.h>

static py_tinker::object gs_onIdle;
static py_tinker::object gs_onDispatch;

static class PyGameWindow_MessageHandler : public ELGameWindow_MessageHandler
{
public:
	PyGameWindow_MessageHandler() {}
	virtual ~PyGameWindow_MessageHandler() {}

	virtual void	OnIdle()
	{
		gs_onIdle();
	}
	virtual LRESULT OnDispatchMessage(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
	{
		if (gs_onDispatch)
			return PyLong_AsLong(gs_onDispatch(hWnd, msg, wParam, lParam));
		
		return ELGameWindow_MessageHandler::OnDispatchMessage(hWnd, msg, wParam, lParam);
	}

} gs_msgHandler;

void PyGameWindow_Startup()
{
	if (!ELGameWindow_Startup())
		throw PyTinkerException(PyExc_RuntimeError, "gwnd.init_error");

	ELGameWindow_SetMessageHandler(gs_msgHandler);
}

void PyGameWindow_BindIdleFunc(PyObject* func)
{
	gs_onIdle = func;
}

void PyGameWindow_BindDispatchFunc(PyObject* func)
{
	gs_onDispatch = func;
}

void initgwnd()
{
	py_tinker::module_("gwnd")
		.defv("startup", PyGameWindow_Startup)
		.defv("cleanup", ELGameWindow_Cleanup)
		.defv("loop", ELGameWindow_Loop)
		.defv("show", ELGameWindow_Show)
		.defv("hide", ELGameWindow_Hide)
		.defv("adjust_size", ELGameWindow_AdjustWindowSize)
		.deft("get_hwnd", ELGameWindow_GetHandle)
		.deft("get_dc", ELGameWindow_GetDC)
		.defv("release_dc", ELGameWindow_ReleaseDC)
		.defv("__set_idle_func", PyGameWindow_BindIdleFunc)
		.defv("__set_dispatch_func", PyGameWindow_BindDispatchFunc)
		;
}


int main(int argc, char* argv[])
{
	Py_Initialize();
	Py_SetProgramName((char*)"py_test");
				
	initgwnd();
	py_tinker::PyEmbed_RunMainFile("ex_gwnd.py");
	Py_Finalize();	
	return 0;
}
