// py_ex_property.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "stdafx.h"

#include <eter/py_tinker.h>
#include <stdio.h>

struct test1
{
	int a;
	int b;
	int c;

	void ShowCppValue()
	{
		printf("ShowCppValue %d\n", a);
	}
};

struct test2
{
	char e;
};

test1* run()
{
	test1* a = new test1;
	a->a = 1;
	a->b = 2;
	a->c = 3;

	return a;
}

using namespace py_tinker;

class_<test1> build_test1()
{
	return class_<test1>("test1")
		.def("a", &test1::a)
		.def("b", &test1::b)
		.def("c", &test1::c)
		.defv("ShowCppValue", &test1::ShowCppValue)
		;
}

class_<test2> build_test2()
{
	return class_<test2>("test2")
		;
}
/*
namespace py_tinker {
struct type_<const test1&> {
	typedef test1* base_type;
	static const test1& cast(const base_type& r)
	{return *r;}
};
struct type_<const test1*> {
	typedef test1* base_type;
	static const test1* cast(const base_type& r)
	{return r;}
};
inline bool PyObject_As(PyObject* obj, test1** ret) {
	if (!PyCppInstance_Check(obj))
		return false;
	*ret = (test1*)PyCppInstance_GetCppInstPtr(obj);
	return true;
}
inline PyObject* PyObject_From(const test1* src) {
	if (!src) {Py_INCREF(Py_None);return Py_None;}
	return PyCppInstance_FromCppInstance(class_<test1>::m_cls, 
		PyCObject_FromVoidPtr((void*)src, default_del_inst));
}
}

namespace py_tinker {
struct type_<const test2&> {
	typedef test2* base_type;
	static const test2& cast(const base_type& r)
	{return *r;}
};
struct type_<const test2*> {
	typedef test2* base_type;
	static const test2* cast(const base_type& r)
	{return r;}
};
inline bool PyObject_As(PyObject* obj, test2** ret) {
	if (!PyCppInstance_Check(obj))
		return false;
	*ret = (test2*)PyCppInstance_GetCppInstPtr(obj);
	return true;
}
inline PyObject* PyObject_From(const test2* src) {
	if (!src) {Py_INCREF(Py_None);return Py_None;}
	return PyCppInstance_FromCppInstance(class_<test2>::m_cls, 
		PyCObject_FromVoidPtr((void*)src, default_del_inst));
}
}
*/
impl_arg_class_(test1)
impl_arg_class_(test2)

void initeter()
{
	py_tinker::module_("eter")
		.def(build_test1())
		.def(build_test2())
		//.deft("run", run)
		;
}

void main()
{	

	Py_Initialize();
	Py_SetProgramName((char*)"py_test");
			
	initeter();
	py_tinker::PyEmbed_RunMainFile("ex_property.py");
	Py_Finalize();	
}

