from distutils.core import setup 
import time
import py2exe 

L = []
for dec in time.strftime('%y.%m.%d').split('.'):
	i = 0
	while i < len(dec) and dec[i] == '0':
		i = i + 1
	L.append(dec[i:])
dateVersion = '.'.join(L)
newVersion = raw_input('version(%s) : ' % dateVersion).strip()
if newVersion:
	file('version.py', 'wb').write('version = "%s"' % newVersion)
	version = newVersion
else:
	file('version.py', 'wb').write('version = "%s"' % dateVersion)
	version = dateVersion

text = file('README.template').read()
text = text.replace('<:version:>', version)
text = text.replace('<:date:>', time.strftime('%B %d, %Y'))
file('README', 'w').write(text)



setup(
    name = "PyWall",
    version = version,
    description = "Wallpaper manager",
    author = "PyWall Team",
    url = "http://pywall.kldp.net",
    license = "BSD",
    platforms = ["Windows"],
    windows = ["run.pyw"],
    options = {"py2exe": { 
            "bundle_files": 1,
            "compressed": 1,
            "optimize": 2,
        }
    } 
)    
