// for Non-ASCII locale 
#include <qtextcodec.h>  
#include <global.h>
extern QTextCodec * codec ;
#define UniString(str)   codec->toUnicode(str)

int 		flag_24_ok; // we presume a kernel 2.4.x


//DEL ( because of 2byte language)
static inline bool isprintable(unsigned char c)
{
	// assume, somewhat navely, that all latin-1 characters are printable
	return (c >= 0x20 && c < 0x7f) || c >= 0xa0;
}

//DEL replace unprintables by spaces
static void make_printable(char *s)
{
	while(*s) {
		if(!isprintable(*s)) *s = ' ';
		++s;
	}
}

Category::~Category()
{}

int Category::compare(Procinfo *a, Procinfo *b)
{
	return string(a).compare(string(b));
}


Cat_int::Cat_int(const char *heading, const char *explain,
		int w, int Procinfo::*member)
: Category(heading, explain), int_member(member), field_width(w)
{}

QString Cat_int::string(Procinfo *p)
{
	QString s;
	s.setNum(p->*int_member);	
	return s;
}

int Cat_int::compare(Procinfo *a, Procinfo *b)
{
	// qsort() only cares about the sign of the number returned by the
	// comparison function; only a subtraction is necessary
	return a->*int_member - b->*int_member;
}

// added 2006/05/07
Cat_memory::Cat_memory(const char *heading, const char *explain,int w, unsigned long Procinfo::*member)
: Category(heading, explain), uintl_member(member), field_width(w)
{}

QString Cat_memory::string(Procinfo *p)
{
	QString s;
	char buff[128];

	long sizeK,sizeM;
	sizeK=p->*uintl_member;
	sizeM = sizeK/1024;

	if ( sizeM > 0 ) 
		sprintf(buff,"%dM",sizeM);
	else
		sprintf(buff,"%dK",sizeK);
	if ( sizeK == 0 ) 
		s = "0";
	else 
		s = buff;
	return s;
}

int Cat_memory::compare(Procinfo *a, Procinfo *b)
{
	int bu = b->*uintl_member, au = a->*uintl_member;
	return bu >= au ? (bu == au ? 0 : 1) : -1;
}


Cat_uintl::Cat_uintl(const char *heading, const char *explain, int w,
		unsigned long Procinfo::*member)
: Category(heading, explain), uintl_member(member), field_width(w)
{}

QString Cat_uintl::string(Procinfo *p)
{
	QString s;
	s.setNum(p->*uintl_member);	
	return s;
}

int Cat_uintl::compare(Procinfo *a, Procinfo *b)
{
	int bu = b->*uintl_member, au = a->*uintl_member;
	return bu >= au ? (bu == au ? 0 : 1) : -1;
}


Cat_hex::Cat_hex(const char *heading, const char *explain, int w,
		unsigned long Procinfo::*member)
		: Cat_uintl(heading, explain, w, member)
{}

// QString.sprintf 2x speed than glibc.sprintf (by fasthyun@magicn.com) 
// but QString structuring & destructring eat more time 
QString Cat_hex::string(Procinfo *p)
{
	QString s;
	s.sprintf("%8x", (unsigned)(p->*uintl_member));
	return s;
}

//COMMON, 
Cat_swap::Cat_swap(const char *heading, const char *explain)
: Category(heading, explain)
{}

QString Cat_swap::string(Procinfo *p)
{
	QString s;
	// It can actually happen that size < resident (Sun under Solaris 2.6)
	// Possible with Linux ?

	long sizeK,sizeM;
	sizeK=p->size > p->resident ? p->size - p->resident : 0;
	
	sizeM = sizeK /1024;

	if ( sizeM > 0 ) 
		s= QString::number(sizeM) + "M" ;
	else
		s= QString::number(sizeK) + "K" ;

	if (sizeK == 0) 
		s = "0";
	return s;
}

int Cat_swap::compare(Procinfo *a, Procinfo *b)
{
	return (b->size - b->resident) - (a->size - a->resident);
}



Cat_string::Cat_string(const char *heading, const char *explain,
		QString Procinfo::*member)
: Category(heading, explain), str_member(member)
{}

QString Cat_string::string(Procinfo *p)
{
	return p->*str_member;
}


Cat_user::Cat_user(const char *heading, const char *explain)
: Cat_string(heading, explain)
{}

QString Cat_user::string(Procinfo *p)
{
	if(p->uid == p->euid)
		return Uidstr::userName(p->uid);
	else {
		QString s = Uidstr::userName(p->uid);
		s.append(p->euid == 0 ? "*" : "+");
		return s;
	}
}



Cat_group::Cat_group(const char *heading, const char *explain)
: Cat_string(heading, explain)
{}

QString Cat_group::string(Procinfo *p)
{
	if(p->gid == p->egid)
		return Uidstr::groupName(p->gid);
	else {
		QString s = Uidstr::groupName(p->gid);
		s.append("*");
		return s;
	}
}


Cat_wchan::Cat_wchan(const char *heading, const char *explain)
	: Cat_string(heading, explain)
{}

QString Cat_wchan::string(Procinfo *p)
{
	return Wchan::name(p->wchan);
}



Cat_cmdline::Cat_cmdline(const char *heading, const char *explain)
: Cat_string(heading, explain)
{}

QString Cat_cmdline::string(Procinfo *p)
{
	if(p->cmdline.isEmpty()) {
		QString s("(");
		s.append(p->command);
		s.append(")");
		return s;
	} else {
		if(Qps::show_file_path)
			return p->cmdline;
		else {
			QString s(p->cmdline);
			
			int i = s.indexOf(' ');
			if(i < 0)
				i = s.length();
			if(i > 0) {
				i = s.lastIndexOf('/', i - 1);
				if(i >= 0)
					s.remove(0, i + 1);
			}
			return s;
		}
	}
}

/* ========================  Procview ============================  */
float Procview::avg_factor = 1.0;

Procview::Procview()
{
	//Proc::Proc(); //call once more ?
	cats.clear();
	reversed = FALSE;
	viewproc = ALL;
	treeview = TRUE;
	hasF_COMM=0;
	idxF_COMM=-1;
	enable=false;
	viewfields = USER;
	set_fields();
	sortcat = 0;// categories[F_PID];
}


// COMMON: 
// Description :
// 		View mode : ALL , OWNER, NO-ROOOT , HIDDEN, NETWORK 
bool Procview::accept_proc(Procinfo *p)
{
	QString pid;
	static int my_uid = getuid();
	bool    result;
	
	//if (viewproc==ALL) 
	result=true;
	
	
	//BAD
	if(viewproc == NETWORK )
	{
		p->read_fds();
		if(p->sock_inodes.size()==0)
			result=false;		
		for(int i=0;i<p->sock_inodes.size();i++)
		{
			SockInode *sn=p->sock_inodes[i];
			Sockinfo *si=Procinfo::socks.value(sn->inode,NULL);
			if(si)
			{
				si->pid=p->pid;
				linear_socks.add(si);			
			}
		}
	}
	else
	if ( viewproc == OWNED ) 
		result=(p->uid == my_uid);
	else 
	if ( viewproc == NROOT )  
		result=(p->uid != 0);
	else 
	if ( viewproc == RUNNING)	
		result= strchr("ORDW", p->state) != 0  ;


 	if ( viewproc == HIDDEN)
	{
		result=false;  
		for(int j=0;j<hidden_process.size();j++)
			if(hidden_process[j]==p->command)
				result=true ;
	}
	else 
	{
		for(int j=0;j<hidden_process.size();j++)
			if(hidden_process[j]==p->command)
				result=false;
	}

	if(result==false) return false;   // dont go further !! for better speed 

	
	if(search_box==NULL)	
		return result;

	if(search_box->text()=="" || search_box->text()=="*" )
		return true;


	//DEL if(p->command.contains(search_box->text(),Qt::CaseInsensitive))	return true;

	if(p->cmdline.contains(search_box->text(),Qt::CaseInsensitive)) 
		return true;	

	pid= pid.setNum(p->pid);  //=QString::number(p->pid);
	if(pid.contains(search_box->text(),Qt::CaseInsensitive)) 	
		return true;
		
	///printf("search_Box =%s , %s \n",search_box->text().toAscii().data(),p->command.toAscii().data());
		
	return false;
}

// table view - sort
void Procview::linearize_tree(Svec<Procinfo *> *ps, int level, int prow)
{
	static_sortcat = sortcat;
	ps->sort(reversed ? compare_backwards : compare);

	int size=ps->size();
	for(int i = 0; i < size; i++) 
	{
		Procinfo *p = (*ps)[i];
		p->level = level;
		p->lastchild = false;
		p->child_seq=i;   // *************
		linear_procs.add(p); //need
		p->parent_row=prow;
		row_count++;
		if(p->children.size() and !p->hidekids) //SEGFAULT
		//if(p->children.size())
			linearize_tree(&p->children, level + 1, linear_procs.size() - 1);
	}

	if(size > 0)
		(*ps)[size - 1]->lastchild = true;
}

/// basic,memory,job fields 
void Procview::set_fields_list(int fields[])
{
	cats.clear();
	for(int i = 0; fields[i] != F_END; i++)
	{
		Category *c=categories.value(fields[i],NULL);
		if(c){
			// printf("name=%s\n",c->name);
			cats.append(c);
			}
	}
	return;
}


// return the column number of a field, or -1 if not displayed
int Procview::findCol(int field_id)
{
	for(int i = 0; i < cats.size(); i++)
		if(cats[i]->id==field_id)
			return i;
	return -1;
}

// basis 
void Procview::addField(int Fid, int where)
{
//	int where=-1; 
//	where=pstable->clickedColumn();
	if( where ==0 )
	{	
       	//if (pstable->treeMode())  where=1;
	}

	if (Fid==F_CMDLINE)
		where=cats.size(); 	//always should be the last column
			
	if( where <0 ) {
			// possible?
			where=cats.size(); 
	}

	if(where> cats.size())
		where=1;

	if(treeview)
	{
		if(where==0) where=1;

	}

	Category *newcat = categories[Fid];
//	printf("name =%s\n",newcat->name);
	if (cats.indexOf(newcat)<0)  // if not in the list ****
		cats.insert(where,newcat); 
}


// add a category to last field
void Procview::addField(char *name)	// interface 
{
	//QString str=sl[i];
	int id = field_id_by_name(name);
	if(id>=0)
		addField(id); // add to last
	return;
	
	Category *cat = cat_by_name(name);
	if(cat)
		cats.append(cat);
}


void Procview::removeField(int field_id)
{
	for(int i = 0; i < cats.size();)
	{
		if(cats[i]->index==field_id)
		{
			cats.removeAt(i);
		}
		else 
			i++;
	}
	// printf("Fid=%d cats.size=%d\n",field_id,cats.size());
}

//	1.void Pstable::moveCol(int col, int place) 
//	DEL???
void Procview::update_customfield()
{
	int i;
	
	customfields.clear();	

	for(i=0;i<cats.size();i++)
		customfields.append(cats[i]->name);

	if(treeview) 
	{
		// recover COMMAND_FIELD
		//if(hasF_COMM)
		if(idxF_COMM>0)
		{
			/* if(customfields.size()<=idxF_COMM)
				customfields.append(categories[F_COMM]->name);
			else	*/
			customfields.insert(idxF_COMM,categories[F_COMM]->name);
		}
	}

	for(i=0;i<customfields.size();i++)
		custom_fields[i]=field_id_by_name(customfields[i].toAscii().data());
	//for(i=0;i<cats.size();i++)
	//	custom_fields[i]=cats[i]->index;
	custom_fields[i]=F_END; 

//	viewfields=Procview::CUSTOM;
}

// Description : FIELD movement by mouse drag 
//				  From col To place
void Procview::moveColumn(int col, int place) 
{
	int i;

	int f_size=cats.size();
	if( col < 0 or place <0 or f_size <= col or f_size<=place)
	{
		printf("QPS code bugs!! : moveColumn() col=%d place=%d cats.size=%d\n",col,place,cats.size());
		return;
	}

	//void Procview::fieldArrange()
	if( treeview==true )  
	{
		// *** important : COMMAND field should be the first field in TreeMode!
		if(place==0)	return;
		if(cats[col]->index==F_COMM) place=0; // *** important
	}
	
	// COMMAND_LINE field should always be the last field 
	//if(cats[place]->index==F_CMDLINE) return; 
	if(cats[col]->index==F_CMDLINE) place=cats.size() - 1;

	Category *cat = cats[col]; // Danger!

	cats.insert(place,cat); //first  insert 
	if(place<col) col++;
	cats.removeAt(col);	 //second  remove idx

	// refresh();
	///update_customfield();
}


// always called when linear to tree 
void Procview::saveCOMMANDFIELD()
{
	if(idxF_COMM>0) return;
	hasF_COMM=false;
	idxF_COMM=-1;
	for(int i=0;i<cats.size();i++)
		if(cats[i]->id==F_COMM)
		{	
			printf("save1\n"); // why 2times?
			hasF_COMM=true;
			idxF_COMM=i;
		}
}
//QStringList 
// call by 
//	1.void Pstable::setTreeMode(bool treemode)
void Procview::fieldArrange()
{

	if(treeview) {
		saveCOMMANDFIELD();
		// Tree Mode 
		// If COMMAND isn't the leftmost column, move it to leftmost
		removeField(F_COMM);
		//cats.insert(0,allcats[F_COMM]);
		cats.insert(0,categories[F_COMM]);
		
		// PID sort for convenience (default)  
		for(int i = 0; i < cats.size(); i++)
			if( cats[i]->index == F_PID ) 
			{
				reversed = FALSE;
				sortcat = cats[i];
				//// pstable->setSortedCol(i);   
			}
	} 
	else	
	{
		
		//Linear_Mode:
		removeField(F_COMM);
		//removeField(F_PID);cats.insert(0,allcats[F_PID]);
		//recover COMMAND FIELD

		//if(hasF_COMM)
		if(idxF_COMM>0)
		{
			//printf("savek\n");
			addField(F_COMM,idxF_COMM);
		}	

		if(0)
		for(int i = 0; i < cats.size(); i++) /// CAUSE SEGFAULT !!! ???
		{
			if( cats[i]->index == F_CPU ) 
			{
				reversed = FALSE;
				sortcat = cats[i];
				////pstable->setSortedCol(i);
			}
		}
	}
	
}

Category *Procview::static_sortcat = 0;

int Procview::compare(Procinfo *const *a, Procinfo *const *b)
{
	if(static_sortcat==0)	return 0;
	int r = static_sortcat->compare(*a, *b);
	return (r == 0) ? ((*a)->pid > (*b)->pid ? 1 : -1) : r;
}

int Procview::compare_backwards(Procinfo *const *a, Procinfo *const *b)
{
	if(static_sortcat==0)	return 0;
	int r = static_sortcat->compare(*b, *a);
	return (r == 0) ? ((*b)->pid > (*a)->pid ? 1 : -1) : r;
}

