// command.h				emacs, this is written in -*-c++-*-
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#ifndef COMMAND_H
#define COMMAND_H

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qdialog.h>
#include <qcheckbox.h>
#include <qtoolbutton.h>

#include <QListView>

#include "proc.h"
#include "misc.h"
		   
int find_command(QString s);
void add_default_command();

class CommandButton : public QToolButton
{
	Q_OBJECT
	public:
		CommandButton(QWidget *parent,QString name):QToolButton(parent)
		{
			cname=name;
		}; 
		QString cname;	

	protected slots:
		void	exec_command();
		
};


class Command {
	public:
		Command(QString n, QString cmd,bool toolbar=false);
		~Command();			
		void call(Procinfo *p);
		bool IsNeedProc(); 
		
		CommandButton *toolbutton;

		QString name;			// appears in the menu
		QString cmdline;		// may contain variables (%p etc)
		int menu;			// index in menu
		bool toolbar;
		bool popup;
};


class CommandModel : public QAbstractItemModel
{
    Q_OBJECT
public:
    CommandModel(QObject *parent = 0);
    ~CommandModel();
    QModelIndex index(int row, int column, const QModelIndex &parent) const;
    QModelIndex parent(const QModelIndex &child) const;
    int rowCount(const QModelIndex &parent) const;
    int columnCount(const QModelIndex &parent) const{return 1;};
    QVariant data(const QModelIndex &index, int role) const;
//  Qt::ItemFlags flags(const QModelIndex &index) const;
	void update(); //TEMP
};

//class CommandDialog : public QWidget
class CommandDialog : public QDialog
{
    Q_OBJECT
public:
    CommandDialog();

signals:
    void command_change();

protected slots:
    void new_cmd();
    void add_new();
    void del_current();
    void set_buttons(int);
	void reset();
    void set_select( const QModelIndex & );
    void event_name_midified(const QString &new_name);
    void event_cmd_modified();
    void event_toolbar_checked(bool);
private:
    QListView *lb; //Q3ListBox *lb;
    QPushButton *new0,*add, *del, *edit,*button_ok;
    QLineEdit *name, *cmdline;
    QCheckBox *qcheck1;
    QCheckBox *qcheck2;
};


#include <QProcess>
#include "ui_message.h"
class MessageWindow : public QWidget ,private Ui_Form
{
    Q_OBJECT
public:
	MessageWindow();
	MessageWindow(QString str,QString cmd);
	void 	setText(QString str);
	QProcess *pr;
	QString	command;
protected slots:
	void  	cmd_started();
	void 	cmd_finished ( int exitCode, QProcess::ExitStatus exitStatus );
	void 	cmd_error ( QProcess::ProcessError error );
	void  	cmd_ok();
};


#include "ui_eventdialog.h"
class WatchdogDialog : public QDialog ,private Ui_EventDialog
{
    Q_OBJECT
public:
    WatchdogDialog();
//signals:
//    void command_change();

protected slots:
    void _new();
    void apply();
	void add();
	void del();
	void condchanged(const QString &str);
	void comboChanged(int );
	void eventcat_slected(const QModelIndex &idx);
  //  void set_select( const QModelIndex & );
  //  void event_name_midified(const QString &new_name);
  //  void event_cmd_modified();
   // void event_toolbar_checked(bool);
private:
};


class ListModel : public QAbstractItemModel
{
    Q_OBJECT
public:
    ListModel(QObject *parent = 0){};
    ~ListModel(){};
    QModelIndex index(int row, int column, const QModelIndex &parent) const; //pure
    QModelIndex parent(const QModelIndex &child) const; //pure virtual
    int rowCount(const QModelIndex &parent) const; 
    int columnCount(const QModelIndex &parent) const{return 1;};
    QVariant data(const QModelIndex &index, int role) const;
//  Qt::ItemFlags flags(const QModelIndex &index) const;
//	void update(); //TEMP
};

#define WATCH_PROCESS_START		0
#define WATCH_PROCESS_FINISH	1
#define WATCH_SYS_CPU_OVER		2
#define WATCH_SYS_CPU_UNDER		3

//#define WATCH_PROCESS_CPU		3
//#define WATCH_PROCESS			0

// if process [name] start, exec [command], showmsg [xxx]
// if process [name] finish exec [command], showmsg [xxx]
// if system cpu over [90%], exec [command], msg [xxx]
// if system cpu under [10%], exec [command], msg [xxx]
// if process [name] cpu over [90%] exec [command] msg [xxx]
// if process [name] start, kill_it, msg [xxx]
// if process [name] start, soundplay [ ], msg [xxx]

class watchCond
{
	public:
	int cond;
	int enable;
	QString procname, command, message;
	int	 cpu;
	//int 
	char buff[128];
	QString string;
	watchCond()
	{ 
		enable=0;
	//	procname[0]=0;		command[0]=0;		message[0]=0;
	}
	// key [txt]	[a]
	//QString getVal(QString &str, QString &key)
	QString getVal(QString &str, char *key)
	{
		int n;//key.length();
		int idx=str.indexOf(key);
		if(idx<0) return "cant' found";
		
		idx=str.indexOf("[",idx);
		if(idx<0) return "[ error";
		int idx_end=str.indexOf("]",idx);
		if(idx_end<0) return "] error";
		n=idx_end-idx;
		return str.mid(idx+1,n-1);
	}
	QString getstring()
	{ 
		string.clear();
		switch(cond)
		{
			case WATCH_PROCESS_FINISH:
				string.append("if process [" +procname+"] finish, ");
				//string=string.sprintf("if process [%s] finish",procname);
				break;
			case WATCH_PROCESS_START:
				string.append("if process [" +procname+"] start, ");
				break;
			case WATCH_SYS_CPU_OVER :
				string.append("if sys_cpu over ["+ QString::number (cpu)+"], ");
			case WATCH_SYS_CPU_UNDER :
				string.append("if sys_cpu under ["+QString::number (cpu)+"], ");
				break;
			default:;
		}
		if(!command.isEmpty())
		string.append("exec [" + command + "] ");
		if(!message.isEmpty())
		string.append("showmsg [" + message + "] ");

	//	printf("aaa\n");
		return string;
	}
	void putstring(QString str)
	{
		if(str.contains("if process"))
		{
			if(str.contains("start"))
				cond=WATCH_PROCESS_START;
			if(str.contains("finish"))
				cond=WATCH_PROCESS_FINISH;
			procname=getVal(str,"if process");
		}
		if(str.contains("exec"))
			command=getVal(str,"exec");
		if(str.contains("showmsg"))
			message=getVal(str,"showmsg");

	}
};
#endif // COMMAND_H

