// infobar.h				emacs, this is written in -*-c++-*-
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#ifndef INFOBAR_H
#define INFOBAR_H

#ifndef USING_PCH 
#include <QString>
#include <QPixmap>
#include <QResizeEvent>
#include <QFrame>
#include <QEvent>
#include <QMouseEvent>
#endif 


class CPUbar : public QWidget
{
    Q_OBJECT
public:
    CPUbar(QWidget *parent);
    void refresh();
 //   void update_load();
 //   void show_and_hide(bool, QWidget *, QWidget *);
//signals:  void config_change();
protected:
	void paintEvent ( QPaintEvent * );
	void mousePressEvent(QMouseEvent *);
private:
//	List<gwidget*>  wlist;
	QWidget *parent;
    bool is_vertical;
};

class gwidget {
	public:
		gwidget(){x=0,y=0,width=0,height=0;		};
		gwidget(QWidget *p){parent=p;};
		virtual void draw(QPainter *p){printf("gwidget\n");};
		virtual void setPosition(int parent_width,int parent_height){};
		virtual char *info(){ return NULL; };
		void setParent(QWidget *p){parent=p;};
		void resize(int x_,int y_,int w,int h)
		{ x=x_;y=y_;width=w;height=h;};
		bool  intersect(int cx,int cy)
		{	
			cx = cx - x;
			cy = cy - y;
			if ( cx > 0 and cx < width)
				if ( cy > 0 and cy < height)
					return true;
			return false;
		}


		int  xpluswidth(){return x+width;};
	protected:
		int x;
		int y;
		int width;
		int height;
		QRect rect;
		QWidget *parent;
};




class Infobar : public QFrame
{
    Q_OBJECT
public:
    //Infobar(QWidget *parent, int history_size);
    ~Infobar();

    void configure();		// respond to configuration change

    QPixmap *make_icon(int w, int h);
  
  	//
  	Infobar(QWidget *parent);
    void refresh();
    void update_load();
	void drawPixmap();
    QPixmap *load_icon(int w, int h) { return make_icon(w, h); }
    bool swaplim_exceeded();
    void show_and_hide(bool, QWidget *, QWidget *);
    void showup();
signals:
    void clicked();
    void config_change();

protected:
    void paintEvent ( QPaintEvent * );
    void mousePressEvent(QMouseEvent *);
    void mouseMoveEvent(QMouseEvent *);
    void leaveEvent ( QEvent * );
	void hideEvent ( QHideEvent * event );
	void resizeEvent ( QResizeEvent * e );

    void add_history_point(unsigned value);
    void add_history_point2(float value);
    void make_graph(int w, int h, QPainter *p);
private:
    
	QList<gwidget*>  wlist;
    int hist_size;	// history buffer size
    int npoints;		// nr of history points currently remembered
    // history points are stored in fixed point, scaled by history_scale
    static const unsigned history_scale = 256;
    static const int time_dist = 60; // time between vertical lines (seconds)
    float *history;		// (circular) history buffer
    int h_index;		// next history index to use
    float peak;			// largest value in history
   
    bool dirty;			// history changed since pixmap was drawn
    QPixmap pixmap;
    QPixmap icon_pm;
	
	int px,py; //	pointer position 

    bool is_vertical;
	int official_hegiht;
};


#endif	// INFOBAR_H
