#ifndef MISC_H
#define MISC_H

#ifndef USING_PCH
#include <QAbstractButton> 
#include <QCheckBox>
#include <QRadioButton> 
#include <QStatusBar>
#include <QPainter>

#include <QLineEdit>
#include <QComboBox> 
#include <QTextEdit>
#include <QToolButton>

#include <QTimerEvent>
#include <QKeyEvent>
#include <QBoxLayout> 
#include <QHBoxLayout>
#include <QAbstractButton>
#include <QTimerEvent>
#include <QKeyEvent>
#include <QLabel>
#include <QPixmap>
#include <QFrame>
#include <QResizeEvent>
#include <QMenu>
#include <QMouseEvent>
#endif 


char*	userName(int uid,int euid);
char*	groupName(int gid,int egid);

void	setQpsTheme();
int		get_kernel_version();

int 	fsize(char *fname);
void 	msleep(long msec);
void 	mem_string(int kbytes, char *buf);

void 	init_xpm();
void 	init_misc(QWidget *main);
int 	pf_write(QPainter *p,int x,int y,const char *str);
int  	pf_str_width(char *str);
int  	pf_char_height();


class CrossBox : public QCheckBox
{
public:
    CrossBox(const char *text, QWidget *parent);

protected:
    virtual void drawButton(QPainter *paint);
};

class CheckMenu : public QMenu
{
public:
    CheckMenu(QWidget *parent = 0);

};


class TFrame : public QFrame
{
	Q_OBJECT
	public:
		TFrame(QWidget *parent);
		void setText(QString str);
		void draw( QPainter &p );

	protected slots:
//    		void refresh();
//  		void update(int n);
//		QToolButton *button,*button2,*button3;
//		void event_cursor_moved(QMouseEvent *e);
	protected :
		virtual void paintEvent(  QPaintEvent * event ); 
	private:
		QString text;
};



class XButton : public QAbstractButton
{
	Q_OBJECT
	public:
		XButton(QWidget *parent);
	protected slots:
//    		void refresh();
//  		void update(int n);
//		QToolButton *button,*button2,*button3;
//		void event_cursor_moved(QMouseEvent *e);
	protected :
		//virtual void drawButton 3( QPainter * ) ;
		virtual void paintEvent(  QPaintEvent * event ); 
		void resizeEvent(QResizeEvent *p);
};




class SearchBox : public QLineEdit
{
	Q_OBJECT
	public:
		SearchBox(QWidget *parent);
		void event_cursor_moved(QMouseEvent *e);
		void keyPressEvent(QKeyEvent * e );
	protected slots:
		void event_xbutton_clicked();
//    		void refresh();
//  		void update(int n);
//		QToolButton *button,*button2,*button3;
	protected:
		void resizeEvent(QResizeEvent *);
 		void timerEvent(QTimerEvent * );
		int left_time;
		XButton *xb;
};

class LogBox : public QLabel
{
	Q_OBJECT
	public:
		LogBox(QWidget *w);
		QTextEdit *text;
	//QLabel *label,*label2,*label3;
};


class StatusBar : public QStatusBar
{
	Q_OBJECT
	public:
		StatusBar(QWidget *parent);
    		void refresh();
    		void update(int n);
		QLabel *label,*label2,*label3;

};


class ControlBar : public QFrame
{
	Q_OBJECT
	public:
		QComboBox *view;
		ControlBar(QWidget *parent);
		void setMode(bool treemode);
		void update_bar();
     	QToolButton *pauseButton;

	signals:
		void modeChange(bool treemode);
		void viewChange(QAction*);
		void need_refresh();

	public slots:
		void linear_clicked();
		void view_changed(int idx);
		void tree_clicked();
		void show_thread_clicked();
		void event_search_box_changed();
		void event_command_pressed();
		void setPaused(bool);
		
//	protected:
//		void resizeEvent(QResizeEvent *);
		

	private:
		QRadioButton *b_tree, *b_linear, *b_treeT;
		QCheckBox    *check_thread;
		QBoxLayout 	*layout ;
};

#endif	// MISC_H
