/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component.impl.uicreator;

import java.io.File;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.impl.ComponentBase;
import tle.framework.component.impl.uicreator.DefaultUICreatorMBean;
import tle.framework.component.impl.uicreator.client.ClientType;
import tle.framework.component.impl.uicreator.config.CommandConfig;
import tle.framework.component.impl.uicreator.config.UIConfiguration;
import tle.framework.component.impl.uicreator.config.UIConfigurationDigester;
import tle.framework.component.impl.uicreator.config.ViewConfig;
import tle.framework.component.impl.uicreator.config.ViewSetConfig;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.component.spi.rp.Result;
import tle.framework.component.spi.uicreator.UICreator;
import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

public class DefaultUICreator
extends ComponentBase
implements UICreator,
DefaultUICreatorMBean {
    public static final String VIEW_CONFIG_ATTRIBUTE_NAME = "DefaultUICreator.ViewConfig";
    private UIConfiguration uiConfig;
    private String configFile;

    protected void initing(ComponentConfig config) throws ComponentException {
        String configFilePath = config.getInitParameter("configFile");
        if (configFilePath == null) {
            configFilePath = System.getProperty("user.home") + File.separator + "DefaultUICreator.xml";
        }
        this.configFile = configFilePath;
        try {
            this.initConfiguration();
        }
        catch (Throwable e) {
            Logger.fatal("DefaultUICreator.initing():Configuration File Loading Error", e);
            throw new ComponentException(e.getMessage(), e);
        }
    }

    public void createView(Result result, HttpServletRequest request, HttpServletResponse response) throws ComponentException {
        ViewConfig viewConfig;
        CommandConfig commandConfig = this.uiConfig.getCommandConfig(result.getCommandID());
        if (commandConfig == null) {
            throw new ComponentException("Not Matching UI CommandConfig for command:" + result.getCommandID());
        }
        String resultViewID = commandConfig.getResultViewID(result.getCode());
        ViewSetConfig viewSet = null;
        int viewSetDilimeter = resultViewID.indexOf(":");
        String realResultViewID = null;
        if (viewSetDilimeter > 0 && viewSetDilimeter != resultViewID.length() - 1) {
            String viewSetID = resultViewID.substring(0, viewSetDilimeter);
            viewSet = this.uiConfig.getViewSetConfig(viewSetID);
            realResultViewID = resultViewID.substring(viewSetDilimeter + 1);
        } else {
            realResultViewID = resultViewID;
        }
        if (viewSet == null) {
            viewSet = this.getViewSetConfig(request);
        }
        if ((viewConfig = viewSet.getViewConfig(realResultViewID)) == null) {
            throw new ComponentException("Not Matching UI ViewConfig for [COMMAND ID,RESULT CODE, VIEW_SET, VIEW_ID]:[" + result.getCommandID() + "," + result.getCode() + "," + viewSet.getViewSetID() + "," + resultViewID + "]");
        }
        request.setAttribute("result", (Object)result);
        try {
            this.forward(viewConfig, request, response);
        }
        catch (ServletException e) {
            throw new ComponentException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ComponentException(e.getMessage(), e);
        }
    }

    public void createAuthenticationForm(HttpServletRequest request, HttpServletResponse response) throws ComponentException {
        ViewSetConfig viewSet = this.getViewSetConfig(request);
        ViewConfig viewConfig = viewSet.getAuthFormViewConfig();
        try {
            this.forward(viewConfig, request, response);
        }
        catch (ServletException e) {
            throw new ComponentException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ComponentException(e.getMessage(), e);
        }
    }

    public void createNoAuthorizationView(RequestInfo ri, HttpServletRequest request, HttpServletResponse response) throws ComponentException {
        ViewSetConfig viewSet = this.getViewSetConfig(request);
        ViewConfig viewConfig = viewSet.getNoAuthViewConfig();
        try {
            this.forward(viewConfig, request, response);
        }
        catch (ServletException e) {
            throw new ComponentException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ComponentException(e.getMessage(), e);
        }
    }

    public void createErrorView(Result result, HttpServletRequest request, HttpServletResponse response) throws ComponentException {
        ViewSetConfig viewSet = this.getViewSetConfig(request);
        ViewConfig viewConfig = viewSet.getErrorViewConfig();
        request.setAttribute("result", (Object)result);
        if (result.isErrorOccured() && result.getException() != null) {
            request.setAttribute("javax.servlet.error.exception", (Object)result.getException());
            request.setAttribute("javax.servlet.jsp.jspException", (Object)result.getException());
        }
        try {
            this.forward(viewConfig, request, response);
        }
        catch (ServletException e) {
            throw new ComponentException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ComponentException(e.getMessage(), e);
        }
    }

    public void createErrorView(Throwable exception, HttpServletRequest request, HttpServletResponse response) throws ComponentException {
        ViewSetConfig viewSet = this.getViewSetConfig(request);
        ViewConfig viewConfig = viewSet.getErrorViewConfig();
        request.setAttribute("javax.servlet.error.exception", (Object)exception);
        request.setAttribute("javax.servlet.jsp.jspException", (Object)exception);
        try {
            this.forward(viewConfig, request, response);
        }
        catch (ServletException e) {
            throw new ComponentException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ComponentException(e.getMessage(), e);
        }
    }

    private ViewSetConfig getViewSetConfig(HttpServletRequest request) {
        String clientType = ClientType.getClientType(request);
        return this.uiConfig.getClientViewSetConfig(clientType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void forward(ViewConfig viewConfig, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ComponentException {
        if (viewConfig.isRedirect()) {
            if (viewConfig.getPage() == null) throw new ComponentException("Redirect view's page cannot be null:" + viewConfig.getViewID());
            int idx = viewConfig.getPage().indexOf("{context.path}");
            if (idx == 0) {
                response.sendRedirect(request.getContextPath() + viewConfig.getPage().substring(14));
                return;
            } else {
                response.sendRedirect(viewConfig.getPage());
            }
            return;
        } else {
            request.setAttribute(VIEW_CONFIG_ATTRIBUTE_NAME, (Object)viewConfig);
            RequestDispatcher dispatcher = request.getRequestDispatcher(viewConfig.getRelatedPage());
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public String getConfigFile() {
        return this.configFile;
    }

    private void initConfiguration() throws Throwable {
        this.uiConfig = UIConfigurationDigester.create(TLEConfigPathUtil.replace(this.configFile));
    }

    public void reloadConfiguration() throws ComponentException {
        try {
            this.initConfiguration();
        }
        catch (Throwable e) {
            Logger.fatal("DefaultUICreator.reloadConfiguration():Configuration File Loading Error", e);
            throw new ComponentException(e.getMessage(), e);
        }
    }
}

