/*
 * Ʈ: TLE2Framework
 * ϸ: CommandHandlerClassLoader.java
 * ۼ: 2004. 10. 25
 */
package tle.framework.component.impl.rp.handler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

/**
 * ڵ鷯 Ŭ  Ŭн ġϴ 
 * ڵ鷯 Ŭ εϱ  Ǵ Ŭδ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class CommandHandlerClassLoader extends ClassLoader {
	/**
	 * ڵ鷯 Ŭ εϴ Ŭδ
	 */
	private URLClassLoader classLoader;
	
	/**
	 * classLoader ϴ Ŭн Ѵ.
	 */
	private String[] classPath;
	
	/**
	 * @param classPath ڵ鷯 Ŭ    Ŭ н 
	 */
	public CommandHandlerClassLoader(String[] classPath) {
		super(CommandHandlerClassLoader.class.getClassLoader());
		this.classPath = classPath;
		initClassLoader();
	}
	
	/**
	 * Ŭδ ʱȭѴ.
	 */
	private void initClassLoader() {
		URL[] urls = new URL[classPath.length];
		for (int i = 0 ; i < urls.length ; i++) {
			File file = new File(TLEConfigPathUtil.replace(classPath[i]));
			try {
				urls[i] = file.toURL();
			} catch (MalformedURLException e) {
				Logger.warn(e.getMessage(), e);
			}
		}
		classLoader = new URLClassLoader(urls, this);
	}
	
	/**
	 * Ŭδ  ؼ Ŭ ٽ о ȿ .
	 */
	public void remakeClassLoader() {
		initClassLoader();
	}
	
	
	
	/**
	 * ڵ鷯 Ŭ εѴ.
	 * 
	 * @param className ڵ鷯 Ŭ ̸
	 * @return ε ڵ鷯 Ŭ
	 * @throws ClassNotFoundException
	 */
	public Class loadHandlerClass(String className) throws ClassNotFoundException {
		return classLoader.loadClass(className);
	}
}
