/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component;

import tle.framework.util.statemachine.State;
import tle.framework.util.statemachine.StateMachine;

public class ComponentState {
    public static final String CREATE_EVENT = "create";
    public static final String INIT_EVENT = "init";
    public static final String START_EVENT = "start";
    public static final String STOP_EVENT = "stop";
    public static final String CLOSE_EVENT = "close";
    public static final String SUSPEND_EVENT = "suspend";
    public static final String RESUME_EVENT = "resume";
    public static final String COMPLETE_EVENT = "complete";
    public static final String ERROR_EVENT = "error";
    private static State NOT_CREATED = new StateMachine.StartState();
    private static State CREATED = new State("CREATED", new Integer(1));
    private static State INITING = new State("INITING", new Integer(2));
    private static State INITED = new State("INITED", new Integer(4));
    private static State STARTING = new State("STARTING", new Integer(8));
    private static State RUNNING = new State("STARTED", new Integer(16));
    private static State STOPPING = new State("STOPPING", new Integer(32));
    private static State STOPPED = new State("STOPPED", new Integer(64));
    private static State CLOSING = new State("CLOSING", new Integer(128));
    private static State SUSPENDING = new State("SUSPENDING", new Integer(256));
    private static State SUSPENDED = new State("SUSPENDED", new Integer(512));
    private static State RESUMING = new State("RESUMING", new Integer(1024));
    private static State CLOSED = new StateMachine.FinishState("CLOSED");
    private static State ERROROCCURED = new State("ERROROCCURED", new Integer(4096));
    private StateMachine sm = new StateMachine(NOT_CREATED);

    public void event(String event) throws IllegalStateException {
        this.sm.transit(event);
    }

    public State getCurrentState() {
        return this.sm.getCurrentState();
    }

    public boolean isNotCreated() {
        return this.sm.getCurrentState() == NOT_CREATED;
    }

    public boolean isCreated() {
        return this.sm.getCurrentState() == CREATED;
    }

    public boolean isIniting() {
        return this.sm.getCurrentState() == INITING;
    }

    public boolean isInited() {
        return this.sm.getCurrentState() == INITED;
    }

    public boolean isStarting() {
        return this.sm.getCurrentState() == STARTING;
    }

    public boolean isRunning() {
        return this.sm.getCurrentState() == RUNNING;
    }

    public boolean isSuspending() {
        return this.sm.getCurrentState() == SUSPENDING;
    }

    public boolean isSuspended() {
        return this.sm.getCurrentState() == SUSPENDED;
    }

    public boolean isResuming() {
        return this.sm.getCurrentState() == RESUMING;
    }

    public boolean isStopping() {
        return this.sm.getCurrentState() == STOPPING;
    }

    public boolean isStopped() {
        return this.sm.getCurrentState() == STOPPED;
    }

    public boolean isClosing() {
        return this.sm.getCurrentState() == CLOSING;
    }

    public boolean isClosed() {
        return this.sm.getCurrentState() == CLOSED;
    }

    public boolean isErrorOccured() {
        return this.sm.getCurrentState() == ERROROCCURED;
    }

    static {
        NOT_CREATED.addEvent(CREATE_EVENT, CREATED);
        CREATED.addEvent(INIT_EVENT, INITING);
        INITING.addEvent(COMPLETE_EVENT, INITED);
        INITED.addEvent(START_EVENT, STARTING);
        STARTING.addEvent(COMPLETE_EVENT, RUNNING);
        RUNNING.addEvent(STOP_EVENT, STOPPING);
        STOPPING.addEvent(COMPLETE_EVENT, STOPPED);
        STOPPED.addEvent(CLOSE_EVENT, CLOSING);
        CLOSING.addEvent(COMPLETE_EVENT, CLOSED);
        RUNNING.addEvent(SUSPEND_EVENT, SUSPENDING);
        SUSPENDING.addEvent(COMPLETE_EVENT, SUSPENDED);
        SUSPENDED.addEvent(RESUME_EVENT, RESUMING);
        RESUMING.addEvent(COMPLETE_EVENT, RUNNING);
        SUSPENDING.addEvent(STOP_EVENT, STOPPING);
        INITING.addEvent(ERROR_EVENT, ERROROCCURED);
        STARTING.addEvent(ERROR_EVENT, ERROROCCURED);
        STOPPING.addEvent(ERROR_EVENT, ERROROCCURED);
        CLOSING.addEvent(ERROR_EVENT, ERROROCCURED);
        SUSPENDING.addEvent(ERROR_EVENT, ERROROCCURED);
        RESUMING.addEvent(ERROR_EVENT, ERROROCCURED);
        ERROROCCURED.addEvent(COMPLETE_EVENT, CLOSED);
    }
}

