/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.util.statemachine;

import tle.framework.util.statemachine.State;

public class StateMachine {
    private State currentState = null;

    public StateMachine(State startState) {
        this.currentState = startState;
    }

    public boolean isStartState() {
        return this.currentState instanceof StartState;
    }

    public boolean isFinalState() {
        return this.currentState instanceof FinishState;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public void transit(String event) {
        this.currentState = this.currentState.transit(event);
    }

    public static class FinishState
    extends State {
        public FinishState(String finalName) {
            super(finalName);
        }

        public FinishState() {
            super("FINISH");
        }

        public void addEvent(String event, State state) {
            throw new UnsupportedOperationException();
        }

        public State transit(String event) {
            throw new IllegalStateException(this.getStateName() + " State can't transfer to any state.");
        }
    }

    public static class StartState
    extends State {
        public StartState(String stateName) {
            super(stateName);
        }

        public StartState() {
            super("START");
        }
    }
}

