/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultRPConfigurationDigesterTest.java
 * ۼ: 2004. 10. 25
 */
package test.tle.framework.component.impl.rp.config;

import java.io.IOException;
import java.util.Map;

import org.xml.sax.SAXException;

import tle.framework.component.impl.rp.config.DefaultRPConfiguration;
import tle.framework.component.impl.rp.config.DefaultRPConfigurationDigester;

import junit.framework.TestCase;

/**
 * DefaultRPConfigurationDigester ׽Ʈ Ŭ
 * 
 * @author ֹ
 * @since 2.0
 */
public class DefaultRPConfigurationDigesterTest extends TestCase {
	public void testCreate() throws IOException, SAXException {
		DefaultRPConfiguration config = DefaultRPConfigurationDigester.create("c:/eclipse/workspace/TLE2Framework/config/DefaultRequestProcessor.xml");
		assertEquals(true, config.isUsingIndependentClassPath());
		assertEquals(3, config.getClassPathArray().length);
		
		java.util.HashMap classPathMap = new java.util.HashMap();
		classPathMap.put("c:\\temp\\classes", "true");
		classPathMap.put("d:\\command\\handler\\classes", "true");
		classPathMap.put("a:\\common.jar", "true");
		
		for (int i = 0 ; i < config.getClassPathArray().length ; i++) {
			assertTrue(classPathMap.containsKey(config.getClassPathArray()[i]));
		}
		
		Map handlerMap = config.getHandlerClassMap();
		assertEquals("tle.board.command.Board", handlerMap.get("board"));
		assertEquals("tle.board.command.PDS", handlerMap.get("pds"));
		assertEquals("tle.board.command.Guest", handlerMap.get("guest"));
		
		Map jspHandlerMap = config.getHandlerJspMap();
		assertEquals("/handler/list.jsp", jspHandlerMap.get("list"));
		
		Map commandHandlerMap = config.getCommandHandlerMap();
		assertEquals(commandHandlerMap.get("/board/write"), "board");
		assertEquals(commandHandlerMap.get("/board/read"), "board");
		assertEquals(commandHandlerMap.get("/guest/list"), "guest");
		assertEquals(commandHandlerMap.get("/loginForm"), "default.GOVIEW");
		
		assertEquals(0x02, config.getDefaultHandlerType());
	}
}
