/*
 * Ʈ: TLE2Framework
 * ϸ: RoleManagerConfigurationDigester.java
 * ۼ: 2004. 11. 10
 */
package tle.framework.component.impl.aamanager.role;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.SAXException;

/**
 *  Ϸκ RoleManagerConfiguration Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class RoleManagerConfigurationDigester {
	private static Digester digester = null;
	
	public static RoleManagerConfiguration create(String filePath) throws IOException, SAXException {
		if (digester == null) {
			RoleManagerConfigurationDigester.initDigester();
		}
		File configFile = new File(filePath);
		RoleManagerConfiguration configuration = (RoleManagerConfiguration)digester.parse(configFile);
		return configuration;
	}
	
	private static void initDigester() {
		synchronized(RoleManagerConfigurationDigester.class) {
			if (digester == null) {
				URL ruleXml = RoleManagerConfigurationDigester.class.getClassLoader().getResource("tle/framework/component/impl/aamanager/role/RoleManagerConfiguration.rule.xml");
				digester = DigesterLoader.createDigester(ruleXml);
			}
		}
	}

}
