/*
 * Ʈ: TLE2Framework
 * ϸ: CommandHandlerFactory.java
 * ۼ: 2004. 10. 22
 */
package tle.framework.component.impl.rp.handler;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

import tle.framework.component.impl.rp.config.DefaultRPConfiguration;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.log.Logger;

/**
 * RequestInfo ˸ CommandHandler ִ 丮.
 * 
 * @author ֹ
 * @since 2.0
 */
public class CommandHandlerFactory {
	
	private CommandHandlerClassLoader commandHandlerClassLoader;
	/**
	 * initHandlerInstance ޼ҵ忡  Map Ҵ
	 */
	private Map handlerMap;
	private Map commandHandlerMap;
	private CommandHandler defaultHandler = null;
	
	/**
	 * DefaultRPConfiguration &lt;ڵ鷯ID, ڵ鷯Ŭ>   о
	 * ڵ鷯 Ŭ νϽ Ѵ.
	 * <p>
	 *  Ŭ δ   CommandHandlerClassLoader  Ͽ 
	 * Ŭ νϽ Ѵ.
	 */
	public CommandHandlerFactory(DefaultRPConfiguration configuration) {
		if (configuration.isUsingIndependentClassPath()) {
			commandHandlerClassLoader = new CommandHandlerClassLoader(configuration.getClassPathArray());
		}
		init(configuration);
	}
	
	/**
	 * initHandler() ޼ҵ带 ȣϿ ڵ鷯  ϰ
	 * initCommandHandlerMapping() ޼ҵ带 ȣϿ ɾ ڵ鷯    ٽ Ѵ.
	 * 
	 * @param configuration  
	 */
	public void init(DefaultRPConfiguration configuration) {
		initHandler(configuration);
		initCommandHandlerMapping(configuration);
	}
	
	/**
	 * ڵ鷯 ʱȭϴ  ޼ҵ带 ȣѴ.
	 * 
	 * @param configuration  
	 */
	private void initHandler(DefaultRPConfiguration configuration) {
		initHandlerInstance(configuration);
		initDefaultHandler(configuration);
	}
	
	/**
	 * &lt;ڵ鷯ID, ڵ鷯νϽ>  ʱȭѴ.
	 * 
	 * @param configuration  
	 */
	private void initHandlerInstance(DefaultRPConfiguration configuration) {
		Map handlerMap = new java.util.HashMap();
		
		Map handlerClassMap = configuration.getHandlerClassMap();
		Iterator iter = handlerClassMap.keySet().iterator();
		while (iter.hasNext()) {
			String handlerID = (String)iter.next();
			String className = (String)handlerClassMap.get(handlerID);
			try {
				Class handlerClass = null;
				if (commandHandlerClassLoader != null) {
					handlerClass = commandHandlerClassLoader.loadHandlerClass(className); 
				} else {
					handlerClass = Class.forName(className);
				}
				CommandHandler handler = (CommandHandler)handlerClass.newInstance();
				handlerMap.put(handlerID, handler);
			} catch (ClassNotFoundException e) {
				Logger.warn("", e);
			} catch (InstantiationException e) {
				Logger.warn("", e);
			} catch (IllegalAccessException e) {
				Logger.warn("", e);
			} catch (ClassCastException e) {
				Logger.warn("", e);
			}
		}
		Map handlerJspMap = configuration.getHandlerJspMap();
		Iterator iterJsp = handlerJspMap.keySet().iterator();
		while(iterJsp.hasNext()) {
			String handlerID = (String)iterJsp.next();
			String jspPage = (String)handlerJspMap.get(handlerID);
			CommandHandler handler = new JSPCommandHandler(jspPage);
			handlerMap.put(handlerID, handler);
		}
		
		this.handlerMap = handlerMap;
	}
	
	/**
	 * ⺻ ڵ鷯 Ѵ.
	 * 
	 * @param configuration  
	 */
	private void initDefaultHandler(DefaultRPConfiguration configuration) {
		GoViewCommandHandler goViewHandler = new GoViewCommandHandler();
		NoHandlerCommandHandler noHandler = new NoHandlerCommandHandler();
		
		switch(configuration.getDefaultHandlerType()) {
			case DefaultRPConfiguration.DEFAULT_GOVIEW:
				defaultHandler = goViewHandler;
				break;
			case DefaultRPConfiguration.DEFAULT_NOHANDLER:
				defaultHandler = noHandler;
				break;
		}
		
		handlerMap.put("default.GOVIEW", goViewHandler);
		handlerMap.put("default.NOHANDLER", noHandler);
	}
	
	/**
	 * &lt;ɾID, ڵ鷯ID>   Ѵ.
	 * 
	 * @param configuration  
	 */
	private void initCommandHandlerMapping(DefaultRPConfiguration configuration) {
		commandHandlerMap = Collections.unmodifiableMap(configuration.getCommandHandlerMap());
	}
	
	/**
	 * û  ˸ CommandHandler Ѵ.
	 *  û  شϴ CommandHandler ٸ
	 * ⺻ڵ鷯 Ѵ. (⺻ ڵ鷯  Ͽ Ѵ.
	 * 
	 * @param requestInfo
	 * @return û  شϴ ɾ ڵ鷯
	 */
	public CommandHandler createCommandHandler(RequestInfo requestInfo) {
		String handlerID = (String)commandHandlerMap.get(requestInfo.getCommandID());
		CommandHandler handler = (CommandHandler)handlerMap.get(handlerID);
		if (handler == null) {
			return defaultHandler;
		}
		return handler;
	}
	
	/**
	 * ڵ鷯 Ŭ εѴ.
	 * <p>
	 * , CommandHandlerClassLoader Ŭδ ϴ 쿡 
	 * ڵ鷯 Ŭ ε ϴ.
	 * <p>
	 * ڵ鷯 Ŭ ε   Ŭδ Ӱ ϰ,
	 *  ڿ initHandler() ޼ҵ带 ȣѴ.
	 * 
	 * @param configuration  
	 * @throws UnsupportedOperationException ڵ鷯 ε  ʴ 쿡 ߻Ѵ.
	 */
	public void reloadHandlerClasses(DefaultRPConfiguration configuration) {
		if (this.commandHandlerClassLoader != null) {
			commandHandlerClassLoader.remakeClassLoader();
			initHandler(configuration);
		} else {
			throw new UnsupportedOperationException("ClassLoader != CommandHandlerClassLoader");
		}
	}
}
