/*
 * Decompiled with CFR 0.152.
 */
package tle.framework;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import tle.framework.component.Component;
import tle.framework.component.ComponentAleadyExistsException;
import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentCreationException;
import tle.framework.component.ComponentException;
import tle.framework.component.ComponentNotFoundException;
import tle.framework.jmx.MBeanServerWrapper;
import tle.framework.log.Logger;

public class ComponentManager {
    private static ComponentManager instance = new ComponentManager();
    private Map componentMap = new HashMap();

    static ComponentManager getInstance() {
        return instance;
    }

    private ComponentManager() {
    }

    Component getComponent(String componentID) throws ComponentNotFoundException {
        Component component = (Component)this.componentMap.get(componentID);
        if (component == null) {
            throw new ComponentNotFoundException("Not Found Component:" + componentID);
        }
        return component;
    }

    void registComponent(Component component, ComponentConfig config) throws ComponentException {
        try {
            if (component.isCreated()) {
                component.init(config);
                Logger.info("ComponentManager.registComponent():Component Inited :" + component.getID());
            }
            if (component.isInited()) {
                component.start();
                Logger.info("ComponentManager.registComponent():Component Running:" + component.getID());
            }
            MBeanServerWrapper.getInstance().registComponent(component);
            this.componentMap.put(component.getID(), component);
            Logger.info("ComponentManager.registComponent():Component Registered:" + component.getID());
        }
        catch (InstanceAlreadyExistsException e) {
            throw new ComponentAleadyExistsException(e.getMessage(), e);
        }
        catch (MBeanRegistrationException e) {
            throw new ComponentException(e.getMessage(), e);
        }
        catch (NotCompliantMBeanException e) {
            throw new ComponentCreationException(e.getMessage(), e);
        }
        catch (MalformedObjectNameException e) {
            throw new ComponentCreationException(e.getMessage(), e);
        }
    }

    void registComponent(ComponentConfig config) throws ComponentException {
        String className = config.getComponentClass();
        try {
            Class<?> componentClass = Class.forName(className);
            Component component = (Component)componentClass.newInstance();
            Logger.info("ComponentManager.registComponent():Component Created:" + config.getComponentID());
            this.registComponent(component, config);
        }
        catch (ClassNotFoundException e) {
            throw new ComponentCreationException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new ComponentCreationException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ComponentCreationException(e.getMessage(), e);
        }
    }

    void unregistComponent(String componentID) throws ComponentException {
        Component component = (Component)this.componentMap.get(componentID);
        try {
            if (component.isRunning() || component.isSuspended()) {
                component.stop();
                Logger.info("ComponentManager.unregistComponent():Component Stopped:" + component.getID());
            }
            if (component.isStopped()) {
                component.close();
                Logger.info("ComponentManager.unregistComponent():Component Closed :" + component.getID());
            }
            MBeanServerWrapper.getInstance().unregistComponent(component);
            this.componentMap.remove(componentID);
            Logger.info("ComponentManager.unregistComponent():Component Removed:" + componentID);
        }
        catch (InstanceNotFoundException e) {
            throw new ComponentNotFoundException(e.getMessage(), e);
        }
        catch (MBeanRegistrationException e) {
            throw new ComponentException(e.getMessage(), e);
        }
    }

    void unregistAllComponent() {
        Iterator iter = this.componentMap.keySet().iterator();
        while (iter.hasNext()) {
            String componentID = (String)iter.next();
            try {
                this.unregistComponent(componentID);
            }
            catch (ComponentException e) {
                Logger.error("ComponentManager.unregistAllComponent():Fail to unregist Component:" + componentID, e);
            }
        }
    }
}

