/*
 * Ʈ: TLE2Framework
 * ϸ: RequestInfo.java
 * ۼ: 2004. 10. 12.
 */
package tle.framework.component.spi.ra;

import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Ŭ̾Ʈ û  Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public interface RequestInfo {
	/**
	 * ɾ ID Ѵ.
	 * 
	 * @return ɾ ID
	 */
	public String getCommandID();

	/**
	 * Ķ  Ѵ. 
	 * 
	 * @param name Ķ ̸
	 * @return Ķ .    null 
	 */
	public String getParameter(String name);

	/**
	 * Ķ  迭 Ѵ.
	 * 
	 * @param name Ķ ̸
	 * @return Ķ  迭.    null Ǵ ̰ 0 迭 
	 */
	public String[] getParameterValues(String name);

	/**
	 * Ķ ̸ Ѵ.
	 * 
	 * @return Ķ ̸ 
	 */
	public String[] getParameterNames();

	/**
	 *   Ѵ.
	 * 
	 * @param name  ̸
	 * @return  .    null 
	 */
	public String getHeader(String name);

	/**
	 *  Ű  Ѵ.
	 * 
	 * @param name Ű̸
	 * @return Ű . Ű    null 
	 */
	public String getCookieValue(String name);

	/**
	 *  Ű Ѵ.
	 * 
	 * @param name Ű̸
	 * @return Cookie ü.    null 
	 */
	public Cookie getCookie(String name);

	/**
	 * Ű 迭 Ѵ.
	 * 
	 * @return Ű 迭. Ⱑ    null Ǵ ̰ 0 迭 
	 */
	public Cookie[] getCookies();
	
	/**
	 * &lt;Ű̸, Cookie>  Ѵ.
	 * 
	 * @return Ű
	 */
	public Map getCookieMap();

	/**
	 *  Ķͷ ۵  Ѵ.
	 *    null Ѵ.
	 * 
	 * @param name Ķ ̸
	 * @return FileItem
	 */
	public FileItem getFileItem(String name);

	/**
	 *  Ķͷ ۵  byte[] 迭 Ѵ.
	 * 
	 * @param name Ķ ̸
	 * @return byte 迭
	 * @throws byte[] о     ߻.
	 */
	public byte[] getFileByBytes(String name) throws Throwable;

	/**
	 *  û  ϴ   HttpServletRequest Ѵ.
	 * 
	 * @return HttpServletRequest
	 */
	public HttpServletRequest getRequest();

	/**
	 *  û  õ HttpServletResponse Ѵ.
	 * 
	 * @return HttpServletResponse
	 */
	public HttpServletResponse getResponse();

	/**
	 *  û  õ HttpSession Ѵ.
	 * 
	 * @return HttpSession. HttpSession  ʴ  null 
	 */
	public HttpSession getSession();
}