/*
 * Decompiled with CFR 0.152.
 */
package tle.framework;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tle.framework.ComponentManager;
import tle.framework.TLEController;
import tle.framework.TLEFrameworkException;
import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.ComponentNotFoundException;
import tle.framework.component.ComponentState;
import tle.framework.component.spi.aamanager.AAManager;
import tle.framework.component.spi.aamanager.AAManagerProxy;
import tle.framework.component.spi.ra.RequestAnalyzer;
import tle.framework.component.spi.rp.RequestProcessor;
import tle.framework.component.spi.uicreator.UICreator;
import tle.framework.configuration.TLEConfig;
import tle.framework.configuration.TLEConfigDigester;
import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

public class TLEFramework {
    private static ComponentState cm = new ComponentState();
    private static TLEConfig tleConfig;
    private static TLEController controller;

    public static void openFramework(String configFilePath) throws TLEFrameworkException {
        Logger.info("TLEFramework.openFramework():entry");
        cm.event("create");
        cm.event("init");
        try {
            ComponentManager componentManager = ComponentManager.getInstance();
            TLEConfig config = TLEConfigDigester.create(TLEConfigPathUtil.replace(configFilePath));
            Iterator iter = config.getComponentConfigs();
            while (iter.hasNext()) {
                ComponentConfig componentConfig = (ComponentConfig)iter.next();
                componentManager.registComponent(componentConfig);
                Logger.info("TLEFramework.openFramework():Regist Component:" + componentConfig.getComponentID());
            }
            TLEController controller = new TLEController();
            controller.setCoreComponents((RequestAnalyzer)componentManager.getComponent(config.getRequestAnalyzerID()), (RequestProcessor)componentManager.getComponent(config.getRequestProcessorID()), (AAManager)componentManager.getComponent(config.getAAManagerID()), (UICreator)componentManager.getComponent(config.getUICreatorID()));
            componentManager.registComponent(controller, null);
            Logger.info("TLEFramework.openFramework():Regist TLEController:" + controller.getID());
            Logger.info("TLEFramework.openFramework():RequestAnalyzer:" + controller.getRequestAnalyzerID());
            Logger.info("TLEFramework.openFramework():RequestProcessor:" + controller.getRequestProcessorID());
            Logger.info("TLEFramework.openFramework():AAmanagerID:" + controller.getAAmanagerID());
            Logger.info("TLEFramework.openFramework():UICreator:" + controller.getUICreatorID());
            TLEFramework.controller = controller;
        }
        catch (Throwable e) {
            cm.event("error");
            throw new TLEFrameworkException(e.getMessage(), e);
        }
        cm.event("complete");
        cm.event("start");
        cm.event("complete");
        Logger.info("TLEFramework.openFramework():exit");
    }

    public static void closeFramework() {
        Logger.info("TLEFramework.closeFramework():entry");
        if (cm.isRunning()) {
            cm.event("stop");
            ComponentManager componentManager = ComponentManager.getInstance();
            try {
                componentManager.unregistComponent(controller.getRequestAnalyzerID());
                Logger.info("TLEFramework.closeFramework():Unregist RequestAnalyzer");
                componentManager.unregistComponent(controller.getRequestProcessorID());
                Logger.info("TLEFramework.closeFramework():Unregist RequestProcessor");
                componentManager.unregistComponent(controller.getAAmanagerID());
                Logger.info("TLEFramework.closeFramework():Unregist AAManager");
                componentManager.unregistComponent(controller.getUICreatorID());
                Logger.info("TLEFramework.closeFramework():Unregist UICreator");
            }
            catch (ComponentNotFoundException e) {
                Logger.error("TLEFramework.closeFramework():Fail to Unregist Core Components", e);
            }
            catch (ComponentException e) {
                Logger.error("TLEFramework.closeFramework():Fail to Unregist Core Components", e);
            }
            try {
                componentManager.unregistComponent(controller.getID());
                Logger.info("TLEFramework.closeFramework():Unregist TLEController");
            }
            catch (ComponentException e) {
                Logger.error("TLEFramework.closeFramework():Fail to Unregist TLEController", e);
            }
            componentManager.unregistAllComponent();
            cm.event("complete");
            cm.event("close");
            cm.event("complete");
        }
        Logger.info("TLEFramework.closeFramework():exit");
    }

    public static void processingRequest(HttpServletRequest request, HttpServletResponse response) throws TLEFrameworkException {
        if (!cm.isRunning()) {
            throw new TLEFrameworkException("TLEFramework.processingRequest():TLEFramework is not running");
        }
        controller.processingRequest(request, response);
    }

    public static AAManagerProxy getAAManagerProxy() {
        return controller.getAAManager().getAAManagerProxy();
    }
}

