/*
 * Ʈ: TLE2Framework
 * ϸ: RoleManagerImpl.java
 * ۼ: 2004. 11. 10
 */
package tle.framework.component.impl.aamanager.role;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.xml.sax.SAXException;

import tle.framework.component.ComponentConfig;
import tle.framework.component.impl.aamanager.RoleManager;
import tle.framework.component.spi.aamanager.AAManagerException;
import tle.framework.component.spi.aamanager.Role;
import tle.framework.util.TLEConfigPathUtil;

/**
 * RoleManager  Ŭμ  Ϸκ   Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class RoleManagerImpl implements RoleManager {
	/**
	 * &lt;ID, Role νϽ>  Ѵ.
	 */
	private Map roleMap = new java.util.HashMap();
	
	/**
	 * Ʈ "RoleManagerImpl.configFile" ʱȭ Ķͷκ
	 *       θ Ѵ.
	 * 
	 * @see tle.framework.component.impl.aamanager.RoleManager#init(tle.framework.component.ComponentConfig)
	 */
	public void init(ComponentConfig config) throws AAManagerException {
		String configFile = config.getInitParameter("RoleManagerImpl.configFile");
		try {
			RoleManagerConfiguration configuration = RoleManagerConfigurationDigester.create(TLEConfigPathUtil.replace(configFile));
			List roleList = configuration.getRoleList();
			for (int i = 0 ; i < roleList.size() ; i++) {
				RoleImpl role = (RoleImpl)roleList.get(i);
				roleMap.put(role.getID(), role);
			}
		} catch (IOException e) {
			throw new AAManagerException("RoleManagerImpl.init(): б ", e);
		} catch (SAXException e) {
			throw new AAManagerException("RoleManagerImpl.init(): б ", e);
		}
	}

	/**
	 * @see tle.framework.component.impl.aamanager.RoleManager#getRole(java.lang.String)
	 */
	public Role getRole(String roleID) {
		return (Role)roleMap.get(roleID);
	}
}
