/*
 * Ʈ: TLE2FrameworkExample
 * ϸ: UserRepository.java
 * ۼ: 2004. 11. 15
 */
package test.tle.aamanager;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

/**
 *  ø̼    ִ Ŭ.
 * Ŭ н ִ userlist.properties Ϸκ
 *  о´.
 * 
 * @author ֹ
 */
class UserRepository {
	private static UserRepository instance = new UserRepository();
	
	public static UserRepository getInstance() {
		return instance;
	}
	
	private Map userMap = new java.util.HashMap();
	
	private UserRepository() {}
	
	/**
	 * Ŭ н ִ userlist.properties Ϸκ   о´.
	 */
	void init() throws Throwable {
		InputStream is = null;
		try {
			is = this.getClass().getClassLoader().getResourceAsStream("userlist.properties");
			Properties prop = new Properties();
			prop.load(is);
			Enumeration enum = prop.propertyNames();
			while (enum.hasMoreElements()) {
				String propName = (String)enum.nextElement();
				String propValue = prop.getProperty(propName);
				// ID=PASSWORD|ROLEID[,ROLEID]*
				StringTokenizer st = new StringTokenizer(propValue, "|");
				String password = st.nextToken();
				String rolePart = st.nextToken();
				
				st = new StringTokenizer(rolePart, ",");
				String[] roleIDs = new String[st.countTokens()];
				for (int i = 0 ; st.hasMoreTokens() ; i++) {
					roleIDs[i] = st.nextToken();
				}
				
				UserDBRecord userDBRec = new UserDBRecord();
				userDBRec.setID(propName);
				userDBRec.setPassword(password);
				userDBRec.setRoleIDs(roleIDs);
				
				userMap.put(userDBRec.getID(), userDBRec);
			}
		} finally {
			if (is != null) try { is.close(); } catch(IOException ex) {}
		}
	}
	
	UserDBRecord getUserDBRecord(String id) {
		return (UserDBRecord)userMap.get(id);
	}
	
	static class UserDBRecord {
		private String ID;
		private String password;
		private String[] roleIDs = null;
		
		public String getID() {
			return ID;
		}
		public void setID(String id) {
			ID = id;
		}
		public String getPassword() {
			return password;
		}
		public void setPassword(String password) {
			this.password = password;
		}
		public String[] getRoleIDs() {
			return roleIDs;
		}
		public void setRoleIDs(String[] roleIDs) {
			this.roleIDs = roleIDs;
		}
	}
}
