/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultRPConfiguration.java
 * ۼ: 2004. 10. 25
 */
package tle.framework.component.impl.rp.config;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;

import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

/**
 * DefaultRequestProcessor   ϴ Ŭ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class DefaultRPConfiguration {
	private List validatorConfigList = new java.util.ArrayList(10);
	private Map formConfigMap = new java.util.HashMap();
	
	private boolean usingIndependentClassPath;
	private List classPathList = new java.util.ArrayList(10);
	private Map handlerClassMap = new java.util.HashMap();
	private Map handlerJspMap = new java.util.HashMap();
	private Map commandHandlerMap = new java.util.HashMap();
	
	public static final int DEFAULT_GOVIEW = 0x01;
	public static final int DEFAULT_NOHANDLER = 0x02;
	/**
	 * ɾ  ڵ鷯 õǾ     ⺻ ڵ鷯 Ѵ.
	 * ⺻  ERROR
	 */
	private int defaultHandlerType = DEFAULT_NOHANDLER;
	
	public void setUsingIndependentClassPath(boolean b) {
		this.usingIndependentClassPath = b;
	}
	public boolean isUsingIndependentClassPath() {
		return usingIndependentClassPath;
	}
	
	/**
	 * @since 2.0.5
	 */
	public void addValidatorConfig(String name, String className) {
		validatorConfigList.add(new ValidatorConfig(name, className));
	}
	/**
	 * @since 2.0.5
	 */
	public List getValidatorConfigList() {
		return validatorConfigList;
	}
	/**
	 * @since 2.0.5
	 */
	public void addFormConfig(FormConfig formConfig) {
		formConfigMap.put(formConfig.getName(), formConfig);
	}
	/**
	 * @since 2.0.5
	 */
	public FormConfig getFormConfig(String name) {
		return (FormConfig)formConfigMap.get(name);
	}
	/**
	 * @since 2.0.5
	 */
	public void loadFormList(String file) {
		try {
			URL ruleXml = DefaultRPConfiguration.class.getClassLoader().getResource("tle/framework/component/impl/rp/config/DefaultRPConfiguration.form.rule.xml");
			Digester digester = DigesterLoader.createDigester(ruleXml);
			List list = (List)digester.parse(TLEConfigPathUtil.replace(file));
			Iterator iter = list.iterator();
			
			while (iter.hasNext()) {
				FormConfig formConfig = (FormConfig)iter.next();
				formConfigMap.put(formConfig.getName(), formConfig);
			}
		} catch(Throwable e) {
			Logger.error("DefaultRPConfiguration.loadFormList():"+e.getMessage(), e);
		}
	}
	public void addClassPath(String classPath) {
		classPathList.add(classPath);
	}
	public String[] getClassPathArray() {
		String[] classPathArray = new String[classPathList.size()];
		classPathList.toArray(classPathArray);
		return classPathArray;
	}
	
	public void addHandlerClass(String handlerID, String handlerClassName, String jspPage) {
		if (jspPage != null) {
			handlerJspMap.put(handlerID, jspPage);
		} else {
			handlerClassMap.put(handlerID, handlerClassName);
		}
	}
	public void loadHandlerList(String file) {
		try {
			URL ruleXml = DefaultRPConfiguration.class.getClassLoader().getResource("tle/framework/component/impl/rp/config/DefaultRPConfiguration.handler.rule.xml");
			Digester digester = DigesterLoader.createDigester(ruleXml);
			List list = (List)digester.parse(TLEConfigPathUtil.replace(file));
			Iterator iter = list.iterator();
			
			while (iter.hasNext()) {
				HandlerConfig handlerConfig = (HandlerConfig)iter.next();
				addHandlerClass(handlerConfig.getId(), handlerConfig.getClassName(), handlerConfig.getJsp());
			}
		} catch(Throwable e) {
			Logger.error("DefaultRPConfiguration.loadHandlerList():"+e.getMessage(), e);
		}
	}
	public Map getHandlerClassMap() {
		return handlerClassMap;
	}
	public Map getHandlerJspMap() {
		return handlerJspMap;
	}
	public void setDefaultHandler(String type) {
		if (type.compareTo("GOVIEW") == 0) {
			this.defaultHandlerType = DEFAULT_GOVIEW;
		} else if (type.compareTo("NOHANDLER") == 0) { 
			this.defaultHandlerType = DEFAULT_NOHANDLER;
		} else {
			throw new IllegalArgumentException("Invalid type value:"+type);
		}
	}
	public int getDefaultHandlerType() {
		return defaultHandlerType; 
	}
	/**
	 * 2.0.5  formName ڿ formErrorResultCode  ߰
	 * @param commandID
	 * @param handlerID
	 * @param formName
	 * @param formErrorResultCode
	 */
	public void addCommandHandlerMapping(String commandID, String handlerID, String formName, String formErrorResultCode) {
		CommandMappingConfig commandMapping = new CommandMappingConfig(commandID, handlerID, formName, formErrorResultCode);
		commandHandlerMap.put(commandMapping.getCommandID(), commandMapping);
	}
	public Map getCommandHandlerMap() {
		return commandHandlerMap;
	}
	public void loadCommandHandlerMapping(String file) {
		try {
			URL ruleXml = DefaultRPConfiguration.class.getClassLoader().getResource("tle/framework/component/impl/rp/config/DefaultRPConfiguration.mapping.rule.xml");
			Digester digester = DigesterLoader.createDigester(ruleXml);
			List list = (List)digester.parse(TLEConfigPathUtil.replace(file));
			
			Iterator iter = list.iterator();
			while (iter.hasNext()) {
				CommandMappingConfig mappingConfig = (CommandMappingConfig)iter.next();
				commandHandlerMap.put(mappingConfig.getCommandID(), mappingConfig);
			}
		} catch(Throwable e) {
			Logger.error("DefaultRPConfiguration.loadCommandHandlerMapping():"+e.getMessage(), e);
		}
	}
}
