/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultRPConfigurationDigesterTest.java
 * ۼ: 2004. 10. 25
 */
package test.tle.framework.component.impl.rp.config;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.xml.sax.SAXException;

import tle.framework.component.impl.rp.config.CommandMappingConfig;
import tle.framework.component.impl.rp.config.DefaultRPConfiguration;
import tle.framework.component.impl.rp.config.DefaultRPConfigurationDigester;
import tle.framework.component.impl.rp.config.FormConfig;
import tle.framework.component.impl.rp.config.FormTestConfig;

import junit.framework.TestCase;

/**
 * DefaultRPConfigurationDigester ׽Ʈ Ŭ
 * 
 * @author ֹ
 * @since 2.0
 */
public class DefaultRPConfigurationDigesterTest extends TestCase {
	
	public void testSplit() {
		String[] values = DefaultRPConfiguration.split("name, test ,", ',', true, true);
		assertEquals(3, values.length);
		assertEquals("name", values[0]);
		assertEquals("test", values[1]);
		assertEquals("", values[2]);

		values = DefaultRPConfiguration.split("name, test", ',', true, true);
		assertEquals(2, values.length);
		assertEquals("name", values[0]);
		assertEquals("test", values[1]);
	}
	
	public void testCreate() throws IOException, SAXException {
		DefaultRPConfiguration config = DefaultRPConfigurationDigester.create("c:/eclipse/workspace/TLE2Framework/config/DefaultRequestProcessor.xml");
		
		FormConfig form = config.getFormConfig("memberRegist");
		assertNotNull(form);
		
		List testConfigList = form.getFormTestConfigList();
		FormTestConfig testConfig = (FormTestConfig)testConfigList.get(0);
		assertEquals("id", testConfig.getParameterName());
		assertEquals("required", testConfig.getValidatorName());
		assertEquals("true", testConfig.getConstraint());
		assertEquals(" ޽", testConfig.getErrrorMessage());
		
		testConfig = (FormTestConfig)testConfigList.get(1);
		assertEquals("id2", testConfig.getParameterName());
		assertEquals("regex", testConfig.getValidatorName());
		assertEquals("[a-z]", testConfig.getConstraint());
		assertEquals(" ޽2", testConfig.getErrrorMessage());
		
		form = config.getFormConfig("memberRegist2");
		assertNotNull(form);
		testConfigList = form.getFormTestConfigList();
		testConfig = (FormTestConfig)testConfigList.get(0);
		assertEquals("id_2", testConfig.getParameterName());
		assertEquals("required", testConfig.getValidatorName());
		assertEquals("true", testConfig.getConstraint());
		assertEquals(" ޽_2", testConfig.getErrrorMessage());
		
		testConfig = (FormTestConfig)testConfigList.get(1);
		assertEquals("id2_2", testConfig.getParameterName());
		assertEquals("regex", testConfig.getValidatorName());
		assertEquals("[a-z]", testConfig.getConstraint());
		assertEquals(" ޽2_2", testConfig.getErrrorMessage());		
		
		form = config.getFormConfig("memberRegist3");
		assertNotNull(form);
		testConfigList = form.getFormTestConfigList();
		
		assertEquals(true, config.isUsingIndependentClassPath());
		assertEquals(3, config.getClassPathArray().length);
		
		java.util.HashMap classPathMap = new java.util.HashMap();
		classPathMap.put("c:\\temp\\classes", "true");
		classPathMap.put("d:\\command\\handler\\classes", "true");
		classPathMap.put("a:\\common.jar", "true");
		
		for (int i = 0 ; i < config.getClassPathArray().length ; i++) {
			assertTrue(classPathMap.containsKey(config.getClassPathArray()[i]));
		}
		
		Map handlerMap = config.getHandlerClassMap();
		assertEquals("tle.board.command.Board", handlerMap.get("board"));
		assertEquals("tle.board.command.PDS", handlerMap.get("pds"));
		assertEquals("tle.board.command.Guest", handlerMap.get("guest"));
		
		Map jspHandlerMap = config.getHandlerJspMap();
		assertEquals("/handler/list.jsp", jspHandlerMap.get("list"));
		
		Map commandHandlerMap = config.getCommandHandlerMap();
		CommandMappingConfig mappingConfig = (CommandMappingConfig)commandHandlerMap.get("/board/write");
		assertEquals("board", mappingConfig.getHandlerID());
		
		mappingConfig = (CommandMappingConfig)commandHandlerMap.get("/board/read");
		assertEquals("board", mappingConfig.getHandlerID());
		
		mappingConfig = (CommandMappingConfig)commandHandlerMap.get("/guest/list");
		assertEquals("guest", mappingConfig.getHandlerID());
		
		mappingConfig = (CommandMappingConfig)commandHandlerMap.get("/loginForm");
		assertEquals("default.GOVIEW", mappingConfig.getHandlerID());
		
		mappingConfig = (CommandMappingConfig)commandHandlerMap.get("/sub/test.do");
		assertEquals("test", mappingConfig.getHandlerID());
		
		assertEquals(0x02, config.getDefaultHandlerType());
	}
}
