/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.soap;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.NotificationResult;
import javax.security.auth.Subject;
import mx4j.tools.remote.Connection;
import mx4j.tools.remote.soap.SOAPConnection;
import mx4j.tools.remote.soap.SOAPConnectionManager;
import mx4j.tools.remote.soap.SOAPConnectorServer;
import org.apache.axis.MessageContext;

public class SOAPConnectionPivot
implements Connection,
SOAPConnection {
    private final Map connections = new HashMap();
    private SOAPConnectionManager connectionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String connect(Object credentials) throws IOException, SecurityException {
        JMXServiceURL address = this.retrieveJMXServiceURL();
        SOAPConnectionPivot sOAPConnectionPivot = this;
        synchronized (sOAPConnectionPivot) {
            if (this.connectionManager == null) {
                this.connectionManager = SOAPConnectorServer.find(address);
                if (this.connectionManager == null) {
                    throw new IOException("Could not find ConnectionManager. Make sure a SOAPConnectorServer is in classloader scope and bound at this address " + address);
                }
            }
        }
        Connection connection = this.connectionManager.connect(credentials);
        String id = connection.getConnectionId();
        Map map = this.connections;
        synchronized (map) {
            this.connections.put(id, connection);
        }
        return id;
    }

    private JMXServiceURL retrieveJMXServiceURL() throws MalformedURLException {
        MessageContext context = MessageContext.getCurrentContext();
        String url = (String)context.getProperty("transport.url");
        JMXServiceURL temp = new JMXServiceURL("service:jmx:" + url);
        return new JMXServiceURL("soap", "localhost", temp.getPort(), temp.getURLPath());
    }

    private String retrieveConnectionID() {
        MessageContext context = MessageContext.getCurrentContext();
        return (String)context.getProperty("connectionId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOAPConnection findConnection() throws IOException {
        String id = this.retrieveConnectionID();
        SOAPConnection connection = null;
        Map map = this.connections;
        synchronized (map) {
            connection = (SOAPConnection)this.connections.get(id);
        }
        if (connection == null) {
            throw new IOException("Could not find connection with ID " + id);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        String id = this.retrieveConnectionID();
        Connection connection = null;
        Map map = this.connections;
        synchronized (map) {
            connection = (Connection)this.connections.remove(id);
        }
        if (connection == null) {
            throw new IOException("Could not find connection with ID " + id);
        }
        connection.close();
    }

    public String getConnectionId() throws IOException {
        Connection connection = (Connection)((Object)this.findConnection());
        return connection.getConnectionId();
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature, Subject delegate) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        SOAPConnection connection = this.findConnection();
        return connection.createMBean(className, name, params, signature, delegate);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature, Subject delegate) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        SOAPConnection connection = this.findConnection();
        return connection.createMBean(className, name, loaderName, params, signature, delegate);
    }

    public void unregisterMBean(ObjectName name, Subject delegate) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        SOAPConnection connection = this.findConnection();
        connection.unregisterMBean(name, delegate);
    }

    public ObjectInstance getObjectInstance(ObjectName name, Subject delegate) throws InstanceNotFoundException, IOException {
        SOAPConnection connection = this.findConnection();
        return connection.getObjectInstance(name, delegate);
    }

    public Set queryMBeans(ObjectName name, Object query, Subject delegate) throws IOException {
        SOAPConnection connection = this.findConnection();
        return connection.queryMBeans(name, query, delegate);
    }

    public Set queryNames(ObjectName name, Object query, Subject delegate) throws IOException {
        SOAPConnection connection = this.findConnection();
        return connection.queryNames(name, query, delegate);
    }

    public boolean isRegistered(ObjectName name, Subject delegate) throws IOException {
        SOAPConnection connection = this.findConnection();
        return connection.isRegistered(name, delegate);
    }

    public Integer getMBeanCount(Subject delegate) throws IOException {
        SOAPConnection connection = this.findConnection();
        return connection.getMBeanCount(delegate);
    }

    public Object getAttribute(ObjectName name, String attribute, Subject delegate) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        SOAPConnection connection = this.findConnection();
        return connection.getAttribute(name, attribute, delegate);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes, Subject delegate) throws InstanceNotFoundException, ReflectionException, IOException {
        SOAPConnection connection = this.findConnection();
        return connection.getAttributes(name, attributes, delegate);
    }

    public void setAttribute(ObjectName name, Attribute attribute, Subject delegate) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        SOAPConnection connection = this.findConnection();
        connection.setAttribute(name, attribute, delegate);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes, Subject delegate) throws InstanceNotFoundException, ReflectionException, IOException {
        SOAPConnection connection = this.findConnection();
        return connection.setAttributes(name, attributes, delegate);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature, Subject delegate) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        SOAPConnection connection = this.findConnection();
        return connection.invoke(name, operationName, params, signature, delegate);
    }

    public String getDefaultDomain(Subject delegate) throws IOException {
        SOAPConnection connection = this.findConnection();
        return connection.getDefaultDomain(delegate);
    }

    public String[] getDomains(Subject delegate) throws IOException {
        SOAPConnection connection = this.findConnection();
        return connection.getDomains(delegate);
    }

    public MBeanInfo getMBeanInfo(ObjectName name, Subject delegate) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        SOAPConnection connection = this.findConnection();
        return connection.getMBeanInfo(name, delegate);
    }

    public boolean isInstanceOf(ObjectName name, String className, Subject delegate) throws InstanceNotFoundException, IOException {
        SOAPConnection connection = this.findConnection();
        return connection.isInstanceOf(name, className, delegate);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, Object filter, Object handback, Subject delegate) throws InstanceNotFoundException, IOException {
        SOAPConnection connection = this.findConnection();
        connection.addNotificationListener(name, listener, filter, handback, delegate);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, Subject delegate) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        SOAPConnection connection = this.findConnection();
        connection.removeNotificationListener(name, listener, delegate);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, Object filter, Object handback, Subject delegate) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        SOAPConnection connection = this.findConnection();
        connection.removeNotificationListener(name, listener, filter, handback, delegate);
    }

    public Integer[] addNotificationListeners(ObjectName[] names, Subject[] delegates) throws InstanceNotFoundException, IOException {
        SOAPConnection connection = this.findConnection();
        return connection.addNotificationListeners(names, delegates);
    }

    public void removeNotificationListeners(ObjectName observed, Integer[] ids, Subject delegate) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        SOAPConnection connection = this.findConnection();
        connection.removeNotificationListeners(observed, ids, delegate);
    }

    public NotificationResult fetchNotifications(long clientSequenceNumber, int maxNotifications, long timeout) throws IOException {
        SOAPConnection connection = this.findConnection();
        return connection.fetchNotifications(clientSequenceNumber, maxNotifications, timeout);
    }
}

