/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component.impl.rp.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import tle.framework.component.impl.rp.config.CommandMappingConfig;
import tle.framework.component.impl.rp.config.FormConfig;
import tle.framework.component.impl.rp.config.HandlerConfig;
import tle.framework.component.impl.rp.config.ValidatorConfig;
import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

public class DefaultRPConfiguration {
    private List validatorConfigList = new ArrayList(10);
    private Map formConfigMap = new HashMap();
    private boolean usingIndependentClassPath;
    private List classPathList = new ArrayList(10);
    private Map handlerClassMap = new HashMap();
    private Map handlerJspMap = new HashMap();
    private Map commandHandlerMap = new HashMap();
    public static final int DEFAULT_GOVIEW = 1;
    public static final int DEFAULT_NOHANDLER = 2;
    private int defaultHandlerType = 2;
    static /* synthetic */ Class class$tle$framework$component$impl$rp$config$DefaultRPConfiguration;

    public void setUsingIndependentClassPath(boolean b) {
        this.usingIndependentClassPath = b;
    }

    public boolean isUsingIndependentClassPath() {
        return this.usingIndependentClassPath;
    }

    public void addValidatorConfig(String name, String className) {
        this.validatorConfigList.add(new ValidatorConfig(name, className));
    }

    public List getValidatorConfigList() {
        return this.validatorConfigList;
    }

    public void addFormConfig(FormConfig formConfig) {
        this.formConfigMap.put(formConfig.getName(), formConfig);
    }

    public FormConfig getFormConfig(String name) {
        return (FormConfig)this.formConfigMap.get(name);
    }

    public FormConfig[] getFormConfigs(String names) {
        String[] formNames = DefaultRPConfiguration.split(names, ',', true, true);
        FormConfig[] formConfigs = new FormConfig[formNames.length];
        for (int i = 0; i < formConfigs.length; ++i) {
            formConfigs[i] = this.getFormConfig(formNames[i]);
        }
        return formConfigs;
    }

    public void loadFormList(String file) {
        try {
            URL ruleXml = (class$tle$framework$component$impl$rp$config$DefaultRPConfiguration == null ? (class$tle$framework$component$impl$rp$config$DefaultRPConfiguration = DefaultRPConfiguration.class$("tle.framework.component.impl.rp.config.DefaultRPConfiguration")) : class$tle$framework$component$impl$rp$config$DefaultRPConfiguration).getClassLoader().getResource("tle/framework/component/impl/rp/config/DefaultRPConfiguration.form.rule.xml");
            Digester digester = DigesterLoader.createDigester((URL)ruleXml);
            List list = (List)digester.parse(TLEConfigPathUtil.replace(file));
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                FormConfig formConfig = (FormConfig)iter.next();
                this.formConfigMap.put(formConfig.getName(), formConfig);
            }
        }
        catch (Throwable e) {
            Logger.error("DefaultRPConfiguration.loadFormList():" + e.getMessage(), e);
        }
    }

    public void addClassPath(String classPath) {
        this.classPathList.add(classPath);
    }

    public String[] getClassPathArray() {
        String[] classPathArray = new String[this.classPathList.size()];
        this.classPathList.toArray(classPathArray);
        return classPathArray;
    }

    public void addHandlerClass(String handlerID, String handlerClassName, String jspPage) {
        if (jspPage != null) {
            this.handlerJspMap.put(handlerID, jspPage);
        } else {
            this.handlerClassMap.put(handlerID, handlerClassName);
        }
    }

    public void loadHandlerList(String file) {
        try {
            URL ruleXml = (class$tle$framework$component$impl$rp$config$DefaultRPConfiguration == null ? (class$tle$framework$component$impl$rp$config$DefaultRPConfiguration = DefaultRPConfiguration.class$("tle.framework.component.impl.rp.config.DefaultRPConfiguration")) : class$tle$framework$component$impl$rp$config$DefaultRPConfiguration).getClassLoader().getResource("tle/framework/component/impl/rp/config/DefaultRPConfiguration.handler.rule.xml");
            Digester digester = DigesterLoader.createDigester((URL)ruleXml);
            List list = (List)digester.parse(TLEConfigPathUtil.replace(file));
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                HandlerConfig handlerConfig = (HandlerConfig)iter.next();
                this.addHandlerClass(handlerConfig.getId(), handlerConfig.getClassName(), handlerConfig.getJsp());
            }
        }
        catch (Throwable e) {
            Logger.error("DefaultRPConfiguration.loadHandlerList():" + e.getMessage(), e);
        }
    }

    public Map getHandlerClassMap() {
        return this.handlerClassMap;
    }

    public Map getHandlerJspMap() {
        return this.handlerJspMap;
    }

    public void setDefaultHandler(String type) {
        if (type.compareTo("GOVIEW") == 0) {
            this.defaultHandlerType = 1;
        } else if (type.compareTo("NOHANDLER") == 0) {
            this.defaultHandlerType = 2;
        } else {
            throw new IllegalArgumentException("Invalid type value:" + type);
        }
    }

    public int getDefaultHandlerType() {
        return this.defaultHandlerType;
    }

    public void addCommandHandlerMapping(String commandID, String handlerID, String formName, String formErrorResultCode) {
        CommandMappingConfig commandMapping = new CommandMappingConfig(commandID, handlerID, formName, formErrorResultCode);
        this.commandHandlerMap.put(commandMapping.getCommandID(), commandMapping);
    }

    public Map getCommandHandlerMap() {
        return this.commandHandlerMap;
    }

    public void loadCommandHandlerMapping(String file) {
        try {
            URL ruleXml = (class$tle$framework$component$impl$rp$config$DefaultRPConfiguration == null ? (class$tle$framework$component$impl$rp$config$DefaultRPConfiguration = DefaultRPConfiguration.class$("tle.framework.component.impl.rp.config.DefaultRPConfiguration")) : class$tle$framework$component$impl$rp$config$DefaultRPConfiguration).getClassLoader().getResource("tle/framework/component/impl/rp/config/DefaultRPConfiguration.mapping.rule.xml");
            Digester digester = DigesterLoader.createDigester((URL)ruleXml);
            List list = (List)digester.parse(TLEConfigPathUtil.replace(file));
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                CommandMappingConfig mappingConfig = (CommandMappingConfig)iter.next();
                this.commandHandlerMap.put(mappingConfig.getCommandID(), mappingConfig);
            }
        }
        catch (Throwable e) {
            Logger.error("DefaultRPConfiguration.loadCommandHandlerMapping():" + e.getMessage(), e);
        }
    }

    public static String[] split(String value, char delimeter, boolean trim, boolean addOneTokenAfterLastDelimter) {
        if (value == null || value.equals("")) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(4);
        int idx = -1;
        int lastIdx = -1;
        do {
            String token;
            if ((idx = value.indexOf(delimeter, lastIdx + 1)) > -1) {
                if (lastIdx + 1 == idx) {
                    list.add("");
                } else {
                    token = value.substring(lastIdx + 1, idx);
                    if (trim) {
                        token = token.trim();
                    }
                    list.add(token);
                }
                if (idx == value.length() - 1 && addOneTokenAfterLastDelimter) {
                    list.add("");
                }
                lastIdx = idx;
                continue;
            }
            token = value.substring(lastIdx + 1);
            if (trim) {
                token = token.trim();
            }
            list.add(token);
            lastIdx = value.length() - 1;
        } while (lastIdx < value.length() - 1);
        String[] tokens = new String[list.size()];
        list.toArray(tokens);
        return tokens;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

