/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescriptorSupport
implements Descriptor {
    private static final long serialVersionUID = -6292969195866300415L;
    private HashMap descriptor;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;

    public DescriptorSupport() {
        this.descriptor = new HashMap(20);
    }

    public DescriptorSupport(int initNumFields) throws MBeanException, RuntimeOperationsException {
        if (initNumFields <= 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Number of Fields cannot be <= 0"));
        }
        this.descriptor = new HashMap(initNumFields);
    }

    public DescriptorSupport(DescriptorSupport inDescr) {
        this();
        if (inDescr != null) {
            this.setFields(inDescr.getFieldNames(), inDescr.getFieldValues(inDescr.getFieldNames()));
        }
    }

    public DescriptorSupport(String xml) throws MBeanException, RuntimeOperationsException, XMLParseException {
        this();
        if (xml == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor XML string is null"));
        }
        NodeList fields = this.documentFromXML(xml).getElementsByTagName("field");
        for (int i = 0; i < fields.getLength(); ++i) {
            this.addFieldFromXML(fields.item(i));
        }
    }

    public DescriptorSupport(String[] pairs) {
        this();
        if (pairs != null && pairs.length != 0) {
            for (int i = 0; i < pairs.length; ++i) {
                String pair = pairs[i];
                if (pair == null) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("Illegal pair: " + pair));
                }
                int equal = pair.indexOf(61);
                if (equal < 1) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("Illegal pair: " + pair));
                }
                String name = pair.substring(0, equal);
                String value = null;
                if (equal < pair.length() - 1) {
                    value = pair.substring(equal + 1);
                }
                this.setField(name, value);
            }
        }
    }

    public DescriptorSupport(String[] names, Object[] values) {
        this();
        this.setFields(names, values);
    }

    public Object clone() throws RuntimeOperationsException {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ignored) {
            return null;
        }
    }

    public Object getFieldValue(String name) throws RuntimeOperationsException {
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid field name"));
        }
        Object value = this.descriptor.get(name.toLowerCase());
        return value;
    }

    public void setField(String name, Object value) throws RuntimeOperationsException {
        this.checkField(name, value);
        this.descriptor.put(name.toLowerCase(), value);
    }

    public void removeField(String name) {
        if (name != null) {
            this.descriptor.remove(name.toLowerCase());
        }
    }

    public String[] getFieldNames() {
        String[] names = this.descriptor.keySet().toArray(new String[0]);
        return names;
    }

    public Object[] getFieldValues(String[] names) {
        if (names == null) {
            Object[] values = this.descriptor.values().toArray(new Object[0]);
            return values;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < names.length; ++i) {
            try {
                Object value = this.getFieldValue(names[i]);
                list.add(value);
                continue;
            }
            catch (RuntimeOperationsException x) {
                list.add(null);
            }
        }
        Object[] values = list.toArray(new Object[list.size()]);
        return values;
    }

    public String[] getFields() {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.descriptor.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            buffer.setLength(0);
            buffer.append(key);
            buffer.append("=");
            if (value != null) {
                if (value instanceof String) {
                    buffer.append(value.toString());
                } else {
                    buffer.append("(");
                    buffer.append(value.toString());
                    buffer.append(")");
                }
            }
            list.add(buffer.toString());
        }
        String[] fields = list.toArray(new String[list.size()]);
        return fields;
    }

    public void setFields(String[] names, Object[] values) throws RuntimeOperationsException {
        if (names == null || values == null || names.length != values.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid arguments"));
        }
        for (int i = 0; i < names.length; ++i) {
            this.setField(names[i], values[i]);
        }
    }

    public boolean isValid() throws RuntimeOperationsException {
        if (this.getFieldValue("name") == null || this.getFieldValue("descriptorType") == null) {
            return false;
        }
        try {
            Iterator i = this.descriptor.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                this.checkField(name, value);
            }
            return true;
        }
        catch (RuntimeOperationsException x) {
            return false;
        }
    }

    public String toXMLString() throws RuntimeOperationsException {
        StringBuffer buf = new StringBuffer(32);
        buf.append("<Descriptor>");
        try {
            if (this.descriptor.size() != 0) {
                Iterator i = this.descriptor.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Object value = entry.getValue();
                    String valstr = this.toXMLValueString(value);
                    buf.append("<field name=\"");
                    buf.append(entry.getKey());
                    buf.append("\" value=\"");
                    buf.append(valstr);
                    buf.append("\"></field>");
                }
            }
            buf.append("</Descriptor>");
            return buf.toString();
        }
        catch (RuntimeException x) {
            throw new RuntimeOperationsException(x);
        }
    }

    public String toString() throws RuntimeOperationsException {
        StringBuffer buf = new StringBuffer();
        try {
            if (this.descriptor.size() != 0) {
                Iterator i = this.descriptor.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    buf.append(entry.getKey()).append(" ").append(entry.getValue());
                    if (!i.hasNext()) continue;
                    buf.append(",");
                }
            }
            return buf.toString();
        }
        catch (RuntimeOperationsException x) {
            return buf.toString();
        }
    }

    private void addFieldFromXML(Node n) throws XMLParseException, DOMException, RuntimeOperationsException {
        if (!(n instanceof Element)) {
            throw new XMLParseException("Invalid XML descriptor entity");
        }
        NamedNodeMap attributes = n.getAttributes();
        if (attributes.getLength() != 2 && (attributes.getNamedItem("name") == null || attributes.getNamedItem("value") == null)) {
            throw new XMLParseException("Invalid XML descriptor element");
        }
        String name = attributes.getNamedItem("name").getNodeValue();
        String value = attributes.getNamedItem("value").getNodeValue();
        this.setField(name, this.parseValueString(value));
    }

    private void checkField(String name, Object value) throws RuntimeOperationsException {
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal field name"));
        }
        boolean isValid = true;
        if (name.equalsIgnoreCase("name")) {
            isValid = value != null && value instanceof String && ((String)value).length() != 0;
        } else if (name.equalsIgnoreCase("descriptorType")) {
            isValid = value != null && (value.toString().equalsIgnoreCase("MBean") || value.toString().equalsIgnoreCase("attribute") || value.toString().equalsIgnoreCase("operation") || value.toString().equalsIgnoreCase("notification"));
        } else if (name.equalsIgnoreCase("role")) {
            isValid = value != null && (value.equals("constructor") || value.equals("operation") || value.equals("getter") || value.equals("setter"));
        } else if (name.equalsIgnoreCase("persistPolicy")) {
            isValid = value != null && (value.toString().equalsIgnoreCase("Never") || value.toString().equalsIgnoreCase("OnTimer") || value.toString().equalsIgnoreCase("OnUpdate") || value.toString().equalsIgnoreCase("NoMoreOftenThan") || value.toString().equalsIgnoreCase("Always"));
        } else if (name.equalsIgnoreCase("persistPeriod")) {
            int v = this.objectToInt(value);
            isValid = v >= -1;
        } else if (name.equalsIgnoreCase("currencyTimeLimit")) {
            int v = this.objectToInt(value);
            isValid = v >= -1;
        } else if (name.equalsIgnoreCase("visibility")) {
            int v = this.objectToInt(value);
            isValid = v >= 1 && v <= 4;
        } else if (name.equalsIgnoreCase("getMethod") || name.equalsIgnoreCase("setMethod")) {
            isValid = value != null && value.toString().trim().length() > 0;
        } else if (name.equalsIgnoreCase("protocolMap")) {
            isValid = value instanceof Descriptor;
        } else if (name.equalsIgnoreCase("lastUpdatedTimeStamp")) {
            long v = this.objectToLong(value);
            isValid = v > 0L;
        } else if (name.equalsIgnoreCase("severity")) {
            int v = this.objectToInt(value);
            isValid = v >= 0 && v <= 6;
        } else if (name.equalsIgnoreCase("messageId")) {
            isValid = value != null;
        } else if (name.equalsIgnoreCase("log")) {
            boolean bl = isValid = value != null && (value instanceof Boolean || value instanceof String && (value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("false") || value.toString().equalsIgnoreCase("t") || value.toString().equalsIgnoreCase("f")));
        }
        if (!isValid) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid value '" + value + "' for field " + name));
        }
    }

    private Document documentFromXML(String xml) throws XMLParseException {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document d = db.parse(new ByteArrayInputStream(xml.getBytes()));
            return d;
        }
        catch (Exception x) {
            throw new XMLParseException(x.toString());
        }
    }

    private Class getObjectValueClass(String value) throws XMLParseException {
        int eoc = value.indexOf("/");
        if (eoc == -1) {
            throw new XMLParseException("Illegal XML descriptor class name");
        }
        String klass = value.substring(1, eoc);
        Class<?> result = null;
        try {
            result = Thread.currentThread().getContextClassLoader().loadClass(klass);
        }
        catch (Exception x) {
            throw new XMLParseException(x.toString());
        }
        return result;
    }

    private String getObjectValueString(String value) throws XMLParseException {
        int bov = value.indexOf("/");
        if (bov == -1) {
            throw new XMLParseException("Illegal XML descriptor object value");
        }
        return value.substring(bov + 1, value.length() - 1);
    }

    private String objectClassToID(Class k) {
        StringBuffer result = new StringBuffer();
        result.append(k.getName());
        result.append("/");
        return result.toString();
    }

    private int objectToInt(Object obj) throws RuntimeOperationsException {
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException x) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal value '" + obj + "' for numeric field"));
        }
        catch (NullPointerException x) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal value '" + obj + "' for numeric field"));
        }
    }

    private long objectToLong(Object obj) throws RuntimeOperationsException {
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException x) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal value '" + obj + "' for numeric field"));
        }
        catch (NullPointerException x) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal value '" + obj + "' for numeric field"));
        }
    }

    private Object parseValueString(String value) throws XMLParseException {
        Object result = null;
        result = value.compareToIgnoreCase("(null)") == 0 ? null : (value.charAt(0) != '(' ? value : this.parseObjectValueString(value));
        return result;
    }

    private Object parseObjectValueString(String value) throws XMLParseException {
        if (value.charAt(value.length() - 1) != ')') {
            throw new XMLParseException("Invalid XML descriptor value");
        }
        Character result = null;
        Class k = this.getObjectValueClass(value);
        String s = this.getObjectValueString(value);
        try {
            result = k != (class$java$lang$Character == null ? (class$java$lang$Character = DescriptorSupport.class$("java.lang.Character")) : class$java$lang$Character) ? k.getConstructor(class$java$lang$String == null ? (class$java$lang$String = DescriptorSupport.class$("java.lang.String")) : class$java$lang$String).newInstance(s) : new Character(s.charAt(0));
        }
        catch (Exception x) {
            throw new XMLParseException(x.toString());
        }
        return result;
    }

    private String toXMLValueString(Object value) {
        String result;
        if (value == null) {
            result = "(null)";
        } else {
            Class<?> k = value.getClass();
            result = k == (class$java$lang$String == null ? (class$java$lang$String = DescriptorSupport.class$("java.lang.String")) : class$java$lang$String) && ((String)value).charAt(0) != '(' ? (String)value : this.toObjectXMLValueString(k, value);
        }
        return result;
    }

    private String toObjectXMLValueString(Class k, Object value) {
        StringBuffer result = new StringBuffer();
        result.append("(");
        result.append(this.objectClassToID(k));
        result.append(value.toString());
        result.append(")");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

