/*
 * Decompiled with CFR 0.152.
 */
package tle.framework;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tle.framework.TLEControllerMBean;
import tle.framework.component.ComponentException;
import tle.framework.component.impl.ComponentBase;
import tle.framework.component.spi.aamanager.AAManager;
import tle.framework.component.spi.aamanager.NullUser;
import tle.framework.component.spi.aamanager.Service;
import tle.framework.component.spi.aamanager.User;
import tle.framework.component.spi.ra.RequestAnalyzer;
import tle.framework.component.spi.ra.RequestAnalyzerException;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.component.spi.ra.RequestInfoWrapper;
import tle.framework.component.spi.rp.RequestProcessor;
import tle.framework.component.spi.rp.Result;
import tle.framework.component.spi.uicreator.UICreator;
import tle.framework.http.RIRequestWrapper;
import tle.framework.log.Logger;

public class TLEController
extends ComponentBase
implements TLEControllerMBean {
    private boolean useWrapper = false;
    private RequestAnalyzer ra;
    private RequestProcessor rp;
    private AAManager aaManager;
    private UICreator uiCreator;

    AAManager getAAManager() {
        return this.aaManager;
    }

    void setUseWrapper(boolean useWrapper) {
        this.useWrapper = useWrapper;
    }

    public boolean isUseWrapper() {
        return this.useWrapper;
    }

    public String getRequestAnalyzerID() {
        return this.ra.getID();
    }

    public String getRequestProcessorID() {
        return this.rp.getID();
    }

    public String getAAmanagerID() {
        return this.aaManager.getID();
    }

    public String getUICreatorID() {
        return this.uiCreator.getID();
    }

    void setCoreComponents(RequestAnalyzer ra, RequestProcessor rp, AAManager aaManager, UICreator uiCreator) {
        if (ra == null) {
            throw new IllegalArgumentException("RequestAnalyzer == null");
        }
        if (rp == null) {
            throw new IllegalArgumentException("RequestProcessor == null");
        }
        if (aaManager == null) {
            throw new IllegalArgumentException("AAManager == null");
        }
        if (uiCreator == null) {
            throw new IllegalArgumentException("UICreator == null");
        }
        this.ra = ra;
        this.rp = rp;
        this.aaManager = aaManager;
        this.uiCreator = uiCreator;
    }

    protected void closing() throws ComponentException {
        if (this.ra != null) {
            this.ra = null;
        }
        if (this.rp != null) {
            this.rp = null;
        }
        if (this.aaManager != null) {
            this.aaManager = null;
        }
        if (this.uiCreator != null) {
            this.uiCreator = null;
        }
    }

    public String getID() {
        return "TLEController";
    }

    public String getDescription() {
        return "TLEController";
    }

    void processingRequest(HttpServletRequest request, HttpServletResponse response) throws ComponentException, RequestAnalyzerException {
        RequestInfo requestInfo = this.ra.analyzeRequest(request, response);
        Object realRequest = null;
        RequestInfo realRequestInfo = null;
        if (this.useWrapper) {
            realRequest = new RIRequestWrapper(request, requestInfo);
            realRequestInfo = new RequestInfoWrapper(requestInfo);
        } else {
            realRequest = request;
            realRequestInfo = requestInfo;
        }
        User user = this.aaManager.getSessionUser((HttpServletRequest)realRequest);
        Service service = this.aaManager.getService(realRequestInfo);
        boolean enable = false;
        try {
            if (service.isNeedAuthentication()) {
                if (user instanceof NullUser) {
                    this.uiCreator.createAuthenticationForm((HttpServletRequest)realRequest, response);
                    return;
                }
                enable = service.isAllRolesUsable() ? true : this.aaManager.checkAuthorization(user, service);
            } else {
                enable = true;
            }
            if (enable) {
                Result result = this.rp.process(realRequestInfo);
                if (result.isErrorOccured()) {
                    this.uiCreator.createErrorView(result, (HttpServletRequest)realRequest, response);
                } else {
                    this.uiCreator.createView(result, (HttpServletRequest)realRequest, response);
                }
            } else {
                this.uiCreator.createNoAuthorizationView(realRequestInfo, (HttpServletRequest)realRequest, response);
            }
        }
        catch (Throwable e) {
            Logger.fatal(e.getMessage(), e);
            this.uiCreator.createErrorView(e, request, response);
        }
    }
}

