/*
 * Ʈ: TLE2Framework
 * ϸ: Component.java
 * ۼ: 2004. 10. 12.
 */
package tle.framework.component;

/**
 * Ʋ ӿũ Ǵ  Ʈ ؾ ϴ ̴̽.
 * <p>
 * Ʈ Ŭ õ ޼ҵ带 Ѵ.
 * <p>
 * Ʋ ӿũ ϵǴ  Ʈ JMX MBean  MBean ϵǾ ϱ 
 * Ʋ ӿũ Ʈ MBean̾ Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public interface Component {
	/**
	 * Ʈ ̵ Ѵ.
	 * @return
	 */
	public String getID();
	/**
	 * Ʈ ʱȭѴ.
	 * 
	 * @param config Ʈ    ִ.
	 * @throws ComponentException
	 */
	public void init(ComponentConfig config) throws ComponentException;

	/**
	 * Ʈ Ѵ.
	 * 
	 * @throws ComponentException
	 */
	public void start() throws ComponentException;

	/**
	 * Ʈ  Ͻ Ѵ.
	 * 
	 * @throws ComponentException
	 */
	public void suspend() throws ComponentException;

	/**
	 * Ͻ  Ʈ  Ѵ.
	 * 
	 * @throws ComponentException
	 */
	public void resume() throws ComponentException;
	
	/**
	 * Ʈ Ѵ.
	 * 
	 * @throws ComponentException
	 */
	public void stop() throws ComponentException;
	
	/**
	 * Ʈ Ѵ.
	 * 
	 * @throws ComponentException
	 */
	public void close() throws ComponentException;
	
	/**
	 * Ʈ    true Ѵ.
	 * @return
	 */
	public boolean isCreated();
	/**
	 * Ʈ ʱȭ   true Ѵ. 
	 * @return
	 */
	public boolean isIniting();
	/**
	 * Ʈ ʱȭ   true Ѵ.
	 * @return
	 */
	public boolean isInited();
	/**
	 * Ʈ    true Ѵ.
	 * @return
	 */
	public boolean isStarting();
	/**
	 * Ʈ    true Ѵ.
	 * @return
	 */
	public boolean isRunning();
	/**
	 * Ʈ    true Ѵ.
	 * @return
	 */
	public boolean isSuspending();
	/**
	 * Ʈ    true Ѵ.
	 * @return
	 */
	public boolean isSuspended();
	/**
	 * Ʈ    true Ѵ.
	 * @return
	 */
	public boolean isResuming();
	/**
	 * Ʈ    true Ѵ.
	 * @return
	 */
	public boolean isStopping();
	/**
	 * Ʈ    true Ѵ.
	 * @return
	 */
	public boolean isStopped();
	/**
	 * Ʈ    true Ѵ.
	 * @return
	 */
	public boolean isClosing();
	/**
	 * Ʈ    true Ѵ.
	 * @return
	 */
	public boolean isClosed();
	/**
	 * Ʈ ó   true Ѵ.
	 * @return
	 */
	public boolean isErrorOccured();
}