/*
 * Ʈ: TLE2Framework
 * ϸ: AAManagerProxy.java
 * ۼ: 2004. 11. 10
 */
package tle.framework.component.spi.aamanager;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import tle.framework.component.spi.ra.RequestInfo;

/**
 * AAManager  Ͻ Ŭ
 * <p>
 * AAManager ϴ  ʿ ϴ Ŭ    Ŭ ؼ 
 * AAManager   ϰ ȴ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class AAManagerProxy {
	private AAManager aaManager;
	public AAManagerProxy(AAManager aaManager) {
		this.aaManager = aaManager;
	}
	public User authenticate(UserAuthenticationInfo authInfo)
			throws AAManagerException {
		return aaManager.authenticate(authInfo);
	}

	public void openSession(User user, HttpServletRequest request,
			HttpServletResponse response) throws AAManagerException {
		aaManager.openSession(user, request, response);
	}

	public void closeSession(HttpServletRequest request,
			HttpServletResponse response) throws AAManagerException {
		aaManager.closeSession(request, response);
	}

	public User getSessionUser(HttpServletRequest request)
			throws AAManagerException {
		return aaManager.getSessionUser(request);
	}

	public boolean checkAuthorization(User user, Service service)
			throws AAManagerException {
		return aaManager.checkAuthorization(user, service);
	}

	public Service getService(RequestInfo requestInfo)
			throws AAManagerException {
		return aaManager.getService(requestInfo);
	}
	
	public Role getRole(String roleID) throws AAManagerException {
		return aaManager.getRole(roleID);
	}
}
