/*
 * Ʈ: TLE2Framework
 * ϸ: TLEConfig.java
 * ۼ: 2004. 10. 18
 */
package tle.framework.configuration;

import java.util.Iterator;
import java.util.Map;

import tle.framework.component.ComponentConfig;

/**
 * Ʋ ӿũ   ϴ Ŭ.       Ѵ.
 * <pre>
 * 
 * &lt;?xml version="1.0" encoding="euc-kr" ?>
 *  
 *  &lt;tle>
 *      &lt;component-list>
 *          &lt;!-- component-id   'TLEController' ü . -->
 *          
 *          &lt;component>
 *              &lt;component-class>ƮŬǿ̸&lt;/component-class>
 *              &lt;component-id>ƮID&lt;/component-id>
 *              &lt;!-- Ʈ ʱȭ Ķ -->
 *              &lt;init-param>
 *                  &lt;param-name>param1&lt;/param-name>
 *                  &lt;param-value>value1&lt;/param-value>
 *              &lt;/init-param>
 *              &lt;init-param>
 *                  &lt;param-name>param2&lt;/param-name>
 *                  &lt;param-value>value2&lt;/param-value>
 *              &lt;/init-param>
 *          &lt;/component>
 *          
 *          
 *          ... &lt;!--  Ʈ   -->
 *          
 *      &lt;/component-list>
 *      
 *      &lt;framework>
 *          &lt;core-component>
 *              &lt;request-analyzer-id>DefaultRequestAnalyzer&lt;/request-analyzer-id>
 *              &lt;request-processor-id>DefaultRequestProcessor&lt;/request-processor-id>
 *              &lt;ui-creator-id>DefaultUICreator&lt;/ui-creator-id>
 *              &lt;aa-manager-id>DefaultAAManager&lt;/aa-manager-id>
 *          &lt;/core-component>
 *      &lt;/framework>
 *  &lt;/tle>
 *  
 * </pre>
 * 
 * <p>component ±  ڽ Ҵ  .
 * <ul>
 *   <li>component-class : Ʈ Ŭ  ̸
 *   <li>component-id : Ʈ ĺϱ  ID
 *   <li>init-param : ʱȭ Ķ
 * </ul>
 * component ±   ComponentConfig ü Ǿ 
 *  Ʈ ʱȭ  ڷ ޵ȴ.
 * 
 * <p>core-component ±״ Ʋ ӿũ ʿ ϴ 4 ٽ Ʈ
 *  Ʈ  Ѵ.  ڽ Ҵ  .
 * ݵ 4 ھ Ʈ ־Ѵ.
 * 
 * <ul>
 *   <li>request-analyzer-id : RequestAnalyzer Ʈ ID
 *   <li>request-processor-id : RequestProcessor Ʈ ID
 *   <li>ui-creator-id : UICreator Ʈ ID
 *   <li>aa-manager-id : AAManager Ʈ ID
 * </ul>
 *  
 * @author ֹ
 * @since 2.0
 */
public class TLEConfig {
	/**
	 * &lt;componentID, ComponentConfig>  Ѵ.
	 */
	private Map componentConfigMap = new java.util.HashMap();
	
	private String requestAnalyzerID;
	private String requestProcessorID;
	private String uiCreatorID;
	private String aaManagerID;
	
	private boolean useWrapper;
	
	public TLEConfig() {}
	
	public void addComponentConfig(ComponentConfig config) {
		componentConfigMap.put(config.getComponentID(), config);
	}
	public ComponentConfig getComponentConfig(String componentID) {
		return (ComponentConfig) componentConfigMap.get(componentID);
	}
	public Iterator getComponentConfigs() {
		return componentConfigMap.values().iterator();
	}
	
	public String getAAManagerID() {
		return aaManagerID;
	}
	public void setAAManagerID(String aaManagerID) {
		this.aaManagerID = aaManagerID;
	}
	public String getRequestAnalyzerID() {
		return requestAnalyzerID;
	}
	public void setRequestAnalyzerID(String requestAnalyzerID) {
		this.requestAnalyzerID = requestAnalyzerID;
	}
	public String getRequestProcessorID() {
		return requestProcessorID;
	}
	public void setRequestProcessorID(String requestProcessorID) {
		this.requestProcessorID = requestProcessorID;
	}
	public String getUICreatorID() {
		return uiCreatorID;
	}
	public void setUICreatorID(String uiCreatorID) {
		this.uiCreatorID = uiCreatorID;
	}
	
	/**
	 * @since 2.0.5.3
	 */
	public void setUseWrapper(String useWrapper) {
		this.useWrapper = Boolean.valueOf(useWrapper).booleanValue();
	}
	/**
	 * @since 2.0.5.3
	 */
	public boolean getUseWrapper() {
		return useWrapper;
	}
}
