/*
 * Ʈ: TLE2Framework
 * ϸ: StateMachine.java
 * ۼ: 2004. 10. 13.
 */
package tle.framework.util.statemachine;

/**
 * State Machine Ÿ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class StateMachine {

	/**
	 *  ¸ Ÿ State νϽ  
	 */
	private State currentState = null;
	
	/**
	 * startState ̹ ٸ µ  Ϸ ̾ Ѵ.
	 * 
	 * @param startState  State Machine ϰ   ù° 
	 */
	public StateMachine(State startState) {
		this.currentState = startState;
	}
	
	/**
	 *  ° StartState νϽ  true Ѵ.
	 * 
	 * @return    true
	 */
	public boolean isStartState() {
		return currentState instanceof StartState;
	}

	/**
	 *  ° FinishState νϽ  true Ѵ.
	 * 
	 * @return    true
	 */
	public boolean isFinalState() {
		return currentState instanceof FinishState;
	}

	/**
	 *  ¸ Ѵ.
	 * 
	 * @return  
	 */
	public State getCurrentState() {
		return currentState;
	}

	/**
	 * ̺Ʈ ߻Ͽ ¸ Ѵ.
	 * 
	 * @param event ߻ ̺Ʈ ̸
	 * @throws IllegalStateException  ¿ ̺Ʈ ó Ұ  ߻Ѵ.
	 */
	public void transit(String event) {
		currentState = currentState.transit(event);
	}

	/**
	 *  ¸ Ÿ Ŭ.
	 * 
	 * @author ֹ
	 * @since 2.0
	 */
	public static class StartState extends State {
		public StartState(String stateName) {
			super(stateName);
		}

		/**
		 *  ̸ "START" 
		 */
		public StartState() {
			super("START");
		}
	}

	/**
	 *  ¸ Ÿ Ŭ
	 * 
	 * @author ֹ
	 * @since 2.0
	 */
	public static class FinishState extends State {
		public FinishState(String finalName) {
			super(finalName);
		}

		/**
		 *  ̸ "FINISH" 
		 */
		public FinishState() {
			super("FINISH");
		}

		/**
		 *  ̹Ƿ ̺Ʈ ߰ ҰϹǷ UnsupportedOperationException ߻Ų.
		 * 
		 * @throws UnsupportedOperationException
		 * @see tle.framework.util.statemachine.State#addEvent(java.lang.String,
		 *      tle.framework.util.statemachine.State)
		 */
		public void addEvent(String event, State state) {
			throw new UnsupportedOperationException();
		}

		/**
		 *  ¿  ̻ ̰ ҰϹǷ IllegalStateException ߻Ų.
		 * 
		 * @throws IllegalStateException
		 * @see tle.framework.util.statemachine.State#transit(java.lang.String)
		 */
		public State transit(String event) {
			throw new IllegalStateException(this.getStateName()+" State can't transfer to any state.");
		}
	}
}